/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.example;

import net.emphased.malle.MailAddressException;
import net.emphased.malle.MailAuthenticationException;
import net.emphased.malle.MailException;
import net.emphased.malle.MailSendException;

public abstract class AbstractExample {
    protected static void err(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    protected static void err(String msg, String details) {
        if (details != null) {
            msg = msg + " (" + details + ")";
        }
        AbstractExample.err(msg);
    }

    protected static <T> T checkNotNull(T ref, String msg) {
        AbstractExample.checkTrue(ref != null, msg);
        return ref;
    }

    protected static void checkTrue(boolean condition, String msg) {
        if (!condition) {
            AbstractExample.err(msg);
        }
    }

    protected static <T extends Throwable> void handleException(T e) throws T {
        if (e instanceof MailAddressException) {
            AbstractExample.err("Invalid address", e.getMessage());
        } else if (e instanceof MailSendException) {
            AbstractExample.err("Couldn't sent", e.getMessage());
        } else if (e instanceof MailAuthenticationException) {
            AbstractExample.err("Couldn't authenticate", e.getMessage());
        } else if (e instanceof MailException) {
            AbstractExample.err("Unexpected mail failure", e.getMessage());
        } else {
            throw e;
        }
    }
}

