/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.example.javamail;

import net.emphased.malle.Mail;
import net.emphased.malle.MailException;
import net.emphased.malle.example.AbstractExample;
import net.emphased.malle.javamail.Javamail;

public class JavamailExample
extends AbstractExample {
    public static void main(String[] args) {
        String from = System.getProperty("from");
        if (from == null) {
            from = System.getProperty("mail.user");
        }
        if (from == null) {
            JavamailExample.err((String)"Please set 'from' and/or 'mail.user' property");
        }
        String to = (String)JavamailExample.checkNotNull((Object)System.getProperty("to"), (String)"Please set 'to' property");
        String subject = (String)JavamailExample.checkNotNull((Object)System.getProperty("subject"), (String)"Please set 'subject' property");
        String plain = System.getProperty("plain");
        String html = System.getProperty("html");
        if (plain == null && html == null) {
            throw new IllegalArgumentException("Please set 'plain' and/or 'html' property");
        }
        System.out.println("Sending '" + subject + "' mail from " + from + " to " + to + "...");
        try {
            Mail mail = new Javamail().mail().from(from).to(to).subject(subject);
            if (plain != null) {
                mail.plain(plain);
            }
            if (html != null) {
                mail.html(html);
            }
            mail.send();
        }
        catch (MailException e) {
            JavamailExample.handleException((Throwable)e);
        }
        System.out.println("Success!");
    }
}

