/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.support;

import java.io.InputStream;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.util.Preconditions;

class SingleUseInputStreamSupplier
implements InputStreamSupplier {
    private final InputStream inputStream;
    private boolean used;

    public SingleUseInputStreamSupplier(InputStream inputStream) {
        this.inputStream = Preconditions.checkNotNull(inputStream);
    }

    public boolean isUsed() {
        return this.used;
    }

    public InputStream getInputStreamSafe() {
        return this.inputStream;
    }

    @Override
    public InputStream getInputStream() {
        if (this.used) {
            throw new IllegalStateException("This InputStreamSupplier implementation is single use only");
        }
        this.used = true;
        return this.inputStream;
    }
}

