/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.util.Preconditions;

class ByteArrayInputStreamSupplier
implements InputStreamSupplier {
    private final byte[] bytes;
    private final int offset;
    private final int size;

    public ByteArrayInputStreamSupplier(byte[] bytes, int offset, int size) {
        this.bytes = Preconditions.checkNotNull(bytes);
        Preconditions.checkArgument(offset >= 0);
        Preconditions.checkArgument(offset + size <= bytes.length);
        this.offset = offset;
        Preconditions.checkArgument(size >= 0);
        this.size = size;
    }

    public ByteArrayInputStreamSupplier(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.size);
    }
}

