/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.support;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.support.ByteProducer;
import net.emphased.malle.support.InputStreamWrapper;

class ByteProducerInputStreamSupplier
implements InputStreamSupplier {
    private final ByteProducer producer;

    public ByteProducerInputStreamSupplier(ByteProducer producer) {
        this.producer = producer;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        FileInputStream r;
        final Path tempFile = Files.createTempFile("malle_", "", new FileAttribute[0]);
        try {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile.toFile()));){
                this.producer.writeTo(os);
            }
            r = new FileInputStream(tempFile.toFile());
        }
        catch (RuntimeException outer) {
            try {
                Files.delete(tempFile);
            }
            catch (IOException inner) {
                outer.addSuppressed(inner);
            }
            throw outer;
        }
        return new InputStreamWrapper(new BufferedInputStream(r)){

            @Override
            public void close() throws IOException {
                IOException outer = null;
                try {
                    super.close();
                }
                catch (IOException e) {
                    outer = e;
                }
                try {
                    Files.delete(tempFile);
                }
                catch (IOException e) {
                    if (outer != null) {
                        outer.addSuppressed(e);
                    }
                    outer = e;
                }
                if (outer != null) {
                    throw outer;
                }
            }
        };
    }
}

