/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.javamail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.MailIOException;
import net.emphased.malle.util.Preconditions;

class InputStreamSupplierDatasource
implements DataSource {
    private final InputStreamSupplier inputStreamSupplier;
    private final String contentType;
    private final String name;

    public InputStreamSupplierDatasource(InputStreamSupplier inputStreamSupplier, String contentType, String name) {
        Preconditions.checkNotNull((Object)inputStreamSupplier, (Object)"The 'inputStreamSupplier' must not be null");
        Preconditions.checkNotNull((Object)contentType, (Object)"The 'contentType' must not be null");
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' must not be null");
        this.inputStreamSupplier = inputStreamSupplier;
        this.contentType = contentType;
        this.name = name;
    }

    public InputStreamSupplier getInputStreamSupplier() {
        return this.inputStreamSupplier;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.inputStreamSupplier.getInputStream();
        }
        catch (MailIOException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }
}

