/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.javamail;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.emphased.malle.Mail;
import net.emphased.malle.MailSendException;
import net.emphased.malle.MailSystem;
import net.emphased.malle.javamail.JavamailMessage;
import net.emphased.malle.javamail.MultipartMode;
import net.emphased.malle.javamail.Utils;
import net.emphased.malle.template.MailTemplate;
import net.emphased.malle.template.MailTemplateEngine;
import net.emphased.malle.util.Preconditions;

public class Javamail
implements MailSystem {
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final String PASSWORD_PROP = "malle.javamail.password";
    private final Object monitor = new Object();
    private Session session;
    private Map<String, String> properties = new HashMap<String, String>();
    private MailTemplateEngine templateEngine;

    public Mail mail() {
        return this.mail(true);
    }

    public Mail mail(boolean multipart) {
        return this.createMail(multipart ? MultipartMode.MIXED_RELATED : MultipartMode.NONE);
    }

    public void send(Mail ... mail) {
        this.send(Utils.toIterable(mail));
    }

    public void send(Iterable<? extends Mail> mail) {
        for (Mail mail2 : mail) {
            Preconditions.checkArgument((boolean)(mail2 instanceof JavamailMessage), (String)"Expected instance of JavamailMessage but found: %s", (Object[])new Object[]{mail2 != null ? mail2.getClass() : null});
        }
        Iterable<? extends Mail> messages = mail;
        this.doSend(messages);
    }

    void applyTemplate(JavamailMessage message, String name, @Nullable Locale locale, Map<String, ?> context) {
        Preconditions.checkState((this.templateEngine != null ? 1 : 0) != 0, (Object)"Please the the template engine first");
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' can't be null");
        MailTemplate t = this.templateEngine.getTemplate(name, locale);
        this.applyTemplate(message, t, context);
    }

    void applyTemplate(JavamailMessage message, MailTemplate template, Map<String, ?> context) {
        template.apply((Mail)message, context);
    }

    private Mail createMail(MultipartMode multipartMode) {
        return new JavamailMessage(this, multipartMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(Iterable<JavamailMessage> messages) {
        try {
            Session s = this.getOrCreateSession();
            Transport t = s.getTransport(this.getProtocol(s));
            boolean connected = false;
            try {
                for (JavamailMessage jmsg : messages) {
                    MimeMessage m = jmsg.getMimeMessage();
                    Address[] addrs = m.getAllRecipients();
                    if (addrs == null || addrs.length == 0) {
                        throw new MailSendException("No mail recipients specified");
                    }
                    if (!connected) {
                        t.connect(null, -1, null, this.getPassword(s));
                        connected = true;
                    }
                    this.doSend(t, m, addrs);
                }
            }
            finally {
                if (connected) {
                    t.close();
                }
            }
        }
        catch (MessagingException e) {
            throw Utils.wrapException(e);
        }
    }

    private void doSend(Transport t, MimeMessage m, Address[] addrs) throws MessagingException {
        t.sendMessage((Message)m, addrs);
    }

    private String getPassword(Session s) {
        return s.getProperty(PASSWORD_PROP);
    }

    private String getProtocol(Session s) {
        String r = s.getProperty("mail.transport.protocol");
        return r != null ? r : DEFAULT_PROTOCOL;
    }

    private Address[] parseAddresses(String[] addrs) throws AddressException {
        Address[] r = new Address[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            r[i] = new InternetAddress(addrs[i]);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getOrCreateSession() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.session == null) {
                Properties props = (Properties)System.getProperties().clone();
                props.putAll(this.properties);
                this.session = Session.getInstance((Properties)props);
            }
            return this.session;
        }
    }

    public void setSession(@Nullable Session session) {
        this.session = session;
    }

    public Javamail withSession(@Nullable Session session) {
        this.setSession(session);
        return null;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
        this.setSession(null);
    }

    public Javamail withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public Javamail withProperty(String name, String value) {
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' must not be null");
        Preconditions.checkNotNull((Object)value, (Object)"The 'value' must not be null");
        this.properties.put(name, value);
        return this;
    }

    public void setTemplateEngine(MailTemplateEngine templateEngine) {
        Preconditions.checkNotNull((Object)templateEngine, (Object)"The 'templateEngine' must not be null");
        this.templateEngine = templateEngine;
    }

    public Javamail withTemplateEngine(MailTemplateEngine templateEngine) {
        this.setTemplateEngine(templateEngine);
        return this;
    }
}

