/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.javamail;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.AddressException;
import net.emphased.malle.GenericMailException;
import net.emphased.malle.MailAddressException;
import net.emphased.malle.MailAuthenticationException;
import net.emphased.malle.MailException;
import net.emphased.malle.MailSendException;

final class Utils {
    public static MailException wrapException(MessagingException e) {
        if (e instanceof AddressException) {
            return new MailAddressException((Throwable)e);
        }
        if (e instanceof SendFailedException) {
            return new MailSendException((Throwable)e);
        }
        if (e instanceof AuthenticationFailedException) {
            return new MailAuthenticationException((Throwable)e);
        }
        return new GenericMailException((Throwable)e);
    }

    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> type) {
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> Iterable<T> toIterable(final T[] array) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < array.length;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return array[this.i++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private Utils() {
    }
}

