/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.javamail;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import net.emphased.malle.AddressType;
import net.emphased.malle.BodyType;
import net.emphased.malle.Encoding;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.Mail;
import net.emphased.malle.MailIOException;
import net.emphased.malle.javamail.InputStreamSupplierDatasource;
import net.emphased.malle.javamail.Javamail;
import net.emphased.malle.javamail.MultipartMode;
import net.emphased.malle.javamail.Utils;
import net.emphased.malle.util.Preconditions;

class JavamailMessage
implements Mail {
    private final MultipartMode multipartMode;
    private final Javamail javamail;
    private Charset charset = DEFAULT_CHARSET;
    private final Map<BodyType, String> bodies = new EnumMap<BodyType, String>(BodyType.class);
    private Encoding bodyEncoding = DEFAULT_BODY_ENCODING;
    private Encoding attachmentEncoding = DEFAULT_ATTACHMENT_ENCODING;
    private final Map<AddressType, List<InternetAddress>> addresses = new EnumMap<AddressType, List<InternetAddress>>(AddressType.class);
    private final Map<Attachment.Type, List<Attachment>> attachments = new EnumMap<Attachment.Type, List<Attachment>>(Attachment.Type.class);
    private String id;
    private Integer priority;
    private String subject;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private static final Map<Encoding, String> ENCODING_TO_RFC;

    JavamailMessage(Javamail javamail, MultipartMode multipartMode) {
        Preconditions.checkNotNull((Object)javamail, (Object)"The 'javamail' can't be null");
        Preconditions.checkNotNull((Object)((Object)multipartMode), (Object)"The 'multipartMode' can't be null");
        this.multipartMode = multipartMode;
        this.javamail = javamail;
    }

    MimeMessage getMimeMessage() {
        return new MimeMessageBuilder().build();
    }

    public Mail charset(Charset charset) {
        Preconditions.checkNotNull((Object)charset, (Object)"The 'charset' can't be null");
        this.charset = charset;
        return this;
    }

    public Mail charset(String charset) {
        this.charset(Charset.forName(charset));
        return this;
    }

    public Mail bodyEncoding(@Nullable Encoding encoding) {
        this.bodyEncoding = encoding;
        return this;
    }

    public Mail attachmentEncoding(Encoding encoding) {
        Preconditions.checkNotNull((Object)encoding, (Object)"The 'encoding' must not be null");
        this.attachmentEncoding = encoding;
        return this;
    }

    public Mail id(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"The 'id' can't be null");
        this.id = id;
        return this;
    }

    public Mail priority(int priority) {
        this.priority = priority;
        return this;
    }

    public Mail from(Iterable<String> addresses) {
        return this.address(AddressType.FROM, addresses);
    }

    public Mail from(String[] addresses) {
        return this.address(AddressType.FROM, addresses);
    }

    public Mail from(String addresses) {
        return this.address(AddressType.FROM, addresses);
    }

    public Mail from(String address, @Nullable String personal) {
        return this.address(AddressType.FROM, address, personal);
    }

    public Mail replyTo(Iterable<String> addresses) {
        return this.address(AddressType.REPLY_TO, addresses);
    }

    public Mail replyTo(String[] addresses) {
        return this.address(AddressType.REPLY_TO, addresses);
    }

    public Mail replyTo(String addresses) {
        return this.address(AddressType.REPLY_TO, addresses);
    }

    public Mail replyTo(String address, @Nullable String personal) {
        return this.address(AddressType.REPLY_TO, address, personal);
    }

    public Mail to(Iterable<String> addresses) {
        return this.address(AddressType.TO, addresses);
    }

    public Mail to(String[] addresses) {
        return this.address(AddressType.TO, addresses);
    }

    public Mail to(String addresses) {
        return this.address(AddressType.TO, addresses);
    }

    public Mail to(String address, @Nullable String personal) {
        return this.address(AddressType.TO, address, personal);
    }

    public Mail cc(Iterable<String> addresses) {
        return this.address(AddressType.CC, addresses);
    }

    public Mail cc(String[] addresses) {
        return this.address(AddressType.CC, addresses);
    }

    public Mail cc(String addresses) {
        return this.address(AddressType.CC, addresses);
    }

    public Mail cc(String address, @Nullable String personal) {
        return this.address(AddressType.CC, address, personal);
    }

    public Mail bcc(Iterable<String> addresses) {
        return this.address(AddressType.BCC, addresses);
    }

    public Mail bcc(String addresses) {
        return this.address(AddressType.BCC, addresses);
    }

    public Mail bcc(String[] addresses) {
        return this.address(AddressType.BCC, addresses);
    }

    public Mail bcc(String address, @Nullable String personal) {
        return this.address(AddressType.BCC, address, personal);
    }

    public Mail address(AddressType type, Iterable<String> addresses) {
        for (String a : addresses) {
            this.address(type, a);
        }
        return this;
    }

    public Mail address(AddressType type, String[] addresses) {
        return this.address(type, Utils.toIterable(addresses));
    }

    public Mail address(AddressType type, String addresses) {
        for (InternetAddress ia : this.parseAddresses(addresses)) {
            this.address(type, ia);
        }
        return this;
    }

    public Mail address(AddressType type, String address, @Nullable String personal) {
        return this.address(type, this.createAddress(address, personal));
    }

    public Mail subject(String subject) {
        Preconditions.checkNotNull((Object)subject, (Object)"The 'subject' must not be null");
        this.subject = subject;
        return this;
    }

    public Mail header(String name, String value) {
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' must not be null");
        Preconditions.checkNotNull((Object)value, (Object)"The 'value' must not be null");
        this.headers.put(name, value);
        return this;
    }

    public Mail plain(String plain) {
        Preconditions.checkNotNull((Object)plain, (Object)"The 'plain' must not be null");
        return this.body(BodyType.PLAIN, plain);
    }

    public Mail html(String html) {
        Preconditions.checkNotNull((Object)html, (Object)"The 'html' must not be null");
        return this.body(BodyType.HTML, html);
    }

    public Mail body(BodyType type, String value) {
        Preconditions.checkNotNull((Object)type, (Object)"The 'type' must not be null");
        Preconditions.checkNotNull((Object)value, (Object)"The 'value' must not be null");
        if (!(this.isMultipart() || this.bodies.isEmpty() || this.bodies.containsKey(type))) {
            this.checkMultipart();
        }
        this.bodies.put(type, value);
        return this;
    }

    public Mail attachment(InputStreamSupplier content, String name, @Nullable String type) {
        return this.attachment(Attachment.Type.REGULAR, content, null, name, type);
    }

    public Mail attachment(InputStreamSupplier content, String name) {
        return this.attachment(content, name, null);
    }

    public Mail inline(InputStreamSupplier content, String id, @Nullable String type) {
        return this.attachment(Attachment.Type.INLINE, content, id, null, type);
    }

    private Mail attachment(Attachment.Type type, InputStreamSupplier content, @Nullable String id, @Nullable String name, @Nullable String contentType) {
        Preconditions.checkNotNull((Object)content, (Object)"The 'content' can't be null");
        if (type == Attachment.Type.INLINE) {
            Preconditions.checkNotNull((Object)id, (Object)"The 'id' can't be null");
        } else {
            Preconditions.checkNotNull((Object)name, (Object)"The 'name' can't be null");
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        this.checkMultipart();
        List<Attachment> list = this.attachments.get((Object)type);
        if (list == null) {
            list = new ArrayList<Attachment>();
            this.attachments.put(type, list);
        }
        list.add(new Attachment(type, content, id, name, contentType));
        return this;
    }

    public Mail inline(InputStreamSupplier content, String id) {
        return this.inline(content, id, "application/octet-stream");
    }

    public Mail template(String name, @Nullable Locale locale, Map<String, ?> context) {
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' can't be null");
        Preconditions.checkNotNull(context, (Object)"The 'context' can't be null");
        this.javamail.applyTemplate(this, name, locale, context);
        return this;
    }

    public Mail template(String name, Map<String, ?> context) {
        return this.template(name, null, context);
    }

    public Mail template(String name, @Nullable Locale locale, Object ... context) {
        Map<String, Object> contextMap;
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' can't be null");
        Preconditions.checkNotNull((Object)context, (Object)"The 'context' can't be null");
        Preconditions.checkArgument((context.length % 2 == 0 ? 1 : 0) != 0, (Object)"The 'context' varargs must contain an even number of values");
        if (context.length != 0) {
            int len = context.length / 2;
            contextMap = new HashMap(len);
            for (int i = 0; i < len; ++i) {
                Object key = context[i * 2];
                if (!(key instanceof String)) {
                    Preconditions.checkArgument((boolean)false, (Object)"The keys in 'context' must be of String type");
                }
                Object value = context[i * 2 + 1];
                contextMap.put((String)key, value);
            }
        } else {
            contextMap = Collections.emptyMap();
        }
        return this.template(name, locale, contextMap);
    }

    public Mail template(String name, Object ... context) {
        return this.template(name, null, context);
    }

    public Mail send() {
        this.javamail.send(this);
        return this;
    }

    public Mail writeTo(OutputStream outputStream) {
        try {
            this.getMimeMessage().writeTo(outputStream);
        }
        catch (IOException e) {
            throw new MailIOException((Throwable)e);
        }
        catch (MessagingException e) {
            throw Utils.wrapException(e);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mail writeTo(Path path) {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path.toFile()));){
            Mail mail = this.writeTo(os);
            return mail;
        }
        catch (IOException e) {
            throw new MailIOException((Throwable)e);
        }
    }

    public Mail writeTo(String path) {
        return this.writeTo(Paths.get(path, new String[0]));
    }

    private Mail address(AddressType type, InternetAddress address) {
        List<InternetAddress> l = this.addresses.get(type);
        if (l == null) {
            l = new ArrayList<InternetAddress>();
            this.addresses.put(type, l);
        }
        l.add(address);
        return this;
    }

    private InternetAddress[] parseAddresses(String addresses) {
        try {
            InternetAddress[] r = InternetAddress.parse((String)addresses, (boolean)false);
            for (int i = 0; i < r.length; ++i) {
                InternetAddress ia = r[i];
                String personal = ia.getPersonal();
                r[i] = new InternetAddress(ia.getAddress(), personal, this.charset.name());
            }
            return r;
        }
        catch (AddressException e) {
            throw Utils.wrapException((MessagingException)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    private InternetAddress createAddress(String address, @Nullable String personal) {
        InternetAddress r;
        Preconditions.checkNotNull((Object)address, (Object)"The 'address' can't be null");
        try {
            r = new InternetAddress(address, personal, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
        try {
            r.validate();
        }
        catch (AddressException e) {
            throw Utils.wrapException((MessagingException)((Object)e));
        }
        return r;
    }

    private static void setContentTransferEncodingHeader(Part part, @Nullable Encoding encoding) throws MessagingException {
        if (encoding != null) {
            part.setHeader("Content-Transfer-Encoding", (String)Preconditions.checkNotNull((Object)ENCODING_TO_RFC.get(encoding)));
        } else {
            part.removeHeader("Content-Transfer-Encoding");
        }
    }

    private boolean isMultipart() {
        return this.multipartMode != MultipartMode.NONE;
    }

    private void checkMultipart() {
        if (!this.isMultipart()) {
            throw new UnsupportedOperationException("The requested feature requires a multipart message. Please use MailSystem.mail([true])");
        }
    }

    static {
        EnumMap<Encoding, String> m = new EnumMap<Encoding, String>(Encoding.class);
        m.put(Encoding.BASE64, "base64");
        m.put(Encoding.QUOTED_PRINTABLE, "quoted-printable");
        m.put(Encoding.EIGHT_BIT, "8bit");
        m.put(Encoding.SEVEN_BIT, "7bit");
        m.put(Encoding.BINARY, "binary");
        ENCODING_TO_RFC = Collections.unmodifiableMap(m);
        if (Encoding.values().length != ENCODING_TO_RFC.size()) {
            throw new AssertionError((Object)"Not all Encoding values have mappings in ENCODING_TO_RFC");
        }
    }

    private static class Attachment {
        private final Type type;
        private final InputStreamSupplier content;
        private final String id;
        private final String name;
        private final String contentType;

        public Attachment(Type type, InputStreamSupplier content, @Nullable String id, @Nullable String name, String contentType) {
            this.type = type;
            this.content = content;
            this.id = id;
            this.name = name;
            this.contentType = contentType;
        }

        public BodyPart createBodyPart(Encoding encoding, @Nullable Charset charset) throws MessagingException {
            MimeBodyPart r = new MimeBodyPart();
            r.setDisposition(this.type == Type.INLINE ? "inline" : "attachment");
            if (this.id != null) {
                r.setContentID('<' + this.id + '>');
            }
            if (this.name != null) {
                Preconditions.checkNotNull((Object)charset);
                try {
                    r.setFileName(MimeUtility.encodeWord((String)this.name, (String)charset.name(), null));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Shouldn't happen", ex);
                }
            }
            r.setDataHandler(new DataHandler((DataSource)new InputStreamSupplierDatasource(this.content, this.contentType, this.type == Type.INLINE ? "inline" : this.name)));
            JavamailMessage.setContentTransferEncodingHeader((Part)r, encoding);
            return r;
        }

        private static enum Type {
            REGULAR,
            INLINE;

        }
    }

    private class MimeMessageBuilder {
        private MimeMessage root;
        private final Map<Attachment.Type, MimeMultipart> attachmentParts = new EnumMap<Attachment.Type, MimeMultipart>(Attachment.Type.class);

        private MimeMessageBuilder() {
        }

        private void buildParts() throws MessagingException {
            MimeMultipart inlinePart;
            MimeMultipart attachmentPart;
            this.root = new MimeMessage((Session)null);
            switch (JavamailMessage.this.multipartMode) {
                case NONE: {
                    attachmentPart = null;
                    inlinePart = null;
                    break;
                }
                case MIXED: {
                    attachmentPart = new MimeMultipart("mixed");
                    this.root.setContent((Multipart)attachmentPart);
                    inlinePart = attachmentPart;
                    break;
                }
                case RELATED: {
                    attachmentPart = new MimeMultipart("related");
                    this.root.setContent((Multipart)attachmentPart);
                    inlinePart = attachmentPart;
                    break;
                }
                case MIXED_RELATED: {
                    attachmentPart = new MimeMultipart("mixed");
                    this.root.setContent((Multipart)attachmentPart);
                    inlinePart = new MimeMultipart("related");
                    MimeBodyPart relatedBodyPart = new MimeBodyPart();
                    relatedBodyPart.setContent((Multipart)inlinePart);
                    attachmentPart.addBodyPart((BodyPart)relatedBodyPart);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled MultipartMode: " + (Object)((Object)JavamailMessage.this.multipartMode)));
                }
            }
            this.attachmentParts.put(Attachment.Type.REGULAR, attachmentPart);
            this.attachmentParts.put(Attachment.Type.INLINE, inlinePart);
        }

        private void buildAddresses() throws MessagingException {
            block7: for (Map.Entry entry : JavamailMessage.this.addresses.entrySet()) {
                List l = (List)entry.getValue();
                switch ((AddressType)entry.getKey()) {
                    case FROM: {
                        this.root.removeHeader("From");
                        if (l.isEmpty()) continue block7;
                        this.root.addFrom((Address[])Utils.toArray(l, InternetAddress.class));
                        continue block7;
                    }
                    case REPLY_TO: {
                        if (l.isEmpty()) continue block7;
                        this.root.setReplyTo((Address[])Utils.toArray(l, InternetAddress.class));
                        continue block7;
                    }
                    case TO: {
                        this.root.removeHeader("To");
                        if (l.isEmpty()) continue block7;
                        this.root.addRecipients(Message.RecipientType.TO, (Address[])Utils.toArray(l, InternetAddress.class));
                        continue block7;
                    }
                    case CC: {
                        this.root.removeHeader("CC");
                        if (l.isEmpty()) continue block7;
                        this.root.addRecipients(Message.RecipientType.CC, (Address[])Utils.toArray(l, InternetAddress.class));
                        continue block7;
                    }
                    case BCC: {
                        this.root.removeHeader("BCC");
                        if (l.isEmpty()) continue block7;
                        this.root.addRecipients(Message.RecipientType.BCC, (Address[])Utils.toArray(l, InternetAddress.class));
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("Unhandled RecipientType: " + entry.getKey()));
            }
        }

        private MimeBodyPart getOrCreateTextPart() throws MessagingException {
            MimeMultipart container = this.attachmentParts.get((Object)Attachment.Type.INLINE);
            if (container.getCount() == 0) {
                MimeBodyPart part = new MimeBodyPart();
                container.addBodyPart((BodyPart)part);
                return part;
            }
            return (MimeBodyPart)container.getBodyPart(0);
        }

        private void setText(String plain, String html) throws MessagingException {
            MimeMultipart messageBody = new MimeMultipart("alternative");
            this.getOrCreateTextPart().setContent((Object)messageBody, "text/alternative");
            MimeBodyPart plainTextPart = new MimeBodyPart();
            this.setPlainTextToMimePart((MimePart)plainTextPart, plain);
            messageBody.addBodyPart((BodyPart)plainTextPart);
            MimeBodyPart htmlTextPart = new MimeBodyPart();
            this.setHtmlToMimePart((MimePart)htmlTextPart, html);
            messageBody.addBodyPart((BodyPart)htmlTextPart);
        }

        private void setText(String text, boolean html) throws MessagingException {
            Object partToUse = JavamailMessage.this.isMultipart() ? this.getOrCreateTextPart() : this.root;
            if (html) {
                this.setHtmlToMimePart((MimePart)partToUse, text);
            } else {
                this.setPlainTextToMimePart((MimePart)partToUse, text);
            }
        }

        private void setPlainTextToMimePart(MimePart part, String text) throws MessagingException {
            this.setTextToMimePart(part, text, "text/plain", JavamailMessage.this.bodyEncoding);
        }

        private void setHtmlToMimePart(MimePart part, String text) throws MessagingException {
            this.setTextToMimePart(part, text, "text/html", JavamailMessage.this.bodyEncoding);
        }

        private void setTextToMimePart(MimePart mimePart, String text, String type, @Nullable Encoding encoding) throws MessagingException {
            mimePart.setContent((Object)text, type + "; charset=" + JavamailMessage.this.charset.name());
            JavamailMessage.setContentTransferEncodingHeader((Part)mimePart, encoding);
        }

        private void buildBodies() throws MessagingException {
            String plain = (String)JavamailMessage.this.bodies.get(BodyType.PLAIN);
            String html = (String)JavamailMessage.this.bodies.get(BodyType.HTML);
            if (plain != null && html != null) {
                JavamailMessage.this.checkMultipart();
                this.setText(plain, html);
            } else if (plain != null) {
                this.setText(plain, false);
            } else if (html != null) {
                this.setText(html, true);
            } else {
                throw new IllegalStateException("The message must have plain and/or html text set");
            }
        }

        private void buildAttachments() throws MessagingException {
            for (Map.Entry entry : JavamailMessage.this.attachments.entrySet()) {
                MimeMultipart target = this.attachmentParts.get(entry.getKey());
                for (Attachment att : (List)entry.getValue()) {
                    BodyPart part = att.createBodyPart(JavamailMessage.this.attachmentEncoding, JavamailMessage.this.charset);
                    target.addBodyPart(part);
                }
            }
        }

        public MimeMessage build() {
            this.root = null;
            this.attachmentParts.clear();
            try {
                this.buildParts();
                try {
                    for (Map.Entry header : JavamailMessage.this.headers.entrySet()) {
                        this.root.addHeader((String)header.getKey(), MimeUtility.fold((int)(((String)header.getKey()).length() + 2), (String)MimeUtility.encodeText((String)((String)header.getValue()), (String)JavamailMessage.this.charset.name(), null)));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Shouldn't happen", e);
                }
                if (JavamailMessage.this.priority != null) {
                    this.root.setHeader("X-Priority", String.valueOf(JavamailMessage.this.priority));
                }
                if (JavamailMessage.this.subject != null) {
                    this.root.setSubject(JavamailMessage.this.subject, JavamailMessage.this.charset.name());
                }
                this.buildAddresses();
                this.buildBodies();
                this.buildAttachments();
                this.root.saveChanges();
                if (JavamailMessage.this.id != null) {
                    this.root.setHeader("Message-ID", '<' + JavamailMessage.this.id + '>');
                }
            }
            catch (MessagingException e) {
                throw Utils.wrapException(e);
            }
            return this.root;
        }
    }
}

