/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.servlet;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.emphased.malle.Mail;
import net.emphased.malle.MailIOException;
import net.emphased.malle.template.GenericMailTemplateException;
import net.emphased.malle.template.MailTemplate;
import net.emphased.malle.template.MailTemplateEngine;
import net.emphased.malle.template.servlet.DefaultServletTemplate;
import net.emphased.malle.template.servlet.DummyHttpServletRequest;
import net.emphased.malle.template.servlet.DummyHttpServletResponse;
import net.emphased.malle.template.servlet.Utils;
import net.emphased.malle.util.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;

public class ServletTemplateEngine
implements MailTemplateEngine {
    public static final String MAIL_ATTR = "net.emphased.malle.MAIL";
    private ServletContext servletContext;

    public MailTemplate getTemplate(Reader source, String name) {
        throw new UnsupportedOperationException("Obtaining template from source is not supported");
    }

    public MailTemplate getTemplate(String name, @Nullable Locale locale) {
        return new DefaultServletTemplate(this, name, locale);
    }

    public MailTemplate getTemplate(String name) {
        return this.getTemplate(name, null);
    }

    @Autowired(required=false)
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = (ServletContext)Preconditions.checkNotNull((Object)servletContext);
    }

    public ServletTemplateEngine withServletContext(ServletContext servletContext) {
        this.setServletContext(servletContext);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyTemplate(DefaultServletTemplate template, Mail mail, Map<String, ?> context) {
        Preconditions.checkNotNull((Object)this.servletContext, (Object)"The 'servletContext' must be set first");
        Preconditions.checkNotNull((Object)template, (Object)"The 'template' must not be null");
        Preconditions.checkNotNull((Object)mail, (Object)"The 'mail' must not be null");
        HashMap ctx = new HashMap(context != null ? context : Collections.emptyMap());
        Locale locale = template.getLocale();
        HttpServletRequest request = this.getContentProp(ctx, "net.emphased.malle.REQUEST", HttpServletRequest.class, null);
        if (request == null) {
            request = new DummyHttpServletRequest(this.servletContext, locale);
        }
        ctx.put(MAIL_ATTR, mail);
        if (Utils.JSTL_EXISTS && locale != null && ctx.get("javax.servlet.jsp.jstl.fmt.locale") == null) {
            ctx.put("javax.servlet.jsp.jstl.fmt.locale", locale);
        }
        for (Map.Entry prop : ctx.entrySet()) {
            request.setAttribute((String)prop.getKey(), prop.getValue());
        }
        try {
            RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(template.getName());
            if (dispatcher == null) {
                throw new GenericMailTemplateException("Couldn't get RequestDispatcher for: " + template.getName());
            }
            try {
                dispatcher.include((ServletRequest)request, (ServletResponse)new DummyHttpServletResponse(locale));
            }
            catch (ServletException e) {
                throw new GenericMailTemplateException((Throwable)e);
            }
            catch (IOException e) {
                throw new MailIOException((Throwable)e);
            }
        }
        finally {
            request.removeAttribute(MAIL_ATTR);
            for (Map.Entry prop : ctx.entrySet()) {
                request.removeAttribute((String)prop.getKey());
            }
        }
    }

    private <T> T getContentProp(Map<String, ?> context, String name, Class<T> clazz, T defaultValue) {
        Object r = context.remove(name);
        if (r == null) {
            return defaultValue;
        }
        Preconditions.checkArgument((boolean)clazz.isInstance(r), (String)"The context must have '%s' property be of type %s", (Object[])new Object[]{name, clazz.getSimpleName()});
        return clazz.cast(r);
    }

    private <T> T getContentProp(Map<String, ?> context, String name, Class<T> clazz) {
        T r = this.getContentProp(context, name, clazz, null);
        Preconditions.checkArgument((r != null ? 1 : 0) != 0, (String)"The context must have '%s' property set", (Object[])new Object[]{name});
        return r;
    }
}

