/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.servlet.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import net.emphased.malle.AddressType;
import net.emphased.malle.template.servlet.tag.Base;
import net.emphased.malle.util.Preconditions;

abstract class Address
extends Base {
    private final AddressType type;
    private String tagName;
    private String address;
    private String personal;

    public Address(AddressType type) {
        super(Base.TrimMode.both);
        this.type = type;
    }

    public AddressType getType() {
        return this.type;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPersonal() {
        return this.personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public void doTag() throws JspException, IOException {
        String body = this.getBody();
        if (this.address != null) {
            Preconditions.checkArgument((body == null || this.personal == null ? 1 : 0) != 0, (String)"[%s] Either body or 'personal' may be specified but not both", (Object[])new Object[]{this.getTagName()});
            String personal = body != null ? body : this.personal;
            this.getMail().address(this.type, this.address, personal);
        } else {
            Preconditions.checkArgument((body != null && this.personal == null ? 1 : 0) != 0, (String)"[%s] When 'address' attribute is not specified the body must provide a valid list of addresses with optional personal part. This usage type also forbids specifying 'personal' attribute", (Object[])new Object[]{this.getTagName()});
            this.getMail().address(this.type, body);
        }
    }

    private String getTagName() {
        if (this.tagName == null) {
            this.tagName = this.type.name().replace('_', '-').toLowerCase();
        }
        return this.tagName;
    }
}

