/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.servlet.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.Mail;
import net.emphased.malle.support.InputStreamSuppliers;
import net.emphased.malle.template.servlet.tag.Base;
import net.emphased.malle.util.Preconditions;

abstract class AttachmentBase
extends Base {
    private final boolean inline;
    private String type;
    private String file;
    private String url;
    private String resource;

    public AttachmentBase(boolean inline) {
        super(Base.TrimMode.none);
        this.inline = inline;
    }

    public void doTag() throws JspException, IOException {
        InputStreamSupplier iss = this.getInputStreamSupplier();
        String nameOrId = this.getNameOrId();
        Mail mail = this.getMail();
        if (this.inline) {
            mail.inline(iss, nameOrId, this.type);
        } else {
            mail.attachment(iss, nameOrId, this.type);
        }
    }

    private InputStreamSupplier getInputStreamSupplier() throws IOException, JspException {
        Preconditions.checkArgument((AttachmentBase.i(this.file != null) + AttachmentBase.i(this.url != null) + AttachmentBase.i(this.resource != null) == 1 ? 1 : 0) != 0, (String)"[%s] Either 'file', 'url', 'resource' or body may be specified", (Object[])new Object[]{this.getTagName()});
        if (this.file != null) {
            return InputStreamSuppliers.file((String)this.file);
        }
        if (this.url != null) {
            return InputStreamSuppliers.url((String)this.url);
        }
        if (this.resource != null) {
            return InputStreamSuppliers.resource((String)this.resource);
        }
        throw new AssertionError((Object)"Shouldn't happen");
    }

    private String getTagName() {
        return this.inline ? "inline" : "attachment";
    }

    private static int i(boolean b) {
        return b ? 1 : 0;
    }

    protected abstract String getNameOrId();

    public void setType(String type) {
        this.type = type;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

