/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.servlet.tag;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.emphased.malle.Mail;
import net.emphased.malle.util.Preconditions;

abstract class Base
extends SimpleTagSupport {
    private Mail mail;
    private String body;
    private boolean bodyReady;
    private TrimMode trim;

    public Base(TrimMode defaultTrim) {
        this.trim = defaultTrim;
    }

    protected Mail getMail() {
        return this.mail;
    }

    @Nullable
    protected String getBody() throws JspException, IOException {
        if (this.bodyReady) {
            return this.body;
        }
        JspFragment jspBody = this.getJspBody();
        if (jspBody == null) {
            this.body = null;
        } else {
            StringWriter sw = new StringWriter();
            jspBody.invoke((Writer)sw);
            this.body = this.trim(sw.toString());
        }
        this.bodyReady = true;
        return this.body;
    }

    protected String getNonNullBody() throws IOException, JspException {
        String r = this.getBody();
        return r != null ? r : "";
    }

    private String trim(String s) {
        switch (this.trim) {
            case none: {
                return this.trimFirstLineEndings(s, TrimMode.both);
            }
            case both: {
                return s.trim();
            }
            case leading: {
                return this.trimFirstLineEndings(s.replaceFirst("^\\s+", ""), TrimMode.trailing);
            }
            case trailing: {
                return this.trimFirstLineEndings(s.replaceFirst("\\s+$", ""), TrimMode.leading);
            }
        }
        throw new AssertionError((Object)("Unhandled mode: " + (Object)((Object)this.trim)));
    }

    private String trimFirstLineEndings(String s, TrimMode mode) {
        int i;
        if (mode == TrimMode.both || mode == TrimMode.leading) {
            i = 0;
            if (s.startsWith("\r\n")) {
                i += 2;
            } else if (s.startsWith("\r") || s.startsWith("\n")) {
                ++i;
            }
            s = s.substring(i);
        }
        if (mode == TrimMode.both || mode == TrimMode.trailing) {
            i = s.length();
            if (s.endsWith("\r\n")) {
                i -= 2;
            } else if (s.endsWith("\r") || s.endsWith("\n")) {
                --i;
            }
            s = s.substring(0, i);
        }
        return s;
    }

    protected TrimMode getTrimEnum() {
        return this.trim;
    }

    public void setTrim(String trim) {
        this.trim = TrimMode.valueOf(trim);
    }

    public void setJspContext(JspContext pc) {
        super.setJspContext(pc);
        this.init();
    }

    private void init() {
        this.mail = (Mail)this.getJspContext().getAttribute("net.emphased.malle.MAIL", 2);
        Preconditions.checkNotNull((Object)this.mail, (String)"The '%s' request attribute not found, is the JSP being invoked directly?", (Object[])new Object[]{"net.emphased.malle.MAIL"});
    }

    protected static enum TrimMode {
        none,
        leading,
        trailing,
        both;

    }
}

