/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle.template.servlet.tag;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import net.emphased.malle.Encoding;
import net.emphased.malle.Mail;
import net.emphased.malle.template.servlet.tag.Base;

public class Settings
extends Base {
    private String charset;
    private String bodyEncoding;
    private String attachmentEncoding;
    private static final Map<String, Encoding> STR_TO_ENCODING;

    public Settings() {
        super(Base.TrimMode.none);
    }

    public void doTag() throws JspException, IOException {
        Mail m = this.getMail();
        if (this.charset != null) {
            m.charset(this.charset);
        }
        if (this.bodyEncoding != null) {
            m.bodyEncoding(STR_TO_ENCODING.get(this.bodyEncoding));
        }
        if (this.attachmentEncoding != null) {
            m.attachmentEncoding(STR_TO_ENCODING.get(this.attachmentEncoding));
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setBodyEncoding(String bodyEncoding) {
        this.bodyEncoding = bodyEncoding;
    }

    public void setAttachmentEncoding(String attachmentEncoding) {
        this.attachmentEncoding = attachmentEncoding;
    }

    static {
        HashMap<String, Encoding> m = new HashMap<String, Encoding>();
        m.put("base64", Encoding.BASE64);
        m.put("quoted-printable", Encoding.QUOTED_PRINTABLE);
        m.put("8bit", Encoding.EIGHT_BIT);
        m.put("7bit", Encoding.SEVEN_BIT);
        m.put("binary", Encoding.BINARY);
        if (Encoding.values().length != m.size()) {
            throw new AssertionError((Object)"Not all Encoding values have mappings in STR_TO_ENCODING");
        }
        m.put("auto", null);
        STR_TO_ENCODING = Collections.unmodifiableMap(m);
    }
}

