/*
 * Decompiled with CFR 0.152.
 */
package net.emphased.malle;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.emphased.malle.AddressType;
import net.emphased.malle.BodyType;
import net.emphased.malle.Encoding;
import net.emphased.malle.InputStreamSupplier;
import net.emphased.malle.Mail;
import net.emphased.malle.template.MailTemplateEngine;
import net.emphased.malle.util.Preconditions;

public class MailMock
implements Mail {
    private MailTemplateEngine templateEngine;
    private final boolean multipart;
    private Charset charset = DEFAULT_CHARSET;
    private Encoding bodyEncoding = DEFAULT_BODY_ENCODING;
    private Encoding attachmentEncoding = DEFAULT_ATTACHMENT_ENCODING;
    private String id;
    private int priority;
    private final Map<AddressType, List<Address>> addresses;
    private final Map<BodyType, String> bodies;
    private String subject;
    private final List<Header> headers;
    private final List<Attachment> attachments;
    private final List<Inline> inlines;

    public MailMock(boolean multipart) {
        EnumMap m = new EnumMap(AddressType.class);
        for (AddressType at : AddressType.values()) {
            m.put(at, new ArrayList());
        }
        this.addresses = Collections.unmodifiableMap(m);
        this.bodies = new EnumMap<BodyType, String>(BodyType.class);
        this.headers = new ArrayList<Header>();
        this.attachments = new ArrayList<Attachment>();
        this.inlines = new ArrayList<Inline>();
        this.multipart = multipart;
    }

    public MailMock charset(Charset charset) {
        this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
        return this;
    }

    public MailMock charset(String charset) {
        return this.charset(Charset.forName(charset));
    }

    public MailMock bodyEncoding(@Nullable Encoding encoding) {
        this.bodyEncoding = encoding;
        return this;
    }

    public MailMock attachmentEncoding(Encoding encoding) {
        this.attachmentEncoding = (Encoding)Preconditions.checkNotNull((Object)encoding);
        return this;
    }

    public MailMock id(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        return this;
    }

    public MailMock priority(int priority) {
        this.priority = priority;
        return this;
    }

    public MailMock from(Iterable<String> addresses) {
        return this.address(AddressType.FROM, (Iterable)addresses);
    }

    public MailMock from(String[] addresses) {
        return this.address(AddressType.FROM, addresses);
    }

    public MailMock from(String addresses) {
        return this.address(AddressType.FROM, addresses);
    }

    public MailMock from(String address, @Nullable String personal) {
        return this.address(AddressType.FROM, address, personal);
    }

    public MailMock replyTo(Iterable<String> addresses) {
        return this.address(AddressType.REPLY_TO, (Iterable)addresses);
    }

    public MailMock replyTo(String[] addresses) {
        return this.address(AddressType.REPLY_TO, addresses);
    }

    public MailMock replyTo(String addresses) {
        return this.address(AddressType.REPLY_TO, addresses);
    }

    public MailMock replyTo(String address, @Nullable String personal) {
        return this.address(AddressType.REPLY_TO, address, personal);
    }

    public MailMock to(Iterable<String> addresses) {
        return this.address(AddressType.TO, (Iterable)addresses);
    }

    public MailMock to(String[] addresses) {
        return this.address(AddressType.TO, addresses);
    }

    public MailMock to(String addresses) {
        return this.address(AddressType.TO, addresses);
    }

    public MailMock to(String address, @Nullable String personal) {
        return this.address(AddressType.TO, address, personal);
    }

    public MailMock cc(Iterable<String> addresses) {
        return this.address(AddressType.CC, (Iterable)addresses);
    }

    public MailMock cc(String[] addresses) {
        return this.address(AddressType.CC, addresses);
    }

    public MailMock cc(String addresses) {
        return this.address(AddressType.CC, addresses);
    }

    public MailMock cc(String address, @Nullable String personal) {
        return this.address(AddressType.CC, address, personal);
    }

    public MailMock bcc(Iterable<String> addresses) {
        return this.address(AddressType.BCC, (Iterable)addresses);
    }

    public MailMock bcc(String addresses) {
        return this.address(AddressType.BCC, addresses);
    }

    public MailMock bcc(String[] addresses) {
        return this.address(AddressType.BCC, addresses);
    }

    public MailMock bcc(String address, @Nullable String personal) {
        return this.address(AddressType.BCC, address, personal);
    }

    public MailMock address(AddressType type, Iterable<String> addresses) {
        this.addresses.get(type).addAll(this.toAddressList(addresses));
        return this;
    }

    public MailMock address(AddressType type, String[] addresses) {
        return this.address(type, (Iterable)MailMock.toIterable(addresses));
    }

    public MailMock address(AddressType type, String addresses) {
        this.addresses.get(type).add(new EncodedAddress(addresses));
        return this;
    }

    public MailMock address(AddressType type, String address, @Nullable String personal) {
        this.addresses.get(type).add(new SplitAddress(address, personal));
        return this;
    }

    public MailMock subject(String subject) {
        this.subject = (String)Preconditions.checkNotNull((Object)subject);
        return this;
    }

    public MailMock header(String name, String value) {
        this.headers.add(new Header(name, value));
        return this;
    }

    public MailMock plain(String plain) {
        return this.body(BodyType.PLAIN, plain);
    }

    public MailMock html(String html) {
        return this.body(BodyType.HTML, html);
    }

    public MailMock body(BodyType type, String value) {
        this.bodies.put(type, value);
        return this;
    }

    public MailMock attachment(InputStreamSupplier content, String name, @Nullable String type) {
        this.attachments.add(new Attachment(content, name, type));
        return this;
    }

    public MailMock attachment(InputStreamSupplier content, String name) {
        return this.attachment(content, name, null);
    }

    public MailMock inline(InputStreamSupplier content, String id, @Nullable String type) {
        this.inlines.add(new Inline(content, id, type));
        return this;
    }

    public MailMock inline(InputStreamSupplier content, String id) {
        return this.inline(content, id, null);
    }

    public MailMock template(String name, @Nullable Locale locale, Map<String, ?> context) {
        Preconditions.checkState((this.templateEngine != null ? 1 : 0) != 0, (Object)"The 'templateEngine' must be set first");
        this.templateEngine.getTemplate(name, locale).apply((Mail)this, (Map)Preconditions.checkNotNull(context));
        return this;
    }

    public MailMock template(String name, @Nullable Locale locale, Object ... context) {
        Map<String, Object> contextMap;
        Preconditions.checkNotNull((Object)name, (Object)"The 'name' can't be null");
        Preconditions.checkNotNull((Object)context, (Object)"The 'context' can't be null");
        Preconditions.checkArgument((context.length % 2 == 0 ? 1 : 0) != 0, (Object)"The 'context' varargs must contain an even number of values");
        if (context.length != 0) {
            int len = context.length / 2;
            contextMap = new HashMap(len);
            for (int i = 0; i < len; ++i) {
                Object key = context[i * 2];
                if (!(key instanceof String)) {
                    Preconditions.checkArgument((boolean)false, (Object)"The keys in 'context' must be of String type");
                }
                Object value = context[i * 2 + 1];
                contextMap.put((String)key, value);
            }
        } else {
            contextMap = Collections.emptyMap();
        }
        return this.template(name, locale, (Map)contextMap);
    }

    public MailMock template(String name, Map<String, ?> context) {
        return this.template(name, (Locale)null, (Map)context);
    }

    public MailMock template(String name, Object ... context) {
        return this.template(name, null, context);
    }

    public MailMock send() {
        throw new UnsupportedOperationException();
    }

    public MailMock writeTo(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public MailMock writeTo(Path path) {
        throw new UnsupportedOperationException();
    }

    public MailMock writeTo(String path) {
        return this.writeTo(Paths.get(path, new String[0]));
    }

    public MailTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(MailTemplateEngine templateEngine) {
        this.templateEngine = (MailTemplateEngine)Preconditions.checkNotNull((Object)templateEngine);
    }

    public MailMock withTemplateEngine(MailTemplateEngine templateEngine) {
        this.setTemplateEngine(templateEngine);
        return this;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Encoding getBodyEncoding() {
        return this.bodyEncoding;
    }

    public void setBodyEncoding(Encoding bodyEncoding) {
        this.bodyEncoding = bodyEncoding;
    }

    public Encoding getAttachmentEncoding() {
        return this.attachmentEncoding;
    }

    public void setAttachmentEncoding(Encoding attachmentEncoding) {
        this.attachmentEncoding = attachmentEncoding;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Map<AddressType, List<Address>> getAddresses() {
        return this.addresses;
    }

    public Map<BodyType, String> getBodies() {
        return this.bodies;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<Inline> getInlines() {
        return this.inlines;
    }

    private List<Address> toAddressList(Iterable<String> addresses) {
        ArrayList<Address> r = new ArrayList<Address>();
        for (String a : addresses) {
            r.add(new EncodedAddress(a));
        }
        return r;
    }

    private static <T> Iterable<T> toIterable(final T[] array) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < array.length;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return array[this.i++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static boolean issEquals(InputStreamSupplier iss1, InputStreamSupplier iss2) {
        ByteArrayOutputStream a1 = new ByteArrayOutputStream();
        ByteArrayOutputStream a2 = new ByteArrayOutputStream();
        try {
            try (InputStream is = iss1.getInputStream();){
                ByteStreams.copy((InputStream)is, (OutputStream)a1);
            }
            is = iss2.getInputStream();
            var5_6 = null;
            try {
                ByteStreams.copy((InputStream)is, (OutputStream)a2);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var5_6 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return Arrays.equals(a1.toByteArray(), a2.toByteArray());
    }

    public class Inline {
        private final InputStreamSupplier content;
        private final String id;
        private final String type;

        public Inline(InputStreamSupplier content, @Nullable String id, String type) {
            this.content = (InputStreamSupplier)Preconditions.checkNotNull((Object)content);
            this.id = (String)Preconditions.checkNotNull((Object)id);
            this.type = type;
        }

        public InputStreamSupplier getContent() {
            return this.content;
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Inline)) {
                return false;
            }
            Inline inline = (Inline)o;
            return Objects.equals(this.id, inline.id) && Objects.equals(this.type, inline.type) && MailMock.issEquals(this.content, inline.content);
        }

        public int hashCode() {
            return Objects.hash(this.content, this.id, this.type);
        }

        public String toString() {
            return "Inline{content=" + this.content + ", id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    public class Attachment {
        private final InputStreamSupplier content;
        private final String name;
        private final String type;

        public Attachment(InputStreamSupplier content, @Nullable String name, String type) {
            this.content = (InputStreamSupplier)Preconditions.checkNotNull((Object)content);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.type = type;
        }

        public InputStreamSupplier getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Attachment)) {
                return false;
            }
            Attachment that = (Attachment)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && MailMock.issEquals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hash(this.content, this.name, this.type);
        }

        public String toString() {
            return "Attachment{content=" + this.content + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    public class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header header = (Header)o;
            return Objects.equals(this.name, header.name) && Objects.equals(this.value, header.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "Header{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public class EncodedAddress
    extends Address {
        private final String value;

        public EncodedAddress(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EncodedAddress)) {
                return false;
            }
            EncodedAddress that = (EncodedAddress)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "EncodedAddress{value='" + this.value + '\'' + '}';
        }
    }

    public class SplitAddress
    extends Address {
        private final String address;
        private final String personal;

        public SplitAddress(@Nullable String address, String personal) {
            this.address = (String)Preconditions.checkNotNull((Object)address);
            this.personal = personal;
        }

        public String getAddress() {
            return this.address;
        }

        public String getPersonal() {
            return this.personal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SplitAddress)) {
                return false;
            }
            SplitAddress that = (SplitAddress)o;
            return Objects.equals(this.address, that.address) && Objects.equals(this.personal, that.personal);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.personal);
        }

        public String toString() {
            return "SplitAddress{address='" + this.address + '\'' + ", personal='" + this.personal + '\'' + '}';
        }
    }

    public abstract class Address {
    }
}

