/*
 * Decompiled with CFR 0.152.
 */
package net.eudu.db.interceptlogic;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.eudu.db.NamedSqlUtils;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class MyCallback
implements MethodInterceptor {
    private NamedParameterJdbcTemplate jdbcTemplate;

    public MyCallback(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = namedParameterJdbcTemplate;
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        Object[] parameters = objects;
        Annotation[] annotations = method.getDeclaredAnnotations();
        boolean dynamicTable = false;
        int tableAmmocunt = 0;
        String opeType = null;
        String rawSql = null;
        for (Annotation annotation : annotations) {
            Class<?> annoClaz = annotation.getClass();
            Method valueM = annoClaz.getDeclaredMethod("value", new Class[0]);
            Method typeM = annoClaz.getDeclaredMethod("type", new Class[0]);
            String annType = (String)typeM.invoke((Object)annotation, new Object[0]);
            Object annV = valueM.invoke((Object)annotation, new Object[0]);
            if ("MyTable".equals(annType)) {
                dynamicTable = true;
                tableAmmocunt = (Integer)annV;
                continue;
            }
            opeType = annType;
            rawSql = (String)annV;
        }
        NamedSqlUtils namedSqlUtils = new NamedSqlUtils(rawSql, parameters, dynamicTable, tableAmmocunt);
        String handledSql = namedSqlUtils.getSql();
        HashMap<String, Object> args = namedSqlUtils.getArgs();
        switch (opeType) {
            case "MyBatchUpdate": {
                Map<String, ?>[] batchValues = null;
                if (parameters.length != 0) {
                    batchValues = this.convert2MapArray(parameters[parameters.length - 1]);
                }
                return this.batchUpdate(handledSql, batchValues);
            }
            case "MyCount": {
                return this.count(handledSql, args);
            }
            case "MyInsertWithKey": {
                return this.updateWithKey(handledSql, args);
            }
            case "MyQueryForMap": {
                Type clzz;
                Object res = (Map)this.queryForMap(handledSql, args);
                Type type = method.getReturnType();
                if (type instanceof Class && !((Class)(clzz = type)).getTypeName().startsWith("java.util")) {
                    Object userObject = ((Class)clzz).newInstance();
                    this.Map2Object(userObject, (Map<String, Object>)res);
                    return userObject;
                }
                return res;
            }
            case "MyQueryForList": {
                Class clzz;
                Type type1;
                ParameterizedType parameterizedType;
                Type[] typeArgs;
                Object res = (List)this.queryForList(handledSql, args);
                Type type = method.getGenericReturnType();
                if (type instanceof ParameterizedType && (typeArgs = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1 && (type1 = typeArgs[0]) instanceof Class && !(clzz = (Class)type1).getTypeName().startsWith("java.util")) {
                    ArrayList list = new ArrayList(res.size());
                    Iterator iterator = res.iterator();
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        Object userObject = clzz.newInstance();
                        this.Map2Object(userObject, map);
                        list.add(userObject);
                    }
                    return list;
                }
                return res;
            }
            case "MyUpdate": {
                return this.update(handledSql, args);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6ce8\u89e3");
    }

    public Object queryForList(String sql, Map<String, Object> map) {
        return this.jdbcTemplate.queryForList(sql, map);
    }

    public Object queryForMap(String sql, Map<String, Object> map) {
        return this.jdbcTemplate.queryForMap(sql, map);
    }

    public Object count(String sql, Map<String, Object> map) {
        Map resmap = (Map)this.queryForMap(sql, map);
        final Object[] objects = new Object[1];
        resmap.forEach(new BiConsumer(){

            public void accept(Object o, Object o2) {
                objects[0] = o2;
            }
        });
        return objects[0];
    }

    public int update(String sql, Map<String, Object> map) {
        return this.jdbcTemplate.update(sql, map);
    }

    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) {
        return this.jdbcTemplate.batchUpdate(sql, (Map[])batchValues);
    }

    public Object updateWithKey(String sql, Map<String, ?> paramMap) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource(paramMap);
        GeneratedKeyHolder generatedKeyHolde = new GeneratedKeyHolder();
        int res = this.jdbcTemplate.update(sql, (SqlParameterSource)sqlParameterSource, (KeyHolder)generatedKeyHolde);
        Number number = generatedKeyHolde.getKey();
        return number.longValue();
    }

    private static Map<String, Object> object2Map(Object o) {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method method : methods = o.getClass().getMethods()) {
            int paramCount = method.getParameterCount();
            String name = method.getName();
            if (paramCount != 0 || name.length() <= 3 || !name.startsWith("get")) continue;
            try {
                char[] namechars = name.substring(3).toCharArray();
                char c = namechars[0];
                if (c >= 'A' && c <= 'Z') {
                    namechars[0] = (char)(c + 32);
                }
                Object v = method.invoke(o, new Object[0]);
                map.put(new String(namechars), v);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public Map<String, ?>[] convert2MapArray(Object o) {
        Map[] res = null;
        Class<?> clzz = o.getClass();
        if (clzz.isArray()) {
            Object[] objects = (Object[])o;
            Object object = objects[0];
            if (object instanceof Map) {
                res = (Map[])o;
            } else {
                res = new Map[objects.length];
                for (int i = 0; i < objects.length; ++i) {
                    res[i] = MyCallback.object2Map(objects[i]);
                }
            }
        } else if (o instanceof List) {
            List objects = (List)o;
            Object object = objects.get(0);
            if (object instanceof Map) {
                res = objects.toArray(new HashMap[objects.size()]);
            } else {
                res = new Map[objects.size()];
                for (int i = 0; i < objects.size(); ++i) {
                    res[i] = MyCallback.object2Map(objects.get(i));
                }
            }
        } else {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u652f\u6301");
        }
        return res;
    }

    private <T> T Map2Object(T o, Map<String, Object> map) {
        Class<?> clazz = o.getClass();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            Object v = map.get(key);
            char[] chars = key.toCharArray();
            if (chars.length == 0) continue;
            char c = chars[0];
            if (c >= 'a' && c <= 'z') {
                chars[0] = c = (char)(c - 32);
            }
            String methodName = "set" + new String(chars);
            Class<?> paraType = v.getClass();
            try {
                Method method = clazz.getMethod(methodName, paraType);
                method.invoke(o, v);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return o;
    }
}

