/*
 * Decompiled with CFR 0.152.
 */
package net.eudu.db.interceptlogic;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.eudu.db.SqlUtils;
import net.eudu.db.annotation.MyBatchUpdate;
import net.eudu.db.annotation.MyCount;
import net.eudu.db.annotation.MyInsertWithKey;
import net.eudu.db.annotation.MyQueryForList;
import net.eudu.db.annotation.MyQueryForMap;
import net.eudu.db.annotation.MyUpdate;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.AfterAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class MyInterceptor
implements MethodInterceptor,
AfterAdvice,
Serializable {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] parameters = invocation.getArguments();
        int n = 0;
        Method method = invocation.getMethod();
        Annotation[] annotations = method.getDeclaredAnnotations();
        Annotation[] annotationArray = annotations;
        int n2 = annotationArray.length;
        if (n < n2) {
            Annotation annotation = annotationArray[n];
            if (annotation instanceof MyCount) {
                MyCount myCount = (MyCount)annotation;
                String value = myCount.value();
                SqlUtils sqlUtils = new SqlUtils(value, parameters);
                return this.count(sqlUtils.getSql(), sqlUtils.getArgs());
            }
            if (annotation instanceof MyBatchUpdate) {
                MyBatchUpdate myBatchUpdate = (MyBatchUpdate)annotation;
                String value = myBatchUpdate.value();
                List list = null;
                if (parameters.length != 0) {
                    list = (List)parameters[0];
                }
                return this.batchUpdate(value, list);
            }
            if (annotation instanceof MyInsertWithKey) {
                MyInsertWithKey myInsertWithKey = (MyInsertWithKey)annotation;
                String value = myInsertWithKey.value();
                SqlUtils sqlUtils = new SqlUtils(value, parameters);
                return this.updateWithKey(sqlUtils.getSql(), sqlUtils.getArgs());
            }
            if (annotation instanceof MyUpdate) {
                MyUpdate myUpdate = (MyUpdate)annotation;
                String value = myUpdate.value();
                SqlUtils sqlUtils = new SqlUtils(value, parameters);
                return this.update(sqlUtils.getSql(), sqlUtils.getArgs());
            }
            if (annotation instanceof MyQueryForList) {
                MyQueryForList myQueryForList = (MyQueryForList)annotation;
                String value = myQueryForList.value();
                SqlUtils sqlUtils = new SqlUtils(value, parameters);
                return this.queryForList(sqlUtils.getSql(), sqlUtils.getArgs());
            }
            if (annotation instanceof MyQueryForMap) {
                MyQueryForMap myQueryForMap = (MyQueryForMap)annotation;
                String value = myQueryForMap.value();
                SqlUtils sqlUtils = new SqlUtils(value, parameters);
                return this.queryForMap(sqlUtils.getSql(), sqlUtils.getArgs());
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6ce8\u89e3");
        }
        return "wp";
    }

    public Object queryForList(String sql, Object ... args) {
        if (this.isArrayNullOrEmpty(args)) {
            return this.jdbcTemplate.queryForList(sql);
        }
        System.out.println(Arrays.asList(args));
        return this.jdbcTemplate.queryForList(sql, args);
    }

    public Object queryForMap(String sql, Object ... args) {
        if (this.isArrayNullOrEmpty(args)) {
            return this.jdbcTemplate.queryForMap(sql);
        }
        return this.jdbcTemplate.queryForMap(sql, args);
    }

    public Object count(String sql, Object ... args) {
        Map map = (Map)this.queryForMap(sql, args);
        final Object[] objects = new Object[1];
        map.forEach(new BiConsumer(){

            public void accept(Object o, Object o2) {
                objects[0] = o2;
            }
        });
        return objects[0];
    }

    public int update(String sql, Object ... args) {
        if (this.isArrayNullOrEmpty(args)) {
            return this.jdbcTemplate.update(sql);
        }
        return this.jdbcTemplate.update(sql, args);
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.jdbcTemplate.batchUpdate(sql, batchArgs);
    }

    public Object updateWithKey(final String sql, final Object ... args) {
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement pst = con.prepareStatement(sql, 1);
                for (int i = 0; i < args.length; ++i) {
                    pst.setObject(i + 1, args[i]);
                }
                return pst;
            }
        };
        GeneratedKeyHolder generatedKeyHolde = new GeneratedKeyHolder();
        int res = this.jdbcTemplate.update(psc, (KeyHolder)generatedKeyHolde);
        Number number = generatedKeyHolde.getKey();
        return number.longValue();
    }

    private boolean isArrayNullOrEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static void main(String[] args) {
        SqlUtils sqlUtil = new SqlUtils("select * from users where ( id in ((?1) )?1 and ) ?1  (name = ?2)?2", new Object[]{null, 2});
    }
}

