/*
 * Decompiled with CFR 0.152.
 */
package net.eudu.db.interceptlogic;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.eudu.db.NamedSqlUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.AfterAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class NamedMyInterceptor
implements MethodInterceptor,
AfterAdvice,
Serializable {
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] parameters = invocation.getArguments();
        Method method = invocation.getMethod();
        Annotation[] annotations = method.getDeclaredAnnotations();
        boolean dynamicTable = false;
        int tableAmmocunt = 0;
        String opeType = null;
        String rawSql = null;
        for (Annotation annotation : annotations) {
            Class<?> annoClaz = annotation.getClass();
            Method valueM = annoClaz.getDeclaredMethod("value", new Class[0]);
            Method typeM = annoClaz.getDeclaredMethod("type", new Class[0]);
            String annType = (String)typeM.invoke((Object)annotation, new Object[0]);
            Object annV = valueM.invoke((Object)annotation, new Object[0]);
            if ("MyTable".equals(annType)) {
                dynamicTable = true;
                tableAmmocunt = (Integer)annV;
                continue;
            }
            opeType = annType;
            rawSql = (String)annV;
        }
        NamedSqlUtils namedSqlUtils = new NamedSqlUtils(rawSql, parameters, dynamicTable, tableAmmocunt);
        String handledSql = namedSqlUtils.getSql();
        HashMap<String, Object> args = namedSqlUtils.getArgs();
        switch (opeType) {
            case "MyBatchUpdate": {
                Map[] batchValues = null;
                if (parameters.length != 0) {
                    batchValues = (Map[])parameters[parameters.length - 1];
                }
                return this.batchUpdate(handledSql, batchValues);
            }
            case "MyCount": {
                return this.count(handledSql, args);
            }
            case "MyInsertWithKey": {
                return this.updateWithKey(handledSql, args);
            }
            case "MyQueryForMap": {
                return this.queryForMap(handledSql, args);
            }
            case "MyQueryForList": {
                return this.queryForList(handledSql, args);
            }
            case "MyUpdate": {
                return this.update(handledSql, args);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6ce8\u89e3");
    }

    public Object queryForList(String sql, Map<String, Object> map) {
        return this.jdbcTemplate.queryForList(sql, map);
    }

    public Object queryForMap(String sql, Map<String, Object> map) {
        return this.jdbcTemplate.queryForMap(sql, map);
    }

    public Object count(String sql, Map<String, Object> map) {
        Map resmap = (Map)this.queryForMap(sql, map);
        final Object[] objects = new Object[1];
        resmap.forEach(new BiConsumer(){

            public void accept(Object o, Object o2) {
                objects[0] = o2;
            }
        });
        return objects[0];
    }

    public int update(String sql, Map<String, Object> map) {
        return this.jdbcTemplate.update(sql, map);
    }

    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) {
        return this.jdbcTemplate.batchUpdate(sql, (Map[])batchValues);
    }

    public Object updateWithKey(String sql, Map<String, ?> paramMap) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource(paramMap);
        GeneratedKeyHolder generatedKeyHolde = new GeneratedKeyHolder();
        int res = this.jdbcTemplate.update(sql, (SqlParameterSource)sqlParameterSource, (KeyHolder)generatedKeyHolde);
        Number number = generatedKeyHolde.getKey();
        return number.longValue();
    }
}

