/*
 * Decompiled with CFR 0.152.
 */
package net.eudu.db.proxy;

import java.io.IOException;
import java.util.Map;
import net.eudu.db.annotation.EnableMyDb;
import net.eudu.db.annotation.MyDb;
import net.eudu.db.interceptlogic.MyCallback;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.ClassUtils;

public class MyImportBeanDefinitionRegister
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.myRegisterBeanDefinitions(importingClassMetadata, registry);
    }

    public void myRegisterBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnableMyDb.class.getName());
        String[] basePackages = (String[])annotationAttributes.get("basePackages");
        try {
            for (String basePackage : basePackages) {
                Resource[] resources;
                String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + '/' + "**/*.class";
                for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources(packageSearchPath)) {
                    if (!resource.isReadable()) continue;
                    try {
                        MetadataReader metadataReader = new CachingMetadataReaderFactory().getMetadataReader(resource);
                        if (!new AnnotationTypeFilter(MyDb.class).match(metadataReader, (MetadataReaderFactory)new CachingMetadataReaderFactory())) continue;
                        ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                        sbd.setSource((Object)resource);
                        String className = sbd.getBeanClassName();
                        Class<?> clazz = Class.forName(className);
                        sbd.setInstanceSupplier(() -> {
                            NamedParameterJdbcTemplate namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)this.beanFactory.getBean(NamedParameterJdbcTemplate.class);
                            if (namedParameterJdbcTemplate == null) {
                                throw new RuntimeException("\u9700\u8981jdbctemolate\u652f\u6301");
                            }
                            Enhancer enhancer = new Enhancer();
                            enhancer.setSuperclass(clazz);
                            enhancer.setCallback((Callback)new MyCallback(namedParameterJdbcTemplate));
                            Object c = enhancer.create();
                            return c;
                        });
                        sbd.setLazyInit(true);
                        registry.registerBeanDefinition(clazz.getSimpleName(), (BeanDefinition)sbd);
                    }
                    catch (Throwable ex) {
                        throw new BeanDefinitionStoreException("Failed to read candidate component class: " + resource, ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    public final Environment getEnvironment() {
        return new StandardEnvironment();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

