/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableFunction2D;
import net.finmath.plots.PlotableWithConfidenceInterval2D;
import net.finmath.plots.Point2D;
import net.finmath.plots.axis.NumberAxis;
import net.finmath.plots.jfreechart.JFreeChartUtilities;
import net.finmath.plots.jfreechart.StyleGuide;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;

public class Plot2D
implements Plot {
    private static Logger logger = Logger.getLogger("net.finmath.plots");
    private List<Plotable2D> plotables;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private NumberFormat xAxisNumberFormat;
    private NumberFormat yAxisNumberFormat;
    private Boolean isLegendVisible = false;
    private transient JFrame frame;
    private transient JFreeChart chart;
    private final Object updateLock = new Object();
    private Double xmin;
    private Double xmax;
    private Double ymin;
    private Double ymax;

    public Plot2D(List<Plotable2D> plotables) {
        this.plotables = plotables;
    }

    public Plot2D(double xmin, double xmax, int numberOfPointsX, List<Named<DoubleUnaryOperator>> doubleUnaryOperators) {
        this(doubleUnaryOperators.stream().map(namedFunction -> new PlotableFunction2D(xmin, xmax, numberOfPointsX, (Named<DoubleUnaryOperator>)namedFunction, null)).collect(Collectors.toList()));
    }

    public Plot2D(double xmin, double xmax, int numberOfPointsX, DoubleUnaryOperator[] doubleUnaryOperators) {
        this(xmin, xmax, numberOfPointsX, Arrays.stream(doubleUnaryOperators).map(operator -> new Named<DoubleUnaryOperator>("", (DoubleUnaryOperator)operator)).collect(Collectors.toList()));
    }

    public Plot2D(double xmin, double xmax, int numberOfPointsX, DoubleUnaryOperator function) {
        this(xmin, xmax, numberOfPointsX, Collections.singletonList(new Named<DoubleUnaryOperator>("", function)));
    }

    public Plot2D(double xmin, double xmax, DoubleUnaryOperator function) {
        this(xmin, xmax, 300, Collections.singletonList(new Named<DoubleUnaryOperator>("", function)));
    }

    public Plot2D(double xmin, double xmax, int numberOfPointsX, final Function<Double, Double> function) {
        this(xmin, xmax, numberOfPointsX, Collections.singletonList(new Named<1>("", new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double operand) {
                return (Double)function.apply(operand);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                return;
            }
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            XYSeriesCollection data = new XYSeriesCollection();
            this.chart = JFreeChartUtilities.getXYPlotChart(this.title, this.xAxisLabel, "#.##", this.yAxisLabel, "#.##", data, (AbstractXYItemRenderer)renderer, this.isLegendVisible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object object = this.updateLock;
        synchronized (object) {
            HashMap<NumberAxis, Integer> rangeAxisMap = new HashMap<NumberAxis, Integer>();
            int intervalCount = 0;
            for (int functionIndex = 0; functionIndex < this.plotables.size(); ++functionIndex) {
                XYLineAndShapeRenderer renderer;
                Color color;
                DeviationRenderer intervalRenderer;
                YIntervalSeriesCollection intervalData;
                XYSeriesCollection data = new XYSeriesCollection();
                Plotable2D plotable = this.plotables.get(functionIndex);
                List<Point2D> plotableSeries = plotable.getSeries();
                XYSeries series = new XYSeries((Comparable)((Object)plotable.getName()));
                for (int i = 0; i < plotableSeries.size(); ++i) {
                    series.add(plotableSeries.get(i).getX(), plotableSeries.get(i).getY());
                }
                data.addSeries(series);
                if (plotable instanceof PlotableWithConfidenceInterval2D) {
                    Color color2;
                    intervalData = new YIntervalSeriesCollection();
                    intervalRenderer = new DeviationRenderer();
                    YIntervalSeries intervalSeries = new YIntervalSeries((Comparable)((Object)plotable.getName()));
                    List<Pair<Double, Double>> plotableIntervalSeries = ((PlotableWithConfidenceInterval2D)plotable).getConfidenceIntervall();
                    for (int i = 0; i < plotableIntervalSeries.size(); ++i) {
                        intervalSeries.add(plotableSeries.get(i).getX(), plotableSeries.get(i).getY(), ((Double)plotableIntervalSeries.get(i).getLeft()).doubleValue(), ((Double)plotableIntervalSeries.get(i).getRight()).doubleValue());
                    }
                    intervalData.addSeries(intervalSeries);
                    intervalRenderer.setSeriesShapesVisible(intervalCount, false);
                    GraphStyle style = plotable.getStyle();
                    Color color3 = color2 = style != null ? plotable.getStyle().getColor() : null;
                    if (color2 == null) {
                        color2 = this.getDefaultColor(functionIndex);
                    }
                    intervalRenderer.setSeriesPaint(0, (Paint)color2);
                    if (style != null) {
                        intervalRenderer.setSeriesShapesVisible(0, style.getShape() != null);
                        intervalRenderer.setSeriesLinesVisible(0, style.getStroke() != null);
                        if (style.getFillColor() != null) {
                            intervalRenderer.setSeriesFillPaint(0, (Paint)style.getFillColor());
                        }
                        if (style.getShape() != null) {
                            intervalRenderer.setSeriesShape(0, style.getShape());
                        }
                        if (style.getStroke() != null) {
                            intervalRenderer.setSeriesStroke(0, style.getStroke());
                        }
                    }
                    ++intervalCount;
                } else {
                    intervalData = null;
                    intervalRenderer = null;
                }
                GraphStyle style = plotable.getStyle();
                Color color4 = color = style != null ? plotable.getStyle().getColor() : null;
                if (color == null) {
                    color = this.getDefaultColor(functionIndex);
                }
                if (style != null) {
                    if (style.getFillColor() != null) {
                        renderer = new XYAreaRenderer();
                        renderer.setSeriesPaint(0, (Paint)style.getFillColor());
                        if (style.getClass() != null) {
                            ((XYAreaRenderer)renderer).setSeriesOutlinePaint(0, (Paint)style.getColor());
                            ((XYAreaRenderer)renderer).setOutline(true);
                        }
                    } else {
                        renderer = new XYLineAndShapeRenderer();
                        renderer.setSeriesShapesVisible(0, style.getShape() != null);
                        renderer.setSeriesLinesVisible(0, style.getStroke() != null);
                        renderer.setDrawSeriesLineAsPath(true);
                        renderer.setSeriesPaint(0, (Paint)color);
                    }
                    if (style.getShape() != null) {
                        renderer.setSeriesShape(0, style.getShape());
                    }
                    if (style.getStroke() != null) {
                        renderer.setSeriesStroke(0, style.getStroke());
                    }
                } else {
                    renderer = new XYLineAndShapeRenderer();
                    renderer.setSeriesPaint(0, (Paint)color);
                }
                if (this.chart != null) {
                    if (intervalData != null) {
                        this.chart.getXYPlot().setDataset(functionIndex, (XYDataset)intervalData);
                        this.chart.getXYPlot().setRenderer(functionIndex, (XYItemRenderer)intervalRenderer);
                    } else {
                        this.chart.getXYPlot().setDataset(functionIndex, (XYDataset)data);
                        this.chart.getXYPlot().setRenderer(functionIndex, (XYItemRenderer)renderer);
                    }
                    org.jfree.chart.axis.NumberAxis domain = (org.jfree.chart.axis.NumberAxis)this.chart.getXYPlot().getDomainAxis();
                    if (plotable.getDomainAxis() != null) {
                        domain = plotable.getDomainAxis().getImplementationJFree();
                    }
                    if (this.xAxisNumberFormat != null) {
                        domain.setNumberFormatOverride(this.xAxisNumberFormat);
                    }
                    if (!domain.equals((Object)this.chart.getXYPlot().getDomainAxis())) {
                        this.chart.getXYPlot().setDomainAxis(functionIndex, (ValueAxis)domain);
                    }
                    if (this.xmin != null && this.xmax != null) {
                        domain.setAutoRange(false);
                        domain.setRange(new Range(this.xmin.doubleValue(), this.xmax.doubleValue()));
                    } else {
                        domain.setAutoRange(true);
                    }
                    org.jfree.chart.axis.NumberAxis range = (org.jfree.chart.axis.NumberAxis)this.chart.getXYPlot().getRangeAxis();
                    if (plotable.getRangeAxis() != null) {
                        range = plotable.getRangeAxis().getImplementationJFree();
                    }
                    if (this.yAxisNumberFormat != null) {
                        range.setNumberFormatOverride(this.yAxisNumberFormat);
                    }
                    rangeAxisMap.putIfAbsent(plotable.getRangeAxis(), functionIndex);
                    this.chart.getXYPlot().mapDatasetToRangeAxis(functionIndex, ((Integer)rangeAxisMap.get(plotable.getRangeAxis())).intValue());
                    this.chart.getXYPlot().setRangeAxis(((Integer)rangeAxisMap.get(plotable.getRangeAxis())).intValue(), (ValueAxis)range);
                    new StyleGuide(2.0).applyStyleToChart2(this.chart);
                    if (this.ymin != null && this.ymax != null) {
                        range.setAutoRange(false);
                        range.setRange(new Range(this.ymin.doubleValue(), this.ymax.doubleValue()));
                    } else {
                        range.setAutoRange(true);
                    }
                    if (this.title != null) {
                        this.chart.setTitle(this.title);
                    }
                }
                if (this.frame == null || this.frame.isVisible()) continue;
                this.frame.setVisible(true);
            }
        }
    }

    private Color getDefaultColor(int functionIndex) {
        switch (functionIndex) {
            case 0: {
                return new Color(255, 0, 0);
            }
            case 1: {
                return new Color(0, 255, 0);
            }
            case 2: {
                return new Color(0, 0, 255);
            }
        }
        return new Color(0, 0, 0);
    }

    @Override
    public void show() {
        this.init();
        this.update(this.plotables);
        ChartPanel chartPanel = new ChartPanel(this.chart, 800, 400, 128, 128, 2024, 2024, false, true, true, false, true, false);
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ JPanel val$chartPanel;
            {
                this.val$chartPanel = jPanel;
            }

            @Override
            public void run() {
                if (Plot2D.this.frame != null) {
                    Plot2D.this.frame.dispose();
                }
                try {
                    Plot2D.this.frame = new JFrame();
                    Plot2D.this.frame.add(this.val$chartPanel);
                    Plot2D.this.frame.setVisible(true);
                    Plot2D.this.frame.pack();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Cannot show plot, possible missing Window system. Reason: " + e.getMessage().replace('\n', ' '));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D saveAsJPG(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsJPG(file, this.chart, width, height);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot2D saveAsPNG(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsPNG(file, this.chart, width, height);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D saveAsPDF(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsPDF(file, this.chart, width, height);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D saveAsSVG(File file, int width, int height) throws IOException {
        this.init();
        this.update(this.plotables);
        Object object = this.updateLock;
        synchronized (object) {
            JFreeChartUtilities.saveChartAsSVG(file, this.chart, width, height);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot2D update(List<Plotable2D> plotables) {
        this.plotables = plotables;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public Plot2D setTitle(String title) {
        this.title = title;
        this.update();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.chart.getXYPlot().getDomainAxis().setLabel(xAxisLabel);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plot2D setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.chart.getXYPlot().getRangeAxis().setLabel(yAxisLabel);
            }
        }
        return this;
    }

    @Override
    public Plot2D setZAxisLabel(String zAxisLabel) {
        throw new UnsupportedOperationException("The 2D plot does not suport a z-axis. Try 3D plot instead.");
    }

    public Plot2D setXAxisNumberFormat(NumberFormat xAxisNumberFormat) {
        this.xAxisNumberFormat = xAxisNumberFormat;
        return this;
    }

    public Plot2D setYAxisNumberFormat(NumberFormat yAxisNumberFormat) {
        this.yAxisNumberFormat = yAxisNumberFormat;
        return this;
    }

    public Plot2D setXRange(double xmin, double xmax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.update();
        return this;
    }

    public Plot2D setYRange(double ymin, double ymax) {
        this.ymin = ymin;
        this.ymax = ymax;
        this.update();
        return this;
    }

    @Override
    public Plot2D setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        this.update();
        return this;
    }

    public String toString() {
        return "Plot2D [plotables=" + this.plotables + ", title=" + this.title + ", xAxisLabel=" + this.xAxisLabel + ", yAxisLabel=" + this.yAxisLabel + ", xAxisNumberFormat=" + this.xAxisNumberFormat + ", yAxisNumberFormat=" + this.yAxisNumberFormat + ", isLegendVisible=" + this.isLegendVisible + ", ymin=" + this.ymin + ", ymax=" + this.ymax + "]";
    }
}

