/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.PlotableWithConfidenceInterval2D;
import net.finmath.plots.Point2D;
import net.finmath.plots.axis.NumberAxis;
import org.apache.commons.lang3.tuple.Pair;

public class PlotableFunctionWithConfidenceInterval2D
implements PlotableWithConfidenceInterval2D {
    private final double xmin;
    private final double xmax;
    private final int numberOfPointsX;
    private final Named<DoubleUnaryOperator> namedFunction;
    private final Named<DoubleUnaryOperator> namedFunctionLowerBound;
    private final Named<DoubleUnaryOperator> namedFunctionUpperBound;
    private final GraphStyle style;
    private final NumberAxis domainAxis;
    private final NumberAxis rangeAxis;

    public PlotableFunctionWithConfidenceInterval2D(double xmin, double xmax, int numberOfPointsX, Named<DoubleUnaryOperator> namedFunction, Named<DoubleUnaryOperator> namedFunctionLowerBound, Named<DoubleUnaryOperator> namedFunctionUpperBound, NumberAxis domainAxis, NumberAxis rangeAxis, GraphStyle style) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.numberOfPointsX = numberOfPointsX;
        this.namedFunction = namedFunction;
        this.namedFunctionLowerBound = namedFunctionLowerBound;
        this.namedFunctionUpperBound = namedFunctionUpperBound;
        this.domainAxis = domainAxis;
        this.rangeAxis = rangeAxis;
        this.style = style;
        if (numberOfPointsX < 2) {
            throw new IllegalArgumentException("Number of points needs to be larger than 1.");
        }
    }

    public PlotableFunctionWithConfidenceInterval2D(double xmin, double xmax, int numberOfPointsX, Named<DoubleUnaryOperator> namedFunction, Named<DoubleUnaryOperator> namedFunctionLowerBound, Named<DoubleUnaryOperator> namedFunctionUpperBound, GraphStyle style) {
        this(xmin, xmax, numberOfPointsX, namedFunction, namedFunctionLowerBound, namedFunctionUpperBound, null, null, style);
    }

    public PlotableFunctionWithConfidenceInterval2D(double xmin, double xmax, int numberOfPointsX, Named<DoubleUnaryOperator> namedFunction, Named<DoubleUnaryOperator> namedFunctionLowerBound, Named<DoubleUnaryOperator> namedFunctionUpperBound) {
        this(xmin, xmax, numberOfPointsX, namedFunction, namedFunctionLowerBound, namedFunctionUpperBound, new GraphStyle(new Rectangle(-2, -3, 5, 5), new BasicStroke(3.0f), null));
    }

    public PlotableFunctionWithConfidenceInterval2D(double xmin, double xmax, int numberOfPointsX, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperatorLowerBound, DoubleUnaryOperator doubleUnaryOperatorUpperBound) {
        this(xmin, xmax, numberOfPointsX, new Named<DoubleUnaryOperator>("", doubleUnaryOperator), new Named<DoubleUnaryOperator>("", doubleUnaryOperatorLowerBound), new Named<DoubleUnaryOperator>("", doubleUnaryOperatorUpperBound));
    }

    @Override
    public String getName() {
        return this.namedFunction.getName();
    }

    @Override
    public List<Point2D> getSeries() {
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        DoubleUnaryOperator function = this.namedFunction.get();
        for (int i = 0; i < this.numberOfPointsX; ++i) {
            double x = this.xmin + (double)i * ((this.xmax - this.xmin) / (double)(this.numberOfPointsX - 1));
            double y = function.applyAsDouble(x);
            if (!Double.isFinite(y)) continue;
            series.add(new Point2D(x, y));
        }
        return series;
    }

    @Override
    public List<Pair<Double, Double>> getConfidenceIntervall() {
        ArrayList<Pair<Double, Double>> series = new ArrayList<Pair<Double, Double>>();
        DoubleUnaryOperator lowerBound = this.namedFunctionLowerBound.get();
        DoubleUnaryOperator upperBound = this.namedFunctionUpperBound.get();
        for (int i = 0; i < this.numberOfPointsX; ++i) {
            double x = this.xmin + (double)i * ((this.xmax - this.xmin) / (double)(this.numberOfPointsX - 1));
            double l = lowerBound.applyAsDouble(x);
            double u = upperBound.applyAsDouble(x);
            if (!Double.isFinite(l) || !Double.isFinite(u)) continue;
            series.add((Pair<Double, Double>)Pair.of((Object)l, (Object)u));
        }
        return series;
    }

    @Override
    public GraphStyle getStyle() {
        return this.style;
    }

    @Override
    public NumberAxis getDomainAxis() {
        return this.domainAxis;
    }

    @Override
    public NumberAxis getRangeAxis() {
        return this.rangeAxis;
    }
}

