/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;

public interface Collector<T> {
    public List<T> collect();

    default public <P extends T> void assertSingle(Class<P> type, Consumer<P> consumer) {
        List<T> elements = this.collect();
        Assertions.assertEquals((int)1, (int)elements.size(), (String)("Expected 1 element, got " + String.valueOf(elements)));
        T element = elements.getFirst();
        Assertions.assertInstanceOf(type, element, (String)("Expected type " + type.getSimpleName() + ", got " + element.getClass().getSimpleName()));
        consumer.accept(element);
    }

    default public void assertSingle(Consumer<T> consumer) {
        List<T> elements = this.collect();
        Assertions.assertEquals((int)1, (int)elements.size(), (String)("Expected 1 element, got " + String.valueOf(elements)));
        consumer.accept(elements.getFirst());
    }

    default public void assertCount(int count) {
        List<T> elements = this.collect();
        Assertions.assertEquals((int)count, (int)elements.size(), (String)("Expected " + count + " element(s), got " + elements.size() + ": " + String.valueOf(elements)));
    }

    default public void assertSingle() {
        this.assertCount(1);
    }

    default public void assertEmpty() {
        this.assertCount(0);
    }

    default public void assertAnyMatch(Predicate<T> predicate) {
        List<T> elements = this.collect();
        Assertions.assertTrue((boolean)elements.stream().anyMatch(predicate), (String)("No elements matched the predicate. Elements: " + String.valueOf(elements)));
    }

    default public void assertNoneMatch(Predicate<T> predicate) {
        List<T> elements = this.collect();
        Assertions.assertFalse((boolean)elements.stream().anyMatch(predicate), (String)("Found elements that matched the predicate: " + String.valueOf(elements.stream().filter(predicate).toList())));
    }

    default public void assertAllMatch(Predicate<T> predicate) {
        List<T> elements = this.collect();
        Assertions.assertTrue((boolean)elements.stream().allMatch(predicate), (String)("Not all elements matched the predicate. Elements: " + String.valueOf(elements)));
    }
}

