/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.time.Duration;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minestom.server.ServerProcess;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Player;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventFilter;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.player.GameProfile;
import net.minestom.testing.Collector;
import net.minestom.testing.FlexibleListener;
import net.minestom.testing.TestConnection;
import org.jetbrains.annotations.Nullable;

public interface Env {
    public ServerProcess process();

    public TestConnection createConnection(GameProfile var1);

    default public TestConnection createConnection() {
        return this.createConnection(new GameProfile(UUID.randomUUID(), "RandName"));
    }

    public <E extends Event, H> Collector<E> trackEvent(Class<E> var1, EventFilter<? super E, H> var2, H var3);

    public <E extends Event> FlexibleListener<E> listen(Class<E> var1);

    default public void tick() {
        this.process().ticker().tick(System.nanoTime());
    }

    default public boolean tickWhile(BooleanSupplier condition, @Nullable Duration timeout) {
        ServerProcess.Ticker ticker = this.process().ticker();
        long start = System.nanoTime();
        while (condition.getAsBoolean()) {
            long tick = System.nanoTime();
            ticker.tick(tick);
            if (timeout == null || System.nanoTime() - start <= timeout.toNanos()) continue;
            return false;
        }
        return true;
    }

    default public Player createPlayer(Instance instance, Pos pos) {
        return this.createConnection().connect(instance, pos);
    }

    default public Instance createFlatInstance() {
        return this.createFlatInstance(null);
    }

    default public Instance createFlatInstance(@Nullable IChunkLoader chunkLoader) {
        InstanceContainer instance = this.process().instance().createInstanceContainer(chunkLoader);
        instance.setGenerator(unit -> unit.modifier().fillHeight(0, 40, Block.STONE));
        return instance;
    }

    default public Instance createEmptyInstance() {
        return this.process().instance().createInstanceContainer();
    }

    default public Instance createEmptyInstance(IChunkLoader chunkLoader) {
        return this.process().instance().createInstanceContainer(chunkLoader);
    }

    default public void destroyInstance(Instance instance) {
        this.process().instance().unregisterInstance(instance);
    }
}

