/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minestom.server.ServerProcess;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventListener;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.network.player.GameProfile;
import net.minestom.testing.Collector;
import net.minestom.testing.Env;
import net.minestom.testing.FlexibleListener;
import net.minestom.testing.TestConnection;
import net.minestom.testing.TestConnectionImpl;
import org.junit.jupiter.api.Assertions;

final class EnvImpl
implements Env {
    private final ServerProcess process;
    private final List<FlexibleListenerImpl<?>> listeners = new CopyOnWriteArrayList();

    public EnvImpl(ServerProcess process) {
        this.process = process;
        this.process().dispatcher().start();
        process.connection().setPlayerProvider(TestConnectionImpl.TestPlayerImpl::new);
    }

    @Override
    public ServerProcess process() {
        return this.process;
    }

    @Override
    public TestConnection createConnection(GameProfile gameProfile) {
        return new TestConnectionImpl(this, gameProfile);
    }

    @Override
    public <E extends Event, H> Collector<E> trackEvent(Class<E> eventType, EventFilter<? super E, H> filter, H actor) {
        EventCollector tracker = new EventCollector(actor);
        this.process.eventHandler().map(actor, filter).addListener(eventType, tracker.events::add);
        return tracker;
    }

    @Override
    public <E extends Event> FlexibleListener<E> listen(Class<E> eventType) {
        GlobalEventHandler handler = this.process.eventHandler();
        FlexibleListenerImpl<E> flexible = new FlexibleListenerImpl<E>(eventType);
        EventListener listener = EventListener.of(eventType, e -> flexible.handler.accept(e));
        handler.addListener(listener);
        this.listeners.add(flexible);
        return flexible;
    }

    void cleanup() {
        this.listeners.forEach(FlexibleListenerImpl::check);
        this.process.stop();
    }

    final class EventCollector<E extends Event>
    implements Collector<E> {
        private final Object handler;
        private final List<E> events = new CopyOnWriteArrayList();

        public EventCollector(Object handler) {
            this.handler = handler;
        }

        @Override
        public List<E> collect() {
            EnvImpl.this.process.eventHandler().unmap(this.handler);
            return List.copyOf(this.events);
        }
    }

    static final class FlexibleListenerImpl<E extends Event>
    implements FlexibleListener<E> {
        private final Class<E> eventType;
        private Consumer<E> handler = e -> {};
        private boolean initialized;
        private boolean called;

        FlexibleListenerImpl(Class<E> eventType) {
            this.eventType = eventType;
        }

        @Override
        public void followup(Consumer<E> handler) {
            this.updateHandler(handler);
        }

        @Override
        public void failFollowup() {
            this.updateHandler(e -> Assertions.fail((String)("Event " + e.getClass().getSimpleName() + " was not expected")));
        }

        void updateHandler(Consumer<E> handler) {
            this.check();
            this.initialized = true;
            this.called = false;
            this.handler = e -> {
                handler.accept(e);
                this.called = true;
            };
        }

        void check() {
            Assertions.assertTrue((!this.initialized || this.called ? 1 : 0) != 0, (String)("Last listener has not been called: " + this.eventType.getSimpleName()));
        }
    }
}

