/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.coordinate.Point;
import org.junit.jupiter.api.Assertions;

public final class TestUtils {
    public static void waitUntilCleared(WeakReference<?> ref) {
        int maxTries = 100;
        for (int i = 0; i < 100; ++i) {
            System.gc();
            if (ref.get() == null) {
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Assertions.fail((String)"Reference was not cleared");
    }

    public static <T> void assertEqualsIgnoreOrder(Collection<T> expected, Collection<? extends T> actual) {
        Assertions.assertEquals(Set.copyOf(expected), Set.copyOf(actual));
    }

    public static void assertEqualsSNBT(String snbt, BinaryTag compound) {
        try {
            BinaryTag converted = MinestomAdventure.tagStringIO().asTag(snbt);
            Assertions.assertEquals((Object)converted, (Object)compound);
        }
        catch (IOException e) {
            Assertions.fail((Throwable)e);
        }
    }

    public static void assertEqualsIgnoreSpace(String s1, String s2, boolean matchCase) {
        String val1 = TestUtils.stripExtraSpaces(s1);
        String val2 = TestUtils.stripExtraSpaces(s2);
        if (matchCase) {
            Assertions.assertEquals((Object)val1, (Object)val2);
        } else {
            Assertions.assertTrue((boolean)val1.equalsIgnoreCase(val2));
        }
    }

    public static void assertEqualsIgnoreSpace(String s1, String s2) {
        TestUtils.assertEqualsIgnoreSpace(s1, s2, true);
    }

    public static void assertPoint(Point p1, Point p2) {
        Assertions.assertTrue((boolean)p1.samePoint(p2), (String)String.format("Points don't match! Expected: %s, but got: %s", p1, p2));
    }

    private static String stripExtraSpaces(String s) {
        StringBuilder formattedString = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            formattedString.append(st.nextToken());
        }
        return formattedString.toString().trim();
    }
}

