/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.activate.entity;

import net.fwbrasil.activate.entity.Alias;
import net.fwbrasil.activate.entity.Entity;
import net.fwbrasil.activate.entity.EntityEnhancer$;
import net.fwbrasil.activate.entity.EntityHelper$;
import net.fwbrasil.activate.entity.EntityMetadata;
import net.fwbrasil.activate.util.Reflection$;
import net.fwbrasil.activate.util.uuid.UUIDUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedMap;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class EntityHelper$ {
    public static final EntityHelper$ MODULE$;
    public final Map<String, EntityMetadata> net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas;
    private final Map<Class<? extends Entity>, List<Class<Entity>>> concreteEntityClasses;
    private final Regex entityIdClassHashPattern;

    static {
        new EntityHelper$();
    }

    public void clearMetadatas() {
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.clear();
        this.concreteEntityClasses.clear();
    }

    public List<EntityMetadata> metadatas() {
        return (List)this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.values().toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EntityMetadata x$1) {
                return x$1.name();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public scala.collection.immutable.Set<Class<Entity>> allConcreteEntityClasses() {
        return ((TraversableOnce)this.concreteEntityClasses.values().flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    public <E extends Entity> List<Class<Entity>> concreteClasses(Class<E> clazz) {
        return (List)this.concreteEntityClasses.getOrElseUpdate(clazz, (Function0)new Serializable(clazz){
            public static final long serialVersionUID = 0L;
            public final Class clazz$1;

            public final List<Class<Entity>> apply() {
                return ((TraversableOnce)EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, EntityMetadata> check$ifrefutable$1) {
                        Tuple2<String, EntityMetadata> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.concreteClasses.1 $outer;

                    public final boolean apply(Tuple2<String, EntityMetadata> x$2) {
                        Tuple2<String, EntityMetadata> tuple2 = x$2;
                        if (tuple2 != null) {
                            EntityMetadata metadata = (EntityMetadata)tuple2._2();
                            Class clazz = this.$outer.clazz$1;
                            Class<Entity> clazz2 = metadata.entityClass();
                            boolean bl = !((clazz == null ? clazz2 != null : !clazz.equals(clazz2)) && !this.$outer.clazz$1.isAssignableFrom(metadata.entityClass()) || !Reflection$.MODULE$.toRichClass(metadata.entityClass()).isConcreteClass());
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Class<Entity> apply(Tuple2<String, EntityMetadata> x$3) {
                        Tuple2<String, EntityMetadata> tuple2 = x$3;
                        if (tuple2 != null) {
                            EntityMetadata metadata = (EntityMetadata)tuple2._2();
                            Class<Entity> clazz = metadata.entityClass();
                            return clazz;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList();
            }
            {
                this.clazz$1 = clazz$1;
            }
        });
    }

    public synchronized void initialize(Class<?> referenceClass) {
        UUIDUtil$.MODULE$.generateUUID();
        EntityEnhancer$.MODULE$.enhancedEntityClasses(referenceClass).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Class<Entity> entityClass) {
                BoxedUnit boxedUnit;
                if (entityClass.isInterface()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String entityClassHashId = EntityHelper$.MODULE$.getEntityClassHashId(entityClass);
                    String entityName = EntityHelper$.MODULE$.getEntityName(entityClass);
                    boxedUnit = EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)entityClassHashId), (Object)new EntityMetadata(entityName, entityClass)));
                }
                return boxedUnit;
            }
        });
    }

    private Option<EntityMetadata> getEntityMetadataOption(Class<?> clazz) {
        return this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.get((Object)this.getEntityClassHashId(clazz));
    }

    public EntityMetadata getEntityMetadata(Class<?> clazz) {
        return (EntityMetadata)this.getEntityMetadataOption(clazz).get();
    }

    private Regex entityIdClassHashPattern() {
        return this.entityIdClassHashPattern;
    }

    private HashMap<Class<?>, String> classHashIdsCache() {
        return new SynchronizedMap<Class<?>, String>(){

            public Option scala$collection$mutable$SynchronizedMap$$super$get(Object key) {
                return super.get(key);
            }

            public Iterator scala$collection$mutable$SynchronizedMap$$super$iterator() {
                return super.iterator();
            }

            public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$$plus$eq(Tuple2 kv) {
                return (SynchronizedMap)super.$plus$eq(kv);
            }

            public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$$minus$eq(Object key) {
                return (SynchronizedMap)super.$minus$eq(key);
            }

            public int scala$collection$mutable$SynchronizedMap$$super$size() {
                return super.size();
            }

            public Option scala$collection$mutable$SynchronizedMap$$super$put(Object key, Object value) {
                return super.put(key, value);
            }

            public void scala$collection$mutable$SynchronizedMap$$super$update(Object key, Object value) {
                super.update(key, value);
            }

            public Option scala$collection$mutable$SynchronizedMap$$super$remove(Object key) {
                return super.remove(key);
            }

            public void scala$collection$mutable$SynchronizedMap$$super$clear() {
                super.clear();
            }

            public Object scala$collection$mutable$SynchronizedMap$$super$getOrElseUpdate(Object key, Function0 op) {
                return MapLike.class.getOrElseUpdate((scala.collection.mutable.MapLike)this, (Object)key, (Function0)op);
            }

            public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$transform(Function2 f) {
                return (SynchronizedMap)MapLike.class.transform((scala.collection.mutable.MapLike)this, (Function2)f);
            }

            public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$retain(Function2 p) {
                return (SynchronizedMap)MapLike.class.retain((scala.collection.mutable.MapLike)this, (Function2)p);
            }

            public Iterable scala$collection$mutable$SynchronizedMap$$super$values() {
                return super.values();
            }

            public Iterator scala$collection$mutable$SynchronizedMap$$super$valuesIterator() {
                return super.valuesIterator();
            }

            public Map scala$collection$mutable$SynchronizedMap$$super$clone() {
                return MapLike.class.clone((scala.collection.mutable.MapLike)this);
            }

            public void scala$collection$mutable$SynchronizedMap$$super$foreach(Function1 f) {
                super.foreach(f);
            }

            public Object scala$collection$mutable$SynchronizedMap$$super$apply(Object key) {
                return super.apply(key);
            }

            public Set scala$collection$mutable$SynchronizedMap$$super$keySet() {
                return super.keySet();
            }

            public Iterable scala$collection$mutable$SynchronizedMap$$super$keys() {
                return MapLike.class.keys((MapLike)this);
            }

            public Iterator scala$collection$mutable$SynchronizedMap$$super$keysIterator() {
                return super.keysIterator();
            }

            public boolean scala$collection$mutable$SynchronizedMap$$super$isEmpty() {
                return MapLike.class.isEmpty((MapLike)this);
            }

            public boolean scala$collection$mutable$SynchronizedMap$$super$contains(Object key) {
                return super.contains(key);
            }

            public boolean scala$collection$mutable$SynchronizedMap$$super$isDefinedAt(Object key) {
                return MapLike.class.isDefinedAt((MapLike)this, (Object)key);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Option get(Object key) {
                return SynchronizedMap.class.get((SynchronizedMap)this, (Object)key);
            }

            public Iterator<Tuple2<Class<?>, String>> iterator() {
                return SynchronizedMap.class.iterator((SynchronizedMap)this);
            }

            public SynchronizedMap<Class<?>, String> $plus$eq(Tuple2<Class<?>, String> kv) {
                return SynchronizedMap.class.$plus$eq((SynchronizedMap)this, kv);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public SynchronizedMap $minus$eq(Object key) {
                return SynchronizedMap.class.$minus$eq((SynchronizedMap)this, (Object)key);
            }

            public int size() {
                return SynchronizedMap.class.size((SynchronizedMap)this);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Option put(Object key, Object value) {
                return SynchronizedMap.class.put((SynchronizedMap)this, (Object)key, (Object)value);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void update(Object key, Object value) {
                SynchronizedMap.class.update((SynchronizedMap)this, (Object)key, (Object)value);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Option remove(Object key) {
                return SynchronizedMap.class.remove((SynchronizedMap)this, (Object)key);
            }

            public void clear() {
                SynchronizedMap.class.clear((SynchronizedMap)this);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object getOrElseUpdate(Object key, Function0 function0) {
                return SynchronizedMap.class.getOrElseUpdate((SynchronizedMap)this, (Object)key, (Function0)function0);
            }

            public SynchronizedMap<Class<?>, String> transform(Function2<Class<?>, String, String> f) {
                return SynchronizedMap.class.transform((SynchronizedMap)this, f);
            }

            public SynchronizedMap<Class<?>, String> retain(Function2<Class<?>, String, Object> p) {
                return SynchronizedMap.class.retain((SynchronizedMap)this, p);
            }

            public Iterable<String> values() {
                return SynchronizedMap.class.values((SynchronizedMap)this);
            }

            public Iterator<String> valuesIterator() {
                return SynchronizedMap.class.valuesIterator((SynchronizedMap)this);
            }

            public Map<Class<?>, String> clone() {
                return SynchronizedMap.class.clone((SynchronizedMap)this);
            }

            public <U> void foreach(Function1<Tuple2<Class<?>, String>, U> f) {
                SynchronizedMap.class.foreach((SynchronizedMap)this, f);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object apply(Object key) {
                return SynchronizedMap.class.apply((SynchronizedMap)this, (Object)key);
            }

            public Set<Class<?>> keySet() {
                return SynchronizedMap.class.keySet((SynchronizedMap)this);
            }

            public Iterable<Class<?>> keys() {
                return SynchronizedMap.class.keys((SynchronizedMap)this);
            }

            public Iterator<Class<?>> keysIterator() {
                return SynchronizedMap.class.keysIterator((SynchronizedMap)this);
            }

            public boolean isEmpty() {
                return SynchronizedMap.class.isEmpty((SynchronizedMap)this);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public boolean contains(Object key) {
                return SynchronizedMap.class.contains((SynchronizedMap)this, (Object)key);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public boolean isDefinedAt(Object key) {
                return SynchronizedMap.class.isDefinedAt((SynchronizedMap)this, (Object)key);
            }
            {
                SynchronizedMap.class.$init$((SynchronizedMap)this);
            }
        };
    }

    public String getEntityClassHashId(Class<?> entityClass) {
        return (String)((SynchronizedMap)this.classHashIdsCache()).getOrElseUpdate(entityClass, (Function0)new Serializable(entityClass){
            public static final long serialVersionUID = 0L;
            private final Class entityClass$1;

            public final String apply() {
                return EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$getEntityClassHashId(EntityHelper$.MODULE$.getEntityName(this.entityClass$1));
            }
            {
                this.entityClass$1 = entityClass$1;
            }
        });
    }

    public Class<Entity> getEntityClassFromId(String entityId) {
        return (Class)this.getEntityClassFromIdOption(entityId).getOrElse((Function0)new Serializable(entityId){
            public static final long serialVersionUID = 0L;
            private final String entityId$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity id: ", ". Activate uses special UUID with the entity type information, \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entityId$1}))).append((Object)"so all entities IDs must be generated by Activate. It is possible to generate IDs using IdVar.generateId(entityClass: Class[_]).\n").append((Object)"It is also possible to create a domain-specific id, like a column 'userId' and index it, acting as a 'secondary' id.").toString());
            }
            {
                this.entityId$1 = entityId$1;
            }
        });
    }

    public Option<Class<Entity>> getEntityClassFromIdOption(String entityId) {
        None$ none$;
        String string = entityId;
        Option option = this.entityIdClassHashPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String hash = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.get((Object)hash).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<Entity> apply(EntityMetadata x$4) {
                    return x$4.entityClass();
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String net$fwbrasil$activate$entity$EntityHelper$$getEntityClassHashId(String entityName) {
        return this.normalizeHex(Integer.toHexString(entityName.hashCode()));
    }

    private String normalizeHex(String hex) {
        int length = hex.length();
        return length == 8 ? hex : (length < 8 ? new StringBuilder().append((Object)hex).append((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8 - length).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return "0";
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("")).toString() : hex.substring(0, 8));
    }

    public String getEntityName(Class<?> entityClass) {
        Alias alias = entityClass.getAnnotation(Alias.class);
        return alias == null ? entityClass.getSimpleName() : alias.value();
    }

    private EntityHelper$() {
        MODULE$ = this;
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.concreteEntityClasses = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.entityIdClassHashPattern = new StringOps(Predef$.MODULE$.augmentString("[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}-([0-9a-z]{8})")).r();
    }
}

