/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.activate.entity;

import java.util.concurrent.ConcurrentHashMap;
import net.fwbrasil.activate.entity.Entity;
import net.fwbrasil.activate.entity.EntityEnhancer$;
import net.fwbrasil.activate.entity.EntityHelper$;
import net.fwbrasil.activate.entity.EntityMetadata;
import net.fwbrasil.activate.entity.EntityValue$;
import net.fwbrasil.activate.entity.InternalAlias;
import net.fwbrasil.activate.util.Reflection$;
import net.fwbrasil.activate.util.uuid.UUIDUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class EntityHelper$ {
    public static final EntityHelper$ MODULE$;
    public final Map<String, EntityMetadata> net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas;
    private final Map<Class<? extends Entity>, List<Class<Entity>>> concreteEntityClasses;

    static {
        new EntityHelper$();
    }

    public void clearMetadatas() {
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.clear();
        this.concreteEntityClasses.clear();
    }

    public List<EntityMetadata> metadatas() {
        return (List)this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.values().toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EntityMetadata x$1) {
                return x$1.name();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public Set<Class<Entity>> allConcreteEntityClasses() {
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Class<Entity>> apply(Tuple2<String, EntityMetadata> m) {
                return EntityHelper$.MODULE$.concreteClasses(((EntityMetadata)m._2()).entityClass());
            }
        });
        return ((TraversableOnce)this.concreteEntityClasses.values().flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    public <E extends Entity> List<Class<Entity>> concreteClasses(Class<E> clazz) {
        return (List)this.concreteEntityClasses.getOrElseUpdate(clazz, (Function0)new Serializable(clazz){
            public static final long serialVersionUID = 0L;
            public final Class clazz$1;

            public final List<Class<Entity>> apply() {
                return ((TraversableOnce)EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, EntityMetadata> check$ifrefutable$1) {
                        Tuple2<String, EntityMetadata> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.concreteClasses.1 $outer;

                    public final boolean apply(Tuple2<String, EntityMetadata> x$2) {
                        Tuple2<String, EntityMetadata> tuple2 = x$2;
                        if (tuple2 != null) {
                            EntityMetadata metadata = (EntityMetadata)tuple2._2();
                            Class clazz = this.$outer.clazz$1;
                            Class<Entity> clazz2 = metadata.entityClass();
                            boolean bl = !((clazz == null ? clazz2 != null : !clazz.equals(clazz2)) && !this.$outer.clazz$1.isAssignableFrom(metadata.entityClass()) || !Reflection$.MODULE$.toRichClass(metadata.entityClass()).isConcreteClass());
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Class<Entity> apply(Tuple2<String, EntityMetadata> x$3) {
                        Tuple2<String, EntityMetadata> tuple2 = x$3;
                        if (tuple2 != null) {
                            EntityMetadata metadata = (EntityMetadata)tuple2._2();
                            Class<Entity> clazz = metadata.entityClass();
                            return clazz;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList();
            }
            {
                this.clazz$1 = clazz$1;
            }
        });
    }

    public synchronized void initialize(Class<?> referenceClass) {
        UUIDUtil$.MODULE$.generateUUID();
        EntityValue$.MODULE$.registerEncodersFor(referenceClass);
        EntityEnhancer$.MODULE$.enhancedEntityClasses(referenceClass).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Class<Entity> entityClass) {
                BoxedUnit boxedUnit;
                if (entityClass.isInterface()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String entityClassHashId = EntityHelper$.MODULE$.getEntityClassHashId(entityClass);
                    String entityName = EntityHelper$.MODULE$.getEntityName(entityClass);
                    boxedUnit = EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)entityClassHashId), (Object)new EntityMetadata(entityName, entityClass)));
                }
                return boxedUnit;
            }
        });
    }

    public Option<EntityMetadata> getEntityMetadataOption(Class<?> clazz) {
        return this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.get((Object)this.getEntityClassHashId(clazz));
    }

    public EntityMetadata getEntityMetadata(Class<?> clazz) {
        return (EntityMetadata)this.getEntityMetadataOption(clazz).get();
    }

    private ConcurrentHashMap<Class<?>, String> classHashIdsCache() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public String getEntityClassHashId(Class<?> entityClass) {
        void var2_2;
        Object object;
        String hash = this.classHashIdsCache().get(entityClass);
        if (hash == null) {
            hash = this.getEntityClassHashId(this.getEntityName(entityClass));
            object = this.classHashIdsCache().put(entityClass, hash);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public Class<Entity> getEntityClassFromId(String entityId) {
        return (Class)this.getEntityClassFromIdOption(entityId).getOrElse((Function0)new Serializable(entityId){
            public static final long serialVersionUID = 0L;
            private final String entityId$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity id: ", ". Activate uses special UUID with the entity type information, \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entityId$1}))).append((Object)"so all entities IDs must be generated by Activate. It is possible to generate IDs using IdVar.generateId(entityClass: Class[_]).\n").append((Object)"It is also possible to create a domain-specific id, like a column 'userId' and index it, acting as a 'secondary' id.").toString());
            }
            {
                this.entityId$1 = entityId$1;
            }
        });
    }

    public Option<Class<Entity>> getEntityClassFromIdOption(String entityId) {
        None$ none$;
        if (entityId.length() == 45) {
            String hash = entityId.substring(37, 45);
            none$ = this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.get((Object)hash).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<Entity> apply(EntityMetadata x$4) {
                    return x$4.entityClass();
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String getEntityClassHashId(String entityName) {
        return this.normalizeHex(Integer.toHexString(entityName.hashCode()));
    }

    private String normalizeHex(String hex) {
        int length = hex.length();
        return length == 8 ? hex : (length < 8 ? new StringBuilder().append((Object)hex).append((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8 - length).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return "0";
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("")).toString() : hex.substring(0, 8));
    }

    public String getEntityName(Class<?> entityClass) {
        InternalAlias alias = entityClass.getAnnotation(InternalAlias.class);
        return alias == null ? entityClass.getSimpleName() : alias.value();
    }

    private EntityHelper$() {
        MODULE$ = this;
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.concreteEntityClasses = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

