/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.activate.entity;

import java.util.concurrent.ConcurrentHashMap;
import net.fwbrasil.activate.entity.BaseEntity;
import net.fwbrasil.activate.entity.EntityEnhancer$;
import net.fwbrasil.activate.entity.EntityHelper$;
import net.fwbrasil.activate.entity.EntityMetadata;
import net.fwbrasil.activate.entity.EntityValue$;
import net.fwbrasil.activate.entity.InternalAlias;
import net.fwbrasil.activate.migration.StorageVersion;
import net.fwbrasil.activate.util.Reflection$;
import net.fwbrasil.activate.util.uuid.UUIDUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class EntityHelper$ {
    public static final EntityHelper$ MODULE$;
    public final Map<String, EntityMetadata> net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas;
    private final Map<Class<? extends BaseEntity>, List<Class<BaseEntity>>> concreteEntityClasses;

    static {
        new EntityHelper$();
    }

    public void clearMetadatas() {
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.clear();
        this.concreteEntityClasses.clear();
    }

    public List<EntityMetadata> metadatas() {
        return (List)this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.values().toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EntityMetadata x$1) {
                return x$1.name();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public Set<Class<BaseEntity>> allConcreteEntityClasses() {
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Class<BaseEntity>> apply(Tuple2<String, EntityMetadata> m) {
                return EntityHelper$.MODULE$.concreteClasses(((EntityMetadata)m._2()).entityClass());
            }
        });
        return ((TraversableOnce)this.concreteEntityClasses.values().flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    public <E extends BaseEntity> List<Class<BaseEntity>> concreteClasses(Class<E> clazz) {
        return (List)this.concreteEntityClasses.getOrElseUpdate(clazz, (Function0)new Serializable(clazz){
            public static final long serialVersionUID = 0L;
            public final Class clazz$1;

            public final List<Class<BaseEntity>> apply() {
                return (List)((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Class<BaseEntity> apply(Tuple2<String, EntityMetadata> x$2) {
                        return ((EntityMetadata)x$2._2()).entityClass();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Class<BaseEntity> x$3) {
                        return Reflection$.MODULE$.toRichClass(x$3).isConcreteClass();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.concreteClasses.1 $outer;

                    public final boolean apply(Class<?> x$1) {
                        return this.$outer.clazz$1.isAssignableFrom(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.concreteClasses.1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Class<BaseEntity> x$4) {
                        Class<BaseEntity> clazz = x$4;
                        Class<StorageVersion> clazz2 = StorageVersion.class;
                        if (clazz == null) {
                            if (clazz2 != null) {
                                return true;
                            }
                        } else if (!clazz.equals(clazz2)) return true;
                        Class clazz3 = this.$outer.clazz$1;
                        Class<StorageVersion> clazz4 = StorageVersion.class;
                        if (clazz3 == null) {
                            if (clazz4 == null) return true;
                            return false;
                        } else if (clazz3.equals(clazz4)) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).toList().sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Class<BaseEntity> a, Class<BaseEntity> b) {
                        return !a.isAssignableFrom(b);
                    }
                });
            }
            {
                this.clazz$1 = clazz$1;
            }
        });
    }

    public synchronized void initialize(List<Object> classpathHints) {
        UUIDUtil$.MODULE$.generateUUID();
        EntityValue$.MODULE$.registerEncodersFor(classpathHints);
        EntityEnhancer$.MODULE$.enhancedEntityClasses(classpathHints).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Class<BaseEntity> entityClass) {
                BoxedUnit boxedUnit;
                if (entityClass.isInterface()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String entityClassHashId = EntityHelper$.MODULE$.getEntityClassHashId(entityClass);
                    String entityName = EntityHelper$.MODULE$.getEntityName(entityClass);
                    boxedUnit = EntityHelper$.MODULE$.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)entityClassHashId), (Object)new EntityMetadata(entityName, entityClass)));
                }
                return boxedUnit;
            }
        });
    }

    public Option<EntityMetadata> getEntityMetadataOption(Class<?> clazz) {
        return this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.get((Object)this.getEntityClassHashId(clazz));
    }

    public EntityMetadata getEntityMetadata(Class<?> clazz) {
        return (EntityMetadata)this.getEntityMetadataOption(clazz).getOrElse((Function0)new Serializable(clazz){
            public static final long serialVersionUID = 0L;
            private final Class clazz$2;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity class ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clazz$2})));
            }
            {
                this.clazz$2 = clazz$2;
            }
        });
    }

    private ConcurrentHashMap<Class<?>, String> classHashIdsCache() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public String getEntityClassHashId(Class<?> entityClass) {
        void var2_2;
        Object object;
        String hash = this.classHashIdsCache().get(entityClass);
        if (hash == null) {
            hash = this.getEntityClassHashId(this.getEntityName(entityClass));
            object = this.classHashIdsCache().put(entityClass, hash);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public Class<BaseEntity> getEntityClassFromId(String entityId) {
        return (Class)this.getEntityClassFromIdOption(entityId).getOrElse((Function0)new Serializable(entityId){
            public static final long serialVersionUID = 0L;
            private final String entityId$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid entity id: ", ". Activate uses special UUID with the entity type information, \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entityId$1}))).append((Object)"so all entities IDs must be generated by Activate. It is possible to generate IDs using IdVar.generateId(entityClass: Class[_]).\n").append((Object)"It is also possible to create a domain-specific id, like a column 'userId' and index it, acting as a 'secondary' id.").toString());
            }
            {
                this.entityId$1 = entityId$1;
            }
        });
    }

    public Option<Class<BaseEntity>> getEntityClassFromIdOption(String entityId) {
        None$ none$;
        if (entityId.length() == 45) {
            String hash = entityId.substring(37, 45);
            none$ = this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas.get((Object)hash).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<BaseEntity> apply(EntityMetadata x$5) {
                    return x$5.entityClass();
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String getEntityClassHashId(String entityName) {
        return this.normalizeHex(Integer.toHexString(entityName.hashCode()));
    }

    private String normalizeHex(String hex) {
        int length = hex.length();
        return length == 8 ? hex : (length < 8 ? new StringBuilder().append((Object)hex).append((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8 - length).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return "0";
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("")).toString() : hex.substring(0, 8));
    }

    public String getEntityName(Class<?> entityClass) {
        InternalAlias alias = entityClass.getAnnotation(InternalAlias.class);
        return alias == null ? entityClass.getSimpleName() : alias.value();
    }

    private EntityHelper$() {
        MODULE$ = this;
        this.net$fwbrasil$activate$entity$EntityHelper$$entitiesMetadatas = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.concreteEntityClasses = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

