package net.fwbrasil.activate.statement.mass

import language.existentials
import net.fwbrasil.activate.statement.Where
import net.fwbrasil.activate.statement.From
import net.fwbrasil.activate.statement.StatementSelectValue
import net.fwbrasil.activate.statement.query.Query
import net.fwbrasil.activate.entity.BaseEntity
import net.fwbrasil.activate.statement.StatementValue
import net.fwbrasil.activate.statement.Where
import net.fwbrasil.activate.util.RichList._
import net.fwbrasil.activate.ActivateContext
import net.fwbrasil.activate.statement.Statement
import net.fwbrasil.activate.statement.StatementContext

trait MassUpdateContext extends StatementContext {

    import language.implicitConversions

    implicit def toUpdateAssignee[T](value: T)(implicit tval: (=> T) => StatementSelectValue) =
        UpdateAssigneeDecorator(tval(value))
    implicit def toWhereDecorator(where: Where) =
        WhereUpdateDecorator(where)
    import From._
    def produceUpdate[S, E1 <: BaseEntity: Manifest](f: (E1) => MassUpdateStatement): MassUpdateStatement =
        runAndClearFrom {
            f(mockEntity[E1])
        }
    def update[S, E1 <: BaseEntity: Manifest](f: (E1) => MassUpdateStatement): Unit =
        executeStatementWithParseCache[MassUpdateStatement, Unit](f, () => produceUpdate(f), (update: MassUpdateStatement) => update.execute)

}

case class WhereUpdateDecorator(where: Where) {
    def set(assignments: UpdateAssignment*) =
        MassUpdateStatement(From.from, where, assignments: _*)
}

case class UpdateAssigneeDecorator(assignee: StatementSelectValue) {
    def :=[T](value: => T)(implicit tval: (=> T) => StatementValue) =
        UpdateAssignment(assignee, tval(value))
}
case class UpdateAssignment(assignee: StatementSelectValue, value: StatementValue) {
    override def toString = assignee.toString + " := " + value.toString
}

case class MassUpdateStatement(override val from: From, override val where: Where, assignments: UpdateAssignment*)
        extends MassModificationStatement(from, where) {

    override def toString = from + " => where" + where + " set " + assignments.mkString(", ") + ""
}