/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.activate.storage.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fwbrasil.activate.OptimisticOfflineLocking$;
import net.fwbrasil.activate.entity.Entity;
import net.fwbrasil.activate.entity.EntityHelper$;
import net.fwbrasil.activate.entity.EntityValue;
import net.fwbrasil.activate.entity.EntityValue$;
import net.fwbrasil.activate.statement.And;
import net.fwbrasil.activate.statement.BooleanOperatorCriteria;
import net.fwbrasil.activate.statement.CompositeOperator;
import net.fwbrasil.activate.statement.CompositeOperatorCriteria;
import net.fwbrasil.activate.statement.Criteria;
import net.fwbrasil.activate.statement.EntitySource;
import net.fwbrasil.activate.statement.From;
import net.fwbrasil.activate.statement.IsEqualTo;
import net.fwbrasil.activate.statement.IsGreaterOrEqualTo;
import net.fwbrasil.activate.statement.IsGreaterThan;
import net.fwbrasil.activate.statement.IsLessOrEqualTo;
import net.fwbrasil.activate.statement.IsLessThan;
import net.fwbrasil.activate.statement.IsNotEqualTo;
import net.fwbrasil.activate.statement.IsNotNull;
import net.fwbrasil.activate.statement.IsNull;
import net.fwbrasil.activate.statement.Matcher;
import net.fwbrasil.activate.statement.Or;
import net.fwbrasil.activate.statement.SimpleOperator;
import net.fwbrasil.activate.statement.SimpleOperatorCriteria;
import net.fwbrasil.activate.statement.SimpleStatementBooleanValue;
import net.fwbrasil.activate.statement.SimpleValue;
import net.fwbrasil.activate.statement.StatementBooleanValue;
import net.fwbrasil.activate.statement.StatementEntityInstanceValue;
import net.fwbrasil.activate.statement.StatementEntitySourcePropertyValue;
import net.fwbrasil.activate.statement.StatementEntitySourceValue;
import net.fwbrasil.activate.statement.StatementSelectValue;
import net.fwbrasil.activate.statement.StatementValue;
import net.fwbrasil.activate.statement.Where;
import net.fwbrasil.activate.statement.mass.MassDeleteStatement;
import net.fwbrasil.activate.statement.mass.MassModificationStatement;
import net.fwbrasil.activate.statement.mass.MassUpdateStatement;
import net.fwbrasil.activate.statement.mass.UpdateAssignment;
import net.fwbrasil.activate.statement.query.LimitedOrderedQuery;
import net.fwbrasil.activate.statement.query.OrderBy;
import net.fwbrasil.activate.statement.query.OrderByCriteria;
import net.fwbrasil.activate.statement.query.OrderByDirection;
import net.fwbrasil.activate.statement.query.OrderedQuery;
import net.fwbrasil.activate.statement.query.Query;
import net.fwbrasil.activate.statement.query.orderByAscendingDirection$;
import net.fwbrasil.activate.storage.marshalling.BigDecimalStorageValue;
import net.fwbrasil.activate.storage.marshalling.BooleanStorageValue;
import net.fwbrasil.activate.storage.marshalling.ByteArrayStorageValue;
import net.fwbrasil.activate.storage.marshalling.DateStorageValue;
import net.fwbrasil.activate.storage.marshalling.DoubleStorageValue;
import net.fwbrasil.activate.storage.marshalling.FloatStorageValue;
import net.fwbrasil.activate.storage.marshalling.IntStorageValue;
import net.fwbrasil.activate.storage.marshalling.ListStorageValue;
import net.fwbrasil.activate.storage.marshalling.LongStorageValue;
import net.fwbrasil.activate.storage.marshalling.Marshaller$;
import net.fwbrasil.activate.storage.marshalling.ModifyStorageAction;
import net.fwbrasil.activate.storage.marshalling.ReferenceStorageValue;
import net.fwbrasil.activate.storage.marshalling.StorageAddColumn;
import net.fwbrasil.activate.storage.marshalling.StorageAddIndex;
import net.fwbrasil.activate.storage.marshalling.StorageAddReference;
import net.fwbrasil.activate.storage.marshalling.StorageCreateListTable;
import net.fwbrasil.activate.storage.marshalling.StorageCreateTable;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveColumn;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveIndex;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveListTable;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveReference;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveTable;
import net.fwbrasil.activate.storage.marshalling.StorageRenameColumn;
import net.fwbrasil.activate.storage.marshalling.StorageRenameTable;
import net.fwbrasil.activate.storage.marshalling.StorageValue;
import net.fwbrasil.activate.storage.marshalling.StringStorageValue;
import net.fwbrasil.activate.storage.mongo.MongoStorage;
import net.fwbrasil.activate.storage.mongo.MongoStorage$;
import net.fwbrasil.activate.storage.mongo.MongoStorage$$anonfun$net$fwbrasil$activate$storage$mongo$MongoStorage$;
import net.fwbrasil.activate.util.RichList$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

public abstract class MongoStorage$class {
    public static DB directAccess(MongoStorage $this) {
        return $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void delayedInit(MongoStorage $this, Function0 body2) {
        Object object;
        body2.apply$mcV$sp();
        MongoClient conn = new MongoClient($this.host(), $this.port());
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB_$eq(conn.getDB($this.db()));
        if ($this.authentication().isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)$this.authentication().get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            String user = (String)tuple22._1();
            String password = (String)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)user, (Object)password);
            String user2 = (String)tuple23._1();
            String password2 = (String)tuple23._2();
            object = BoxesRunTime.boxToBoolean((boolean)$this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().authenticate(user2, (char[])new StringOps(Predef$.MODULE$.augmentString(password2)).toArray(ClassTag$.MODULE$.Char())));
        } else {
            object = BoxedUnit.UNIT;
        }
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB();
    }

    public static boolean isMemoryStorage(MongoStorage $this) {
        return false;
    }

    public static boolean isSchemaless(MongoStorage $this) {
        return true;
    }

    public static boolean isTransactional(MongoStorage $this) {
        return false;
    }

    public static boolean supportsQueryJoin(MongoStorage $this) {
        return false;
    }

    public static Option store(MongoStorage $this, List statements, List insertList, List updateList, List deleteList) {
        MongoStorage$class.preVerifyStaleData($this, (List)updateList.$plus$plus((GenTraversableOnce)deleteList, List$.MODULE$.canBuildFrom()));
        MongoStorage$class.storeStatements($this, statements);
        MongoStorage$class.storeInserts($this, insertList);
        MongoStorage$class.storeUpdates($this, updateList);
        MongoStorage$class.storeDeletes($this, deleteList);
        return None$.MODULE$;
    }

    private static void preVerifyStaleData(MongoStorage $this, List data) {
        List invalid = (List)((TraversableLike)data.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> x$2) {
                return ((MapLike)x$2._2()).contains((Object)OptimisticOfflineLocking$.MODULE$.versionVarName());
            }
        })).filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;

            public final boolean apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = tuple;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Entity entity = (Entity)tuple2._1();
                    scala.collection.immutable.Map properties = (scala.collection.immutable.Map)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)entity, (Object)properties);
                    Entity entity2 = (Entity)tuple23._1();
                    scala.collection.immutable.Map properties2 = (scala.collection.immutable.Map)tuple23._2();
                    BasicDBObject query2 = new BasicDBObject();
                    query2.put("_id", (Object)entity2.id());
                    MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$addVersionCondition(this.$outer, query2, properties2);
                    int result = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entity2).find((DBObject)query2).count();
                    return result == 1;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (invalid.nonEmpty()) {
            throw $this.staleDataException(((TraversableOnce)invalid.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> x$4) {
                    return ((Entity)x$4._1()).id();
                }
            }, List$.MODULE$.canBuildFrom())).toSet());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object net$fwbrasil$activate$storage$mongo$MongoStorage$$addVersionCondition(MongoStorage $this, BasicDBObject query2, scala.collection.immutable.Map properties) {
        Object object;
        if (properties.contains((Object)OptimisticOfflineLocking$.MODULE$.versionVarName())) {
            BasicDBObject nullVersion = new BasicDBObject();
            nullVersion.put(OptimisticOfflineLocking$.MODULE$.versionVarName(), null);
            BasicDBObject versionValue = new BasicDBObject();
            Object object2 = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue($this, (StorageValue)properties.apply((Object)OptimisticOfflineLocking$.MODULE$.versionVarName()));
            if (!(object2 instanceof Long)) throw new MatchError(object2);
            long l = BoxesRunTime.unboxToLong((Object)object2);
            Long l2 = BoxesRunTime.boxToLong((long)(l - 1L));
            versionValue.put(OptimisticOfflineLocking$.MODULE$.versionVarName(), (Object)l2);
            BasicDBList versionQuery = new BasicDBList();
            versionQuery.add(nullVersion);
            versionQuery.add(versionValue);
            object = query2.put("$or", (Object)versionQuery);
            return object;
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private static void storeDeletes(MongoStorage $this, List deleteList) {
        deleteList.withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> check$ifrefutable$1) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;

            public final void apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> x$5) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = x$5;
                if (tuple2 != null) {
                    Entity entity = (Entity)tuple2._1();
                    scala.collection.immutable.Map properties = (scala.collection.immutable.Map)tuple2._2();
                    BasicDBObject query2 = new BasicDBObject();
                    query2.put("_id", (Object)entity.id());
                    MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$addVersionCondition(this.$outer, query2, properties);
                    WriteResult result = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entity).remove((DBObject)query2);
                    if (result.getN() != 1) {
                        throw this.$outer.staleDataException((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{entity.id()})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private static void storeUpdates(MongoStorage $this, List updateList) {
        updateList.withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> check$ifrefutable$2) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;

            public final void apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> x$8) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = x$8;
                if (tuple2 != null) {
                    Entity entity = (Entity)tuple2._1();
                    scala.collection.immutable.Map properties = (scala.collection.immutable.Map)tuple2._2();
                    BasicDBObject query2 = new BasicDBObject();
                    query2.put("_id", (Object)entity.id());
                    BasicDBObject set = new BasicDBObject();
                    properties.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, StorageValue> check$ifrefutable$3) {
                            Tuple2<String, StorageValue> tuple2 = check$ifrefutable$3;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, StorageValue> x$6) {
                            Tuple2<String, StorageValue> tuple2 = x$6;
                            if (tuple2 != null) {
                                String name;
                                String string = name = (String)tuple2._1();
                                String string2 = "id";
                                boolean bl = string != null ? !string.equals(string2) : string2 != null;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    }).foreach((Function1)new Serializable(this, set){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoStorage$.anonfun.storeUpdates.2 $outer;
                        private final BasicDBObject set$2;

                        public final Object apply(Tuple2<String, StorageValue> x$7) {
                            Tuple2<String, StorageValue> tuple2 = x$7;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                StorageValue value = (StorageValue)tuple2._2();
                                BasicDBObject inner = new BasicDBObject();
                                Object object = this.set$2.put(name, MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue(this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer(), value));
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.set$2 = set$2;
                        }
                    });
                    BasicDBObject update = new BasicDBObject();
                    update.put("$set", (Object)set);
                    MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$addVersionCondition(this.$outer, query2, properties);
                    WriteResult result = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entity).update((DBObject)query2, (DBObject)update);
                    if (result.getN() != 1) {
                        throw this.$outer.staleDataException((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{entity.id()})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private static void storeInserts(MongoStorage $this, List insertList) {
        IdentityHashMap insertMap = new IdentityHashMap();
        insertList.withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> check$ifrefutable$4) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, insertMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;
            private final IdentityHashMap insertMap$1;

            public final ListBuffer<BasicDBObject> apply(Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> x$11) {
                Tuple2<Entity, scala.collection.immutable.Map<String, StorageValue>> tuple2 = x$11;
                if (tuple2 != null) {
                    Entity entity = (Entity)tuple2._1();
                    scala.collection.immutable.Map properties = (scala.collection.immutable.Map)tuple2._2();
                    BasicDBObject doc = new BasicDBObject();
                    properties.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, StorageValue> check$ifrefutable$5) {
                            Tuple2<String, StorageValue> tuple2 = check$ifrefutable$5;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, StorageValue> x$9) {
                            Tuple2<String, StorageValue> tuple2 = x$9;
                            if (tuple2 != null) {
                                String name;
                                String string = name = (String)tuple2._1();
                                String string2 = "id";
                                boolean bl = string != null ? !string.equals(string2) : string2 != null;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    }).foreach((Function1)new Serializable(this, doc){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoStorage$.anonfun.storeInserts.2 $outer;
                        private final BasicDBObject doc$1;

                        public final Object apply(Tuple2<String, StorageValue> x$10) {
                            Tuple2<String, StorageValue> tuple2 = x$10;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                StorageValue value = (StorageValue)tuple2._2();
                                Object object = this.doc$1.put(name, MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue(this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer(), value));
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.doc$1 = doc$1;
                        }
                    });
                    doc.put("_id", (Object)entity.id());
                    ListBuffer listBuffer = ((ListBuffer)JavaConversions$.MODULE$.mapAsScalaMap((Map)this.insertMap$1).getOrElseUpdate(entity.getClass(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ListBuffer<BasicDBObject> apply() {
                            return (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                        }
                    })).$plus$eq((Object)doc);
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.insertMap$1 = insertMap$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(insertMap).keys().foreach((Function1)new Serializable($this, insertMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;
            private final IdentityHashMap insertMap$1;

            public final WriteResult apply(Class<?> entityClass) {
                return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entityClass).insert(JavaConversions$.MODULE$.seqAsJavaList((Seq)JavaConversions$.MODULE$.mapAsScalaMap((Map)this.insertMap$1).apply(entityClass)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.insertMap$1 = insertMap$1;
            }
        });
    }

    private static void storeStatements(MongoStorage $this, List statements) {
        statements.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;

            public final WriteResult apply(MassModificationStatement statement) {
                Tuple2 tuple2;
                block2: {
                    MassModificationStatement massModificationStatement;
                    block5: {
                        WriteResult writeResult;
                        block4: {
                            DBObject where;
                            DBCollection coll;
                            block3: {
                                Tuple2 tuple22;
                                tuple2 = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$collectionAndWhere(this.$outer, statement.from(), statement.where(), MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$collectionAndWhere$default$3(this.$outer));
                                if (tuple2 == null) break block2;
                                DBCollection coll2 = (DBCollection)tuple2._1();
                                DBObject where2 = (DBObject)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)coll2, (Object)where2);
                                coll = (DBCollection)tuple23._1();
                                where = (DBObject)tuple23._2();
                                massModificationStatement = statement;
                                if (!(massModificationStatement instanceof MassUpdateStatement)) break block3;
                                MassUpdateStatement massUpdateStatement = (MassUpdateStatement)massModificationStatement;
                                BasicDBObject set = new BasicDBObject();
                                massUpdateStatement.assignments().foreach((Function1)new Serializable(this, set){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MongoStorage$.anonfun.storeStatements.1 $outer;
                                    private final BasicDBObject set$1;

                                    public final Object apply(UpdateAssignment assignment) {
                                        return this.set$1.put(this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer().mongoStatementSelectValue(assignment.assignee()), this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer().getMongoValue(assignment.value()));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.set$1 = set$1;
                                    }
                                });
                                BasicDBObject mongoUpdate = new BasicDBObject();
                                mongoUpdate.put("$set", (Object)set);
                                writeResult = coll.updateMulti(where, (DBObject)mongoUpdate);
                                break block4;
                            }
                            if (!(massModificationStatement instanceof MassDeleteStatement)) break block5;
                            writeResult = coll.remove(where);
                        }
                        return writeResult;
                    }
                    throw new MatchError((Object)massModificationStatement);
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Object net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue(MongoStorage $this, StorageValue value) {
        StorageValue storageValue;
        block13: {
            Object object;
            block3: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        storageValue = value;
                                                        if (!(storageValue instanceof IntStorageValue)) break block2;
                                                        IntStorageValue intStorageValue = (IntStorageValue)storageValue;
                                                        object = intStorageValue.value().map((Function1)new Serializable($this){
                                                            public static final long serialVersionUID = 0L;

                                                            public final int apply(int x$13) {
                                                                return this.apply$mcII$sp(x$13);
                                                            }

                                                            public int apply$mcII$sp(int x$13) {
                                                                return Predef$.MODULE$.int2Integer(x$13);
                                                            }
                                                        }).getOrElse((Function0)new Serializable($this){
                                                            public static final long serialVersionUID = 0L;

                                                            public final Null$ apply() {
                                                                return null;
                                                            }
                                                        });
                                                        break block3;
                                                    }
                                                    if (!(storageValue instanceof LongStorageValue)) break block4;
                                                    LongStorageValue longStorageValue = (LongStorageValue)storageValue;
                                                    object = longStorageValue.value().map((Function1)new Serializable($this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final long apply(long x$14) {
                                                            return this.apply$mcJJ$sp(x$14);
                                                        }

                                                        public long apply$mcJJ$sp(long x$14) {
                                                            return Predef$.MODULE$.long2Long(x$14);
                                                        }
                                                    }).getOrElse((Function0)new Serializable($this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Null$ apply() {
                                                            return null;
                                                        }
                                                    });
                                                    break block3;
                                                }
                                                if (!(storageValue instanceof BooleanStorageValue)) break block5;
                                                BooleanStorageValue booleanStorageValue = (BooleanStorageValue)storageValue;
                                                object = booleanStorageValue.value().map((Function1)new Serializable($this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final boolean apply(boolean x$15) {
                                                        return Predef$.MODULE$.boolean2Boolean(x$15);
                                                    }
                                                }).getOrElse((Function0)new Serializable($this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Null$ apply() {
                                                        return null;
                                                    }
                                                });
                                                break block3;
                                            }
                                            if (!(storageValue instanceof StringStorageValue)) break block6;
                                            StringStorageValue stringStorageValue = (StringStorageValue)storageValue;
                                            object = stringStorageValue.value().getOrElse((Function0)new Serializable($this){
                                                public static final long serialVersionUID = 0L;

                                                public final Null$ apply() {
                                                    return null;
                                                }
                                            });
                                            break block3;
                                        }
                                        if (!(storageValue instanceof FloatStorageValue)) break block7;
                                        FloatStorageValue floatStorageValue = (FloatStorageValue)storageValue;
                                        object = floatStorageValue.value().map((Function1)new Serializable($this){
                                            public static final long serialVersionUID = 0L;

                                            public final double apply(float x$16) {
                                                return this.apply$mcDF$sp(x$16);
                                            }

                                            public double apply$mcDF$sp(float x$16) {
                                                return Predef$.MODULE$.float2Float(x$16).doubleValue();
                                            }
                                        }).getOrElse((Function0)new Serializable($this){
                                            public static final long serialVersionUID = 0L;

                                            public final Null$ apply() {
                                                return null;
                                            }
                                        });
                                        break block3;
                                    }
                                    if (!(storageValue instanceof DateStorageValue)) break block8;
                                    DateStorageValue dateStorageValue = (DateStorageValue)storageValue;
                                    object = dateStorageValue.value().getOrElse((Function0)new Serializable($this){
                                        public static final long serialVersionUID = 0L;

                                        public final Null$ apply() {
                                            return null;
                                        }
                                    });
                                    break block3;
                                }
                                if (!(storageValue instanceof DoubleStorageValue)) break block9;
                                DoubleStorageValue doubleStorageValue = (DoubleStorageValue)storageValue;
                                object = doubleStorageValue.value().map((Function1)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(double x$17) {
                                        return this.apply$mcDD$sp(x$17);
                                    }

                                    public double apply$mcDD$sp(double x$17) {
                                        return Predef$.MODULE$.double2Double(x$17);
                                    }
                                }).getOrElse((Function0)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply() {
                                        return null;
                                    }
                                });
                                break block3;
                            }
                            if (!(storageValue instanceof BigDecimalStorageValue)) break block10;
                            BigDecimalStorageValue bigDecimalStorageValue = (BigDecimalStorageValue)storageValue;
                            object = bigDecimalStorageValue.value().map((Function1)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(BigDecimal x$18) {
                                    return x$18.doubleValue();
                                }
                            }).getOrElse((Function0)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final Null$ apply() {
                                    return null;
                                }
                            });
                            break block3;
                        }
                        if (!(storageValue instanceof ListStorageValue)) break block11;
                        ListStorageValue listStorageValue = (ListStorageValue)storageValue;
                        object = listStorageValue.value().map((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoStorage $outer;

                            /*
                             * WARNING - void declaration
                             */
                            public final BasicDBList apply(List<StorageValue> list) {
                                void var2_2;
                                BasicDBList dbList = new BasicDBList();
                                list.foreach((Function1)new Serializable(this, dbList){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MongoStorage$$anonfun$net$fwbrasil$activate$storage$mongo$MongoStorage$.getMongoValue.15 $outer;
                                    private final BasicDBList dbList$1;

                                    public final boolean apply(StorageValue elem) {
                                        return this.dbList$1.add(MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue(this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer(), elem));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.dbList$1 = dbList$1;
                                    }
                                });
                                return var2_2;
                            }

                            public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }).orNull(Predef$.MODULE$.conforms());
                        break block3;
                    }
                    if (!(storageValue instanceof ByteArrayStorageValue)) break block12;
                    ByteArrayStorageValue byteArrayStorageValue = (ByteArrayStorageValue)storageValue;
                    object = byteArrayStorageValue.value().getOrElse((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    });
                    break block3;
                }
                if (!(storageValue instanceof ReferenceStorageValue)) break block13;
                ReferenceStorageValue referenceStorageValue = (ReferenceStorageValue)storageValue;
                object = referenceStorageValue.value().getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            return object;
        }
        throw new MatchError((Object)storageValue);
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, Entity entity) {
        return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, entity.getClass());
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, Class entityClass) {
        return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, EntityHelper$.MODULE$.getEntityName(entityClass));
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, String entityName) {
        return $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().getCollection(entityName);
    }

    public static List query(MongoStorage $this, Query queryInstance, List expectedTypes, List entitiesReadFromCache) {
        From from = queryInstance.from();
        Tuple2 tuple2 = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$collectionAndWhere($this, from, queryInstance.where(), entitiesReadFromCache);
        if (tuple2 != null) {
            Tuple2 tuple22;
            DBCollection coll = (DBCollection)tuple2._1();
            DBObject where = (DBObject)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)coll, (Object)where);
            DBCollection coll2 = (DBCollection)tuple23._1();
            DBObject where2 = (DBObject)tuple23._2();
            Seq selectValues = queryInstance.select().values();
            BasicDBObject select = MongoStorage$class.querySelect($this, queryInstance, selectValues);
            DBCursor ret = coll2.find(where2, (DBObject)select);
            MongoStorage$class.orderQueryIfNecessary($this, queryInstance, ret);
            MongoStorage$class.limitQueryIfNecessary($this, queryInstance, ret);
            return MongoStorage$class.transformResultToTheExpectedTypes($this, expectedTypes, selectValues, ret);
        }
        throw new MatchError((Object)tuple2);
    }

    public static StorageValue getStorageValue(MongoStorage $this, Object obj, StorageValue storageValue) {
        StorageValue storageValue2;
        block13: {
            IntStorageValue intStorageValue;
            block3: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        storageValue2 = storageValue;
                                                        if (!(storageValue2 instanceof IntStorageValue)) break block2;
                                                        intStorageValue = new IntStorageValue(MongoStorage$class.getValue$1($this, obj));
                                                        break block3;
                                                    }
                                                    if (!(storageValue2 instanceof LongStorageValue)) break block4;
                                                    intStorageValue = new LongStorageValue(MongoStorage$class.getValue$1($this, obj));
                                                    break block3;
                                                }
                                                if (!(storageValue2 instanceof BooleanStorageValue)) break block5;
                                                intStorageValue = new BooleanStorageValue(MongoStorage$class.getValue$1($this, obj));
                                                break block3;
                                            }
                                            if (!(storageValue2 instanceof StringStorageValue)) break block6;
                                            intStorageValue = new StringStorageValue(MongoStorage$class.getValue$1($this, obj));
                                            break block3;
                                        }
                                        if (!(storageValue2 instanceof FloatStorageValue)) break block7;
                                        intStorageValue = new FloatStorageValue(MongoStorage$class.getValue$1($this, obj).map((Function1)new Serializable($this){
                                            public static final long serialVersionUID = 0L;

                                            public final float apply(double x$20) {
                                                return this.apply$mcFD$sp(x$20);
                                            }

                                            public float apply$mcFD$sp(double x$20) {
                                                return Predef$.MODULE$.double2Double(x$20).floatValue();
                                            }
                                        }));
                                        break block3;
                                    }
                                    if (!(storageValue2 instanceof DateStorageValue)) break block8;
                                    intStorageValue = new DateStorageValue(MongoStorage$class.getValue$1($this, obj));
                                    break block3;
                                }
                                if (!(storageValue2 instanceof DoubleStorageValue)) break block9;
                                intStorageValue = new DoubleStorageValue(MongoStorage$class.getValue$1($this, obj));
                                break block3;
                            }
                            if (!(storageValue2 instanceof BigDecimalStorageValue)) break block10;
                            intStorageValue = new BigDecimalStorageValue(MongoStorage$class.getValue$1($this, obj).map((Function1)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final BigDecimal apply(double x$21) {
                                    return package$.MODULE$.BigDecimal().apply(x$21);
                                }
                            }));
                            break block3;
                        }
                        if (!(storageValue2 instanceof ListStorageValue)) break block11;
                        ListStorageValue listStorageValue = (ListStorageValue)storageValue2;
                        intStorageValue = new ListStorageValue(MongoStorage$class.getValue$1($this, obj).map((Function1)new Serializable($this, listStorageValue){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoStorage $outer;
                            public final ListStorageValue x10$1;

                            public final List<StorageValue> apply(BasicDBList dbList) {
                                return ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)dbList).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MongoStorage$.anonfun.getStorageValue.3 $outer;

                                    public final StorageValue apply(Object elem) {
                                        return this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer().getStorageValue(elem, this.$outer.x10$1.emptyStorageValue());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Buffer$.MODULE$.canBuildFrom())).toList();
                            }

                            public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.x10$1 = x10$1;
                            }
                        }), listStorageValue.emptyStorageValue());
                        break block3;
                    }
                    if (!(storageValue2 instanceof ByteArrayStorageValue)) break block12;
                    intStorageValue = new ByteArrayStorageValue(MongoStorage$class.getValue$1($this, obj));
                    break block3;
                }
                if (!(storageValue2 instanceof ReferenceStorageValue)) break block13;
                intStorageValue = new ReferenceStorageValue(MongoStorage$class.getValue$1($this, obj));
            }
            return intStorageValue;
        }
        throw new MatchError((Object)storageValue2);
    }

    public static StorageValue getValue(MongoStorage $this, DBObject obj, String name, StorageValue storageValue) {
        return $this.getStorageValue(obj.get(name), storageValue);
    }

    public static Option getValue(MongoStorage $this, DBObject obj, String name) {
        return Option$.MODULE$.apply(obj.get(name));
    }

    public static Seq query(MongoStorage $this, Seq values) {
        return (Seq)values.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;

            public final String apply(StatementSelectValue<?> value) {
                return this.$outer.mongoStatementSelectValue(value);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static String mongoStatementSelectValue(MongoStorage $this, StatementSelectValue value) {
        block4: {
            String string;
            block3: {
                StatementSelectValue statementSelectValue;
                block2: {
                    String name;
                    statementSelectValue = value;
                    if (!(statementSelectValue instanceof StatementEntitySourcePropertyValue)) break block2;
                    StatementEntitySourcePropertyValue statementEntitySourcePropertyValue = (StatementEntitySourcePropertyValue)statementSelectValue;
                    String string2 = name = (String)RichList$.MODULE$.toRichList((Iterable)statementEntitySourcePropertyValue.propertyPathNames(), ManifestFactory$.MODULE$.classType(String.class)).onlyOne();
                    String string3 = "id";
                    string = !(string2 != null ? !string2.equals(string3) : string3 != null) ? "_id" : name;
                    break block3;
                }
                if (!(statementSelectValue instanceof StatementEntitySourceValue)) break block4;
                string = "_id";
            }
            return string;
        }
        throw new UnsupportedOperationException("Mongo storage supports only entity properties inside select clause.");
    }

    public static DBObject query(MongoStorage $this, Criteria criteria) {
        Criteria criteria2;
        block8: {
            SimpleOperator simpleOperator;
            block11: {
                BasicDBObject basicDBObject;
                block6: {
                    BasicDBObject basicDBObject2;
                    String property;
                    BasicDBObject obj;
                    block10: {
                        block9: {
                            block7: {
                                Object object;
                                block5: {
                                    obj = new BasicDBObject();
                                    criteria2 = criteria;
                                    if (!(criteria2 instanceof BooleanOperatorCriteria)) break block5;
                                    BooleanOperatorCriteria booleanOperatorCriteria = (BooleanOperatorCriteria)criteria2;
                                    BasicDBList list = new BasicDBList();
                                    list.add($this.query(booleanOperatorCriteria.valueA()));
                                    list.add($this.query(booleanOperatorCriteria.valueB()));
                                    String operator = $this.query((CompositeOperator)booleanOperatorCriteria.operator());
                                    obj.put(operator, (Object)list);
                                    basicDBObject = obj;
                                    break block6;
                                }
                                if (!(criteria2 instanceof CompositeOperatorCriteria)) break block7;
                                CompositeOperatorCriteria compositeOperatorCriteria = (CompositeOperatorCriteria)criteria2;
                                String property2 = $this.queryEntityProperty(compositeOperatorCriteria.valueA());
                                Object value = $this.getMongoValue(compositeOperatorCriteria.valueB());
                                if (compositeOperatorCriteria.operator() instanceof IsEqualTo) {
                                    object = obj.put(property2, value);
                                } else {
                                    String operator = $this.query(compositeOperatorCriteria.operator());
                                    BasicDBObject innerObj = new BasicDBObject();
                                    innerObj.put(operator, value);
                                    object = obj.put(property2, (Object)innerObj);
                                }
                                basicDBObject = obj;
                                break block6;
                            }
                            if (!(criteria2 instanceof SimpleOperatorCriteria)) break block8;
                            SimpleOperatorCriteria simpleOperatorCriteria = (SimpleOperatorCriteria)criteria2;
                            property = $this.queryEntityProperty(simpleOperatorCriteria.valueA());
                            simpleOperator = simpleOperatorCriteria.operator();
                            if (!(simpleOperator instanceof IsNull)) break block9;
                            basicDBObject2 = null;
                            break block10;
                        }
                        if (!(simpleOperator instanceof IsNotNull)) break block11;
                        BasicDBObject temp = new BasicDBObject();
                        temp.put("$ne", null);
                        basicDBObject2 = temp;
                    }
                    BasicDBObject value = basicDBObject2;
                    obj.put(property, value);
                    basicDBObject = obj;
                }
                return basicDBObject;
            }
            throw new MatchError((Object)simpleOperator);
        }
        throw new MatchError((Object)criteria2);
    }

    public static Object getMongoValue(MongoStorage $this, StatementValue value) {
        block6: {
            Object object;
            block3: {
                StatementValue statementValue;
                block5: {
                    block4: {
                        block2: {
                            statementValue = value;
                            if (!(statementValue instanceof SimpleStatementBooleanValue)) break block2;
                            SimpleStatementBooleanValue simpleStatementBooleanValue = (SimpleStatementBooleanValue)statementValue;
                            object = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue($this, Marshaller$.MODULE$.marshalling((EntityValue)EntityValue$.MODULE$.toBooleanEntityValue(simpleStatementBooleanValue.value())));
                            break block3;
                        }
                        if (!(statementValue instanceof SimpleValue)) break block4;
                        SimpleValue simpleValue = (SimpleValue)statementValue;
                        object = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue($this, Marshaller$.MODULE$.marshalling(simpleValue.entityValue()));
                        break block3;
                    }
                    if (!(statementValue instanceof StatementEntityInstanceValue)) break block5;
                    StatementEntityInstanceValue statementEntityInstanceValue = (StatementEntityInstanceValue)statementValue;
                    object = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$getMongoValue($this, (StorageValue)new StringStorageValue(Option$.MODULE$.apply((Object)statementEntityInstanceValue.entityId())));
                    break block3;
                }
                if (statementValue != null) break block6;
                object = null;
            }
            return object;
        }
        throw new UnsupportedOperationException("Mongo storage doesn't support joins.");
    }

    public static DBObject query(MongoStorage $this, StatementBooleanValue value) {
        StatementBooleanValue statementBooleanValue;
        block4: {
            DBObject dBObject;
            block3: {
                block2: {
                    statementBooleanValue = value;
                    if (!(statementBooleanValue instanceof Criteria)) break block2;
                    Criteria criteria = (Criteria)statementBooleanValue;
                    dBObject = $this.query(criteria);
                    break block3;
                }
                if (!(statementBooleanValue instanceof SimpleStatementBooleanValue)) break block4;
                SimpleStatementBooleanValue simpleStatementBooleanValue = (SimpleStatementBooleanValue)statementBooleanValue;
                BasicDBList list = new BasicDBList();
                list.add(((Object)BoxesRunTime.boxToBoolean((boolean)simpleStatementBooleanValue.value())).toString());
                dBObject = list;
            }
            return dBObject;
        }
        throw new MatchError((Object)statementBooleanValue);
    }

    public static String queryEntityProperty(MongoStorage $this, StatementValue value) {
        block4: {
            String string;
            block3: {
                StatementValue statementValue;
                block2: {
                    String name;
                    statementValue = value;
                    if (!(statementValue instanceof StatementEntitySourcePropertyValue)) break block2;
                    StatementEntitySourcePropertyValue statementEntitySourcePropertyValue = (StatementEntitySourcePropertyValue)statementValue;
                    String string2 = name = (String)RichList$.MODULE$.toRichList((Iterable)statementEntitySourcePropertyValue.propertyPathNames(), ManifestFactory$.MODULE$.classType(String.class)).onlyOne();
                    String string3 = "id";
                    string = !(string2 != null ? !string2.equals(string3) : string3 != null) ? "_id" : name;
                    break block3;
                }
                if (!(statementValue instanceof StatementEntitySourceValue)) break block4;
                string = "_id";
            }
            return string;
        }
        throw new UnsupportedOperationException("Mongo storage doesn't support joins.");
    }

    public static String query(MongoStorage $this, CompositeOperator operator) {
        CompositeOperator compositeOperator;
        block12: {
            String string;
            block5: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            compositeOperator = operator;
                                            if (!(compositeOperator instanceof And)) break block4;
                                            string = "$and";
                                            break block5;
                                        }
                                        if (!(compositeOperator instanceof Or)) break block6;
                                        string = "$or";
                                        break block5;
                                    }
                                    if (!(compositeOperator instanceof IsGreaterOrEqualTo)) break block7;
                                    string = "$gte";
                                    break block5;
                                }
                                if (!(compositeOperator instanceof IsGreaterThan)) break block8;
                                string = "$gt";
                                break block5;
                            }
                            if (!(compositeOperator instanceof IsLessOrEqualTo)) break block9;
                            string = "$lte";
                            break block5;
                        }
                        if (!(compositeOperator instanceof IsLessThan)) break block10;
                        string = "$lt";
                        break block5;
                    }
                    if (!(compositeOperator instanceof Matcher)) break block11;
                    string = "$regex";
                    break block5;
                }
                if (!(compositeOperator instanceof IsNotEqualTo)) break block12;
                string = "$ne";
            }
            return string;
        }
        if (compositeOperator instanceof IsEqualTo) {
            throw new UnsupportedOperationException("Mongo doesn't have $eq operator yet (https://jira.mongodb.org/browse/SERVER-1367).");
        }
        throw new MatchError((Object)compositeOperator);
    }

    public static void migrateStorage(MongoStorage $this, ModifyStorageAction action) {
        ModifyStorageAction modifyStorageAction;
        block21: {
            block10: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                BoxedUnit boxedUnit;
                                block16: {
                                    BoxedUnit boxedUnit2;
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block9: {
                                                            BoxedUnit boxedUnit3;
                                                            modifyStorageAction = action;
                                                            if (!(modifyStorageAction instanceof StorageCreateTable)) break block9;
                                                            StorageCreateTable storageCreateTable = (StorageCreateTable)modifyStorageAction;
                                                            if (storageCreateTable.ifNotExists() && $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().collectionExists(storageCreateTable.tableName())) {
                                                                boxedUnit3 = BoxedUnit.UNIT;
                                                            } else {
                                                                $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().createCollection(storageCreateTable.tableName(), (DBObject)new BasicDBObject());
                                                                boxedUnit3 = BoxedUnit.UNIT;
                                                            }
                                                            BoxedUnit boxedUnit4 = boxedUnit3;
                                                            break block10;
                                                        }
                                                        if (!(modifyStorageAction instanceof StorageRenameTable)) break block11;
                                                        StorageRenameTable storageRenameTable = (StorageRenameTable)modifyStorageAction;
                                                        MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRenameTable.oldName()).rename(storageRenameTable.newName());
                                                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                                        break block10;
                                                    }
                                                    if (!(modifyStorageAction instanceof StorageRemoveTable)) break block12;
                                                    StorageRemoveTable storageRemoveTable = (StorageRemoveTable)modifyStorageAction;
                                                    MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRemoveTable.name()).drop();
                                                    BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                                    break block10;
                                                }
                                                if (!(modifyStorageAction instanceof StorageAddColumn)) break block13;
                                                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                                                break block10;
                                            }
                                            if (!(modifyStorageAction instanceof StorageRenameColumn)) break block14;
                                            StorageRenameColumn storageRenameColumn = (StorageRenameColumn)modifyStorageAction;
                                            BasicDBObject update = new BasicDBObject();
                                            BasicDBObject updateInner = new BasicDBObject();
                                            updateInner.put(storageRenameColumn.oldName(), (Object)storageRenameColumn.column().name());
                                            update.put("$rename", (Object)updateInner);
                                            MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRenameColumn.tableName()).update((DBObject)new BasicDBObject(), (DBObject)update);
                                            BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                            break block10;
                                        }
                                        if (!(modifyStorageAction instanceof StorageRemoveColumn)) break block15;
                                        StorageRemoveColumn storageRemoveColumn = (StorageRemoveColumn)modifyStorageAction;
                                        BasicDBObject update = new BasicDBObject();
                                        BasicDBObject updateInner = new BasicDBObject();
                                        updateInner.put(storageRemoveColumn.name(), (Object)BoxesRunTime.boxToInteger((int)1));
                                        update.put("$unset", (Object)updateInner);
                                        MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRemoveColumn.tableName()).update((DBObject)new BasicDBObject(), (DBObject)update);
                                        BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                                        break block10;
                                    }
                                    if (!(modifyStorageAction instanceof StorageAddIndex)) break block16;
                                    StorageAddIndex storageAddIndex = (StorageAddIndex)modifyStorageAction;
                                    BasicDBObject obj = new BasicDBObject();
                                    obj.put(storageAddIndex.columnName(), (Object)BoxesRunTime.boxToInteger((int)1));
                                    BasicDBObject options = new BasicDBObject();
                                    Object object = storageAddIndex.unique() ? options.put("unique", (Object)BoxesRunTime.boxToBoolean((boolean)true)) : BoxedUnit.UNIT;
                                    if (storageAddIndex.ifNotExists() && MongoStorage$class.collHasIndex($this, storageAddIndex.tableName(), storageAddIndex.columnName())) {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageAddIndex.tableName()).ensureIndex((DBObject)obj, (DBObject)options);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit10 = boxedUnit2;
                                    break block10;
                                }
                                if (!(modifyStorageAction instanceof StorageRemoveIndex)) break block17;
                                StorageRemoveIndex storageRemoveIndex = (StorageRemoveIndex)modifyStorageAction;
                                BasicDBObject obj = new BasicDBObject();
                                obj.put(storageRemoveIndex.columnName(), (Object)BoxesRunTime.boxToInteger((int)1));
                                if (storageRemoveIndex.ifExists() && !MongoStorage$class.collHasIndex($this, storageRemoveIndex.tableName(), storageRemoveIndex.columnName())) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRemoveIndex.tableName()).dropIndex((DBObject)obj);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit11 = boxedUnit;
                                break block10;
                            }
                            if (!(modifyStorageAction instanceof StorageAddReference)) break block18;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block10;
                        }
                        if (!(modifyStorageAction instanceof StorageRemoveReference)) break block19;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!(modifyStorageAction instanceof StorageCreateListTable)) break block20;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block10;
                }
                if (!(modifyStorageAction instanceof StorageRemoveListTable)) break block21;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)modifyStorageAction);
    }

    private static boolean collHasIndex(MongoStorage $this, String name, String column) {
        return JavaConversions$.MODULE$.asScalaBuffer(MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, name).getIndexInfo()).find((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(DBObject x$22) {
                return x$22.containsField(this.name$1);
            }
            {
                this.name$1 = name$1;
            }
        }).nonEmpty();
    }

    public static Tuple2 net$fwbrasil$activate$storage$mongo$MongoStorage$$collectionAndWhere(MongoStorage $this, From from, Where where, List entitiesReadFromCache) {
        DBObject dBObject;
        DBObject baseWhere = $this.query(where.value());
        if (entitiesReadFromCache.nonEmpty()) {
            BasicDBObject where2 = new BasicDBObject();
            BasicDBList andConditions = new BasicDBList();
            andConditions.add(baseWhere);
            BasicDBList fromCacheIds = new BasicDBList();
            entitiesReadFromCache.foreach((Function1)new Serializable($this, fromCacheIds){
                public static final long serialVersionUID = 0L;
                private final BasicDBList fromCacheIds$1;

                public final boolean apply(List<Entity> list) {
                    return this.fromCacheIds$1.add(((Entity)list.head()).id());
                }
                {
                    this.fromCacheIds$1 = fromCacheIds$1;
                }
            });
            BasicDBObject fromCacheIdsCondition = new BasicDBObject();
            BasicDBObject fromCacheIdsNinCondition = new BasicDBObject();
            fromCacheIdsNinCondition.put("$nin", (Object)fromCacheIds);
            fromCacheIdsCondition.put("_id", (Object)fromCacheIdsNinCondition);
            andConditions.add(fromCacheIdsCondition);
            where2.put("$and", (Object)andConditions);
            dBObject = where2;
        } else {
            dBObject = baseWhere;
        }
        DBObject mongoWhere = dBObject;
        EntitySource entitySource = (EntitySource)RichList$.MODULE$.toRichList((Iterable)from.entitySources(), ManifestFactory$.MODULE$.classType(EntitySource.class)).onlyOne((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Mongo storage supports only simple queries (only one 'from' entity and without nested properties)";
            }
        });
        DBCollection mongoCollection = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, entitySource.entityClass());
        return new Tuple2((Object)mongoCollection, (Object)mongoWhere);
    }

    public static List net$fwbrasil$activate$storage$mongo$MongoStorage$$collectionAndWhere$default$3(MongoStorage $this) {
        return Nil$.MODULE$;
    }

    private static Object limitQueryIfNecessary(MongoStorage $this, Query queryInstance, DBCursor ret) {
        BoxedUnit boxedUnit;
        Query query2 = queryInstance;
        if (query2 instanceof LimitedOrderedQuery) {
            LimitedOrderedQuery limitedOrderedQuery = (LimitedOrderedQuery)query2;
            boxedUnit = ret.limit(limitedOrderedQuery.limit());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static Object orderQueryIfNecessary(MongoStorage $this, Query queryInstance, DBCursor ret) {
        BoxedUnit boxedUnit;
        Query query2 = queryInstance;
        if (query2 instanceof OrderedQuery) {
            OrderedQuery orderedQuery = (OrderedQuery)query2;
            BasicDBObject order = new BasicDBObject();
            ((OrderBy)orderedQuery.orderByClause().get()).criterias().foreach((Function1)new Serializable($this, order){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoStorage $outer;
                private final BasicDBObject order$1;

                public final Object apply(OrderByCriteria<?> criteria) {
                    String property = this.$outer.mongoStatementSelectValue(criteria.value());
                    OrderByDirection orderByDirection = criteria.direction();
                    orderByAscendingDirection$ orderByAscendingDirection$2 = orderByAscendingDirection$.MODULE$;
                    int direction = !(orderByDirection != null ? !orderByDirection.equals(orderByAscendingDirection$2) : orderByAscendingDirection$2 != null) ? 1 : -1;
                    return this.order$1.put(property, (Object)BoxesRunTime.boxToInteger((int)direction));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.order$1 = order$1;
                }
            });
            boxedUnit = ret.sort((DBObject)order);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static List transformResultToTheExpectedTypes(MongoStorage $this, List expectedTypes, Seq selectValues, DBCursor ret) {
        try {
            java.util.List rows = ret.toArray();
            return ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(rows).map((Function1)new Serializable($this, expectedTypes, selectValues){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoStorage $outer;
                public final List expectedTypes$1;
                public final Seq selectValues$1;

                public final List<StorageValue> apply(DBObject row) {
                    return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.selectValues$1.size()).map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoStorage$.anonfun.transformResultToTheExpectedTypes.1 $outer;
                        private final DBObject row$1;

                        public final StorageValue apply(int i) {
                            StatementSelectValue statementSelectValue = (StatementSelectValue)this.$outer.selectValues$1.apply(i);
                            StorageValue storageValue = statementSelectValue instanceof SimpleValue ? (StorageValue)this.$outer.expectedTypes$1.apply(i) : this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer().getValue(this.row$1, this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer().mongoStatementSelectValue(statementSelectValue), (StorageValue)this.$outer.expectedTypes$1.apply(i));
                            return storageValue;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.row$1 = row$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
                }

                public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.expectedTypes$1 = expectedTypes$1;
                    this.selectValues$1 = selectValues$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
        }
        finally {
            ret.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static BasicDBObject querySelect(MongoStorage $this, Query queryInstance, Seq selectValues) {
        void var3_3;
        BasicDBObject select = new BasicDBObject();
        selectValues.foreach((Function1)new Serializable($this, select){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoStorage $outer;
            private final BasicDBObject select$1;

            public final Object apply(StatementSelectValue<?> value) {
                return value instanceof SimpleValue ? BoxedUnit.UNIT : this.select$1.put(this.$outer.mongoStatementSelectValue(value), (Object)BoxesRunTime.boxToInteger((int)1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.select$1 = select$1;
            }
        });
        return var3_3;
    }

    private static final Option getValue$1(MongoStorage $this, Object obj$1) {
        return Option$.MODULE$.apply(obj$1);
    }

    public static void $init$(MongoStorage $this) {
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$_setter_$port_$eq(27017);
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$_setter_$authentication_$eq((Option)None$.MODULE$);
    }
}

