/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.activate.storage.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import net.fwbrasil.activate.entity.BaseEntity;
import net.fwbrasil.activate.entity.EntityHelper$;
import net.fwbrasil.activate.statement.From;
import net.fwbrasil.activate.statement.mass.MassDeleteStatement;
import net.fwbrasil.activate.statement.mass.MassModificationStatement;
import net.fwbrasil.activate.statement.mass.MassUpdateStatement;
import net.fwbrasil.activate.statement.query.LimitedOrderedQuery;
import net.fwbrasil.activate.statement.query.Query;
import net.fwbrasil.activate.storage.marshalling.ModifyStorageAction;
import net.fwbrasil.activate.storage.marshalling.StorageAddColumn;
import net.fwbrasil.activate.storage.marshalling.StorageAddIndex;
import net.fwbrasil.activate.storage.marshalling.StorageAddReference;
import net.fwbrasil.activate.storage.marshalling.StorageCreateListTable;
import net.fwbrasil.activate.storage.marshalling.StorageCreateTable;
import net.fwbrasil.activate.storage.marshalling.StorageModifyColumnType;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveColumn;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveIndex;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveListTable;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveReference;
import net.fwbrasil.activate.storage.marshalling.StorageRemoveTable;
import net.fwbrasil.activate.storage.marshalling.StorageRenameColumn;
import net.fwbrasil.activate.storage.marshalling.StorageRenameTable;
import net.fwbrasil.activate.storage.marshalling.StorageValue;
import net.fwbrasil.activate.storage.mongo.MongoStorage;
import net.fwbrasil.activate.storage.mongo.MongoStorage$;
import net.fwbrasil.activate.storage.mongo.mongoIdiom$;
import net.fwbrasil.activate.util.IdentityHashMap;
import net.fwbrasil.activate.util.Reflection;
import net.fwbrasil.activate.util.Reflection$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class MongoStorage$class {
    public static DB directAccess(MongoStorage $this) {
        return $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void delayedInit(MongoStorage $this, Function0 body2) {
        Object object;
        body2.apply$mcV$sp();
        MongoClientOptions options = MongoClientOptions.builder().connectionsPerHost($this.poolSize()).build();
        MongoClient conn = new MongoClient(JavaConversions$.MODULE$.seqAsJavaList((Seq)MongoStorage$class.addresses($this)));
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB_$eq(conn.getDB($this.db()));
        if ($this.authentication().isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)$this.authentication().get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            String user = (String)tuple22._1();
            String password = (String)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)user, (Object)password);
            String user2 = (String)tuple23._1();
            String password2 = (String)tuple23._2();
            object = BoxesRunTime.boxToBoolean((boolean)$this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().authenticate(user2, (char[])new StringOps(Predef$.MODULE$.augmentString(password2)).toArray(ClassTag$.MODULE$.Char())));
        } else {
            object = BoxedUnit.UNIT;
        }
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB();
    }

    public static boolean isMemoryStorage(MongoStorage $this) {
        return false;
    }

    public static boolean isSchemaless(MongoStorage $this) {
        return true;
    }

    public static boolean isTransactional(MongoStorage $this) {
        return false;
    }

    public static boolean supportsQueryJoin(MongoStorage $this) {
        return false;
    }

    public static Option store(MongoStorage $this, List readList, List statements, List insertList, List updateList, List deleteList) {
        MongoStorage$class.preVerifyStaleData($this, (List)((List)readList.$plus$plus((GenTraversableOnce)mongoIdiom$.MODULE$.expectedVersions(updateList), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)mongoIdiom$.MODULE$.expectedVersions(deleteList), List$.MODULE$.canBuildFrom()));
        MongoStorage$class.storeStatements($this, statements);
        MongoStorage$class.storeInserts($this, insertList);
        MongoStorage$class.storeUpdates($this, updateList);
        MongoStorage$class.storeDeletes($this, deleteList);
        return None$.MODULE$;
    }

    public static Object net$fwbrasil$activate$storage$mongo$MongoStorage$$dbValue(MongoStorage $this, Object obj) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            object = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject($this, map);
        } else if (object2 instanceof List) {
            List list = (List)object2;
            object = MongoStorage$class.dbList($this, list);
        } else {
            object = object2;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static BasicDBList dbList(MongoStorage $this, List list) {
        void var2_2;
        BasicDBList dbList2 = new BasicDBList();
        list.foreach((Function1)new Serializable($this, dbList2){
            private final /* synthetic */ MongoStorage $outer;
            private final BasicDBList dbList$1;

            public final boolean apply(Object v) {
                return this.dbList$1.add(MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbValue(this.$outer, v));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dbList$1 = dbList$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static BasicDBObject net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(MongoStorage $this, Map map) {
        void var2_2;
        BasicDBObject obj = new BasicDBObject();
        map.withFilter((Function1)new Serializable($this){

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, obj){
            private final /* synthetic */ MongoStorage $outer;
            private final BasicDBObject obj$1;

            public final Object apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.obj$1.put(key, MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbValue(this.$outer, value));
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.obj$1 = obj$1;
            }
        });
        return var2_2;
    }

    private static void preVerifyStaleData(MongoStorage $this, List data) {
        List queries = mongoIdiom$.MODULE$.findStaleDataQueries(data);
        List stale = (List)((GenericTraversableTemplate)queries.withFilter((Function1)new Serializable($this){

            public final boolean apply(Tuple3<BaseEntity, Map<String, Object>, Map<String, Object>> check$ifrefutable$2) {
                Tuple3<BaseEntity, Map<String, Object>, Map<String, Object>> tuple3 = check$ifrefutable$2;
                boolean bl = tuple3 != null;
                return bl;
            }
        }).map((Function1)new Serializable($this){
            private final /* synthetic */ MongoStorage $outer;

            public final List<Tuple2<Object, Class<BaseEntity>>> apply(Tuple3<BaseEntity, Map<String, Object>, Map<String, Object>> x$4) {
                Tuple3<BaseEntity, Map<String, Object>, Map<String, Object>> tuple3 = x$4;
                if (tuple3 != null) {
                    BaseEntity entity = (BaseEntity)tuple3._1();
                    Map query2 = (Map)tuple3._2();
                    Map select = (Map)tuple3._3();
                    List list = (List)((List)JavaConversions$.MODULE$.asScalaBuffer(MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entity).find((DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, query2), (DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, select)).toArray()).toList().map((Function1)new Serializable(this){

                        public final Object apply(DBObject x$3) {
                            return x$3.get("_id");
                        }
                    }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, entity){
                        private final BaseEntity entity$1;

                        public final Tuple2<Object, Class<BaseEntity>> apply(Object id) {
                            return new Tuple2(id, (Object)Reflection.NiceObject$.MODULE$.niceClass$extension(Reflection$.MODULE$.NiceObject((Object)this.entity$1)));
                        }
                        {
                            this.entity$1 = entity$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        if (stale.nonEmpty()) {
            throw $this.staleDataException(stale.toSet());
        }
    }

    private static void storeDeletes(MongoStorage $this, List deleteList) {
        deleteList.withFilter((Function1)new Serializable($this){

            public final boolean apply(Tuple2<BaseEntity, Map<String, StorageValue>> check$ifrefutable$3) {
                Tuple2<BaseEntity, Map<String, StorageValue>> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            private final /* synthetic */ MongoStorage $outer;

            public final void apply(Tuple2<BaseEntity, Map<String, StorageValue>> x$5) {
                Tuple2<BaseEntity, Map<String, StorageValue>> tuple2 = x$5;
                if (tuple2 != null) {
                    BaseEntity entity = (BaseEntity)tuple2._1();
                    Map properties = (Map)tuple2._2();
                    Map query2 = mongoIdiom$.MODULE$.toDelete(entity, properties);
                    WriteResult result = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entity).remove((DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, query2));
                    if (result.getN() != 1) {
                        throw this.$outer.staleDataException((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(entity.id(), (Object)Reflection.NiceObject$.MODULE$.niceClass$extension(Reflection$.MODULE$.NiceObject((Object)entity)))})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static void storeUpdates(MongoStorage $this, List updateList) {
        updateList.withFilter((Function1)new Serializable($this){

            public final boolean apply(Tuple2<BaseEntity, Map<String, StorageValue>> check$ifrefutable$4) {
                Tuple2<BaseEntity, Map<String, StorageValue>> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            private final /* synthetic */ MongoStorage $outer;

            public final void apply(Tuple2<BaseEntity, Map<String, StorageValue>> x$7) {
                Tuple2<BaseEntity, Map<String, StorageValue>> tuple2 = x$7;
                if (tuple2 != null) {
                    Map properties;
                    BaseEntity entity = (BaseEntity)tuple2._1();
                    Tuple2 tuple22 = mongoIdiom$.MODULE$.toUpdate(entity, properties = (Map)tuple2._2());
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        Map query2 = (Map)tuple22._1();
                        Map set = (Map)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)query2, (Object)set);
                        Map query3 = (Map)tuple24._1();
                        Map set2 = (Map)tuple24._2();
                        WriteResult result = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entity).update((DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, query3), (DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, set2));
                        if (result.getN() != 1) {
                            throw this.$outer.staleDataException((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(entity.id(), (Object)Reflection.NiceObject$.MODULE$.niceClass$extension(Reflection$.MODULE$.NiceObject((Object)entity)))})));
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static void storeInserts(MongoStorage $this, List insertList) {
        IdentityHashMap insertMap = mongoIdiom$.MODULE$.toInsertMap(insertList);
        insertMap.keys().foreach((Function1)new Serializable($this, insertMap){
            private final /* synthetic */ MongoStorage $outer;
            private final IdentityHashMap insertMap$1;

            public final WriteResult apply(Class<?> entityClass) {
                return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, entityClass).insert(JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableLike)this.insertMap$1.apply(entityClass)).map((Function1)new Serializable(this){
                    private final /* synthetic */ MongoStorage$.anonfun.storeInserts.1 $outer;

                    public final BasicDBObject apply(Map<String, Object> x$8) {
                        return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer.net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer(), x$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ListBuffer$.MODULE$.canBuildFrom())));
            }

            public /* synthetic */ MongoStorage net$fwbrasil$activate$storage$mongo$MongoStorage$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.insertMap$1 = insertMap$1;
            }
        });
    }

    private static void storeStatements(MongoStorage $this, List statements) {
        statements.foreach((Function1)new Serializable($this){
            private final /* synthetic */ MongoStorage $outer;

            public final WriteResult apply(MassModificationStatement statement) {
                MassModificationStatement massModificationStatement;
                block4: {
                    WriteResult writeResult;
                    block3: {
                        DBCollection coll;
                        BasicDBObject where;
                        block2: {
                            where = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, mongoIdiom$.MODULE$.toQueryWhere(statement.where()));
                            coll = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(this.$outer, statement.from());
                            massModificationStatement = statement;
                            if (!(massModificationStatement instanceof MassUpdateStatement)) break block2;
                            MassUpdateStatement massUpdateStatement = (MassUpdateStatement)massModificationStatement;
                            Map mongoUpdate = mongoIdiom$.MODULE$.toQueryUpdate(massUpdateStatement);
                            writeResult = coll.updateMulti((DBObject)where, (DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject(this.$outer, mongoUpdate));
                            break block3;
                        }
                        if (!(massModificationStatement instanceof MassDeleteStatement)) break block4;
                        writeResult = coll.remove((DBObject)where);
                    }
                    return writeResult;
                }
                throw new MatchError((Object)massModificationStatement);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, From from) {
        return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, mongoIdiom$.MODULE$.collectionClass(from));
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, BaseEntity entity) {
        return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, entity.getClass());
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, Class entityClass) {
        return MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, EntityHelper$.MODULE$.getEntityName(entityClass));
    }

    public static DBCollection net$fwbrasil$activate$storage$mongo$MongoStorage$$coll(MongoStorage $this, String entityName) {
        return $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().getCollection(entityName);
    }

    public static List query(MongoStorage $this, Query query2, List expectedTypes, List entitiesReadFromCache) {
        Tuple2 tuple2 = mongoIdiom$.MODULE$.toQuery(query2, entitiesReadFromCache);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map where = (Map)tuple2._1();
            Map select = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)where, (Object)select);
            Map where2 = (Map)tuple23._1();
            Map select2 = (Map)tuple23._2();
            DBCursor ret = MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, query2.from()).find((DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject($this, where2), (DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject($this, select2));
            Map order = mongoIdiom$.MODULE$.toQueryOrder(query2);
            Object object = order.nonEmpty() ? ret.sort((DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject($this, order)) : BoxedUnit.UNIT;
            MongoStorage$class.limitQueryIfNecessary($this, query2, ret);
            List result = JavaConversions$.MODULE$.asScalaBuffer(ret.toArray()).toList();
            return mongoIdiom$.MODULE$.transformResultToTheExpectedTypes(expectedTypes, query2.select().values(), result, (Function2)new Serializable($this){

                public final Object apply(DBObject doc, String name) {
                    return doc.get(name);
                }
            }, (Function1)new Serializable($this){

                public final List<Object> apply(Object obj) {
                    return JavaConversions$.MODULE$.asScalaBuffer((java.util.List)((BasicDBList)obj)).toList();
                }
            });
        }
        throw new MatchError((Object)tuple2);
    }

    public static void migrateStorage(MongoStorage $this, ModifyStorageAction action) {
        ModifyStorageAction modifyStorageAction;
        block22: {
            block10: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    BoxedUnit boxedUnit;
                                    block16: {
                                        BoxedUnit boxedUnit2;
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block9: {
                                                                BoxedUnit boxedUnit3;
                                                                modifyStorageAction = action;
                                                                if (!(modifyStorageAction instanceof StorageCreateTable)) break block9;
                                                                StorageCreateTable storageCreateTable = (StorageCreateTable)modifyStorageAction;
                                                                if (storageCreateTable.ifNotExists() && $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().collectionExists(storageCreateTable.tableName())) {
                                                                    boxedUnit3 = BoxedUnit.UNIT;
                                                                } else {
                                                                    $this.net$fwbrasil$activate$storage$mongo$MongoStorage$$mongoDB().createCollection(storageCreateTable.tableName(), (DBObject)new BasicDBObject());
                                                                    boxedUnit3 = BoxedUnit.UNIT;
                                                                }
                                                                BoxedUnit boxedUnit4 = boxedUnit3;
                                                                break block10;
                                                            }
                                                            if (!(modifyStorageAction instanceof StorageRenameTable)) break block11;
                                                            StorageRenameTable storageRenameTable = (StorageRenameTable)modifyStorageAction;
                                                            MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRenameTable.oldName()).rename(storageRenameTable.newName());
                                                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                                            break block10;
                                                        }
                                                        if (!(modifyStorageAction instanceof StorageRemoveTable)) break block12;
                                                        StorageRemoveTable storageRemoveTable = (StorageRemoveTable)modifyStorageAction;
                                                        MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRemoveTable.name()).drop();
                                                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                                        break block10;
                                                    }
                                                    if (!(modifyStorageAction instanceof StorageAddColumn)) break block13;
                                                    BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                                                    break block10;
                                                }
                                                if (!(modifyStorageAction instanceof StorageRenameColumn)) break block14;
                                                StorageRenameColumn storageRenameColumn = (StorageRenameColumn)modifyStorageAction;
                                                Map update = mongoIdiom$.MODULE$.renameColumn(storageRenameColumn.oldName(), storageRenameColumn.column().name());
                                                MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRenameColumn.tableName()).update((DBObject)new BasicDBObject(), (DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject($this, update));
                                                BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                                break block10;
                                            }
                                            if (!(modifyStorageAction instanceof StorageRemoveColumn)) break block15;
                                            StorageRemoveColumn storageRemoveColumn = (StorageRemoveColumn)modifyStorageAction;
                                            Map update = mongoIdiom$.MODULE$.removeColumn(storageRemoveColumn.name());
                                            MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRemoveColumn.tableName()).update((DBObject)new BasicDBObject(), (DBObject)MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$dbObject($this, update));
                                            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                                            break block10;
                                        }
                                        if (!(modifyStorageAction instanceof StorageAddIndex)) break block16;
                                        StorageAddIndex storageAddIndex = (StorageAddIndex)modifyStorageAction;
                                        BasicDBObject obj = new BasicDBObject();
                                        storageAddIndex.columns().foreach((Function1)new Serializable($this, obj){
                                            private final BasicDBObject obj$2;

                                            public final Object apply(String x$10) {
                                                return this.obj$2.put(x$10, (Object)BoxesRunTime.boxToInteger((int)1));
                                            }
                                            {
                                                this.obj$2 = obj$2;
                                            }
                                        });
                                        BasicDBObject options = new BasicDBObject();
                                        options.put("name", (Object)storageAddIndex.indexName());
                                        Object object = storageAddIndex.unique() ? options.put("unique", (Object)BoxesRunTime.boxToBoolean((boolean)true)) : BoxedUnit.UNIT;
                                        if (storageAddIndex.ifNotExists() && MongoStorage$class.collHasIndex($this, storageAddIndex.tableName(), storageAddIndex.indexName())) {
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else {
                                            MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageAddIndex.tableName()).ensureIndex((DBObject)obj, (DBObject)options);
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit10 = boxedUnit2;
                                        break block10;
                                    }
                                    if (!(modifyStorageAction instanceof StorageRemoveIndex)) break block17;
                                    StorageRemoveIndex storageRemoveIndex = (StorageRemoveIndex)modifyStorageAction;
                                    if (storageRemoveIndex.ifExists() && !MongoStorage$class.collHasIndex($this, storageRemoveIndex.tableName(), storageRemoveIndex.name())) {
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, storageRemoveIndex.tableName()).dropIndex(storageRemoveIndex.name());
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit11 = boxedUnit;
                                    break block10;
                                }
                                if (!(modifyStorageAction instanceof StorageModifyColumnType)) break block18;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block10;
                            }
                            if (!(modifyStorageAction instanceof StorageAddReference)) break block19;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block10;
                        }
                        if (!(modifyStorageAction instanceof StorageRemoveReference)) break block20;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!(modifyStorageAction instanceof StorageCreateListTable)) break block21;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block10;
                }
                if (!(modifyStorageAction instanceof StorageRemoveListTable)) break block22;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)modifyStorageAction);
    }

    private static boolean collHasIndex(MongoStorage $this, String name, String indexName) {
        return JavaConversions$.MODULE$.asScalaBuffer(MongoStorage$class.net$fwbrasil$activate$storage$mongo$MongoStorage$$coll($this, name).getIndexInfo()).find((Function1)new Serializable($this, indexName){
            private final String indexName$1;

            public final boolean apply(DBObject x$11) {
                Object object = x$11.get("name");
                String string = this.indexName$1;
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                this.indexName$1 = indexName$1;
            }
        }).isDefined();
    }

    private static Object limitQueryIfNecessary(MongoStorage $this, Query query2, DBCursor ret) {
        BoxedUnit boxedUnit;
        Query query3 = query2;
        if (query3 instanceof LimitedOrderedQuery) {
            LimitedOrderedQuery limitedOrderedQuery = (LimitedOrderedQuery)query3;
            ret.limit(limitedOrderedQuery.limit());
            boxedUnit = limitedOrderedQuery.offsetOption().map((Function1)new Serializable($this, ret){
                private final DBCursor ret$1;

                public final DBCursor apply(int x$1) {
                    return this.ret$1.skip(x$1);
                }
                {
                    this.ret$1 = ret$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static List addresses(MongoStorage $this) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])$this.host().split(",")).toList().map((Function1)new Serializable($this){
            private final /* synthetic */ MongoStorage $outer;

            public final ServerAddress apply(String x$12) {
                block4: {
                    ServerAddress serverAddress;
                    block3: {
                        .colon.colon colon2;
                        boolean bl;
                        block2: {
                            bl = false;
                            colon2 = null;
                            List list = Predef$.MODULE$.refArrayOps((Object[])x$12.split(":")).toList();
                            if (!(list instanceof .colon.colon)) break block2;
                            bl = true;
                            colon2 = (.colon.colon)list;
                            String host = (String)colon2.head();
                            List list2 = colon2.tl$1();
                            if (!(list2 instanceof .colon.colon)) break block2;
                            .colon.colon colon3 = (.colon.colon)list2;
                            String port = (String)colon3.head();
                            List list3 = colon3.tl$1();
                            if (!Nil$.MODULE$.equals(list3)) break block2;
                            serverAddress = new ServerAddress(host, new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
                            break block3;
                        }
                        if (!bl) break block4;
                        String host = (String)colon2.head();
                        List list = colon2.tl$1();
                        if (!Nil$.MODULE$.equals(list)) break block4;
                        serverAddress = new ServerAddress(host, this.$outer.port());
                    }
                    return serverAddress;
                }
                throw new IllegalStateException();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public static void $init$(MongoStorage $this) {
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$_setter_$port_$eq(27017);
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$_setter_$authentication_$eq((Option)None$.MODULE$);
        $this.net$fwbrasil$activate$storage$mongo$MongoStorage$_setter_$poolSize_$eq(20);
    }
}

