/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.radon.transaction;

import net.fwbrasil.radon.ConcurrentTransactionException;
import net.fwbrasil.radon.RequiredTransactionException;
import net.fwbrasil.radon.RetryLimitTransactionException;
import net.fwbrasil.radon.transaction.Transaction;
import net.fwbrasil.radon.transaction.TransactionContext;
import net.fwbrasil.radon.transaction.TransactionalExecutionContext;
import net.fwbrasil.radon.util.ExclusiveThreadLocal;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001-\u0011!\u0003\u0016:b]N\f7\r^5p]6\u000bg.Y4fe*\u00111\u0001B\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u0006\r\u0005)!/\u00193p]*\u0011q\u0001C\u0001\tM^\u0014'/Y:jY*\t\u0011\"A\u0002oKR\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0006\u0004%\u0019\u0001F\u0001\bG>tG/\u001a=u+\u0005)\u0002C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005I!&/\u00198tC\u000e$\u0018n\u001c8D_:$X\r\u001f;\t\u0011i\u0001!\u0011!Q\u0001\nU\t\u0001bY8oi\u0016DH\u000f\t\u0005\u00069\u0001!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y!\"a\b\u0011\u0011\u0005Y\u0001\u0001\"B\n\u001c\u0001\b)\u0002B\u0002\u0012\u0001A\u0003%1%\u0001\u000fbGRLg/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0006N]3bI2{7-\u00197\u0011\u0007\u0011:\u0013&D\u0001&\u0015\t1C!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005Q)\u0005p\u00197vg&4X\r\u00165sK\u0006$Gj\\2bYB\u0011aCK\u0005\u0003W\t\u00111\u0002\u0016:b]N\f7\r^5p]\"1Q\u0006\u0001C\u0001\t9\n\u0001\"[:BGRLg/\u001a\u000b\u0003_I\u0002\"!\u0004\u0019\n\u0005Er!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u00071\u0002\ra\r\t\u0004\u001bQJ\u0013BA\u001b\u000f\u0005\u0019y\u0005\u000f^5p]\"1q\u0007\u0001C\u0001\ta\n\u0001\"Y2uSZ\fG/\u001a\u000b\u0003sq\u0002\"!\u0004\u001e\n\u0005mr!\u0001B+oSRDQa\u0001\u001cA\u0002MBaA\u0010\u0001\u0005\u0002\u0011y\u0014A\u00033fC\u000e$\u0018N^1uKR\u0011\u0011\b\u0011\u0005\u0006\u0007u\u0002\ra\r\u0005\u0007\u0005\u0002!\tAB\"\u00029\u001d,GOU3rk&\u0014X\rZ!di&4X\r\u0016:b]N\f7\r^5p]V\t\u0011\u0006\u0003\u0004F\u0001\u0011\u0005aAR\u0001\u0015O\u0016$\u0018i\u0019;jm\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0016\u0003MBa\u0001\u0013\u0001\u0005\u0002\u0011I\u0015\u0001\u0005:v]&sGK]1og\u0006\u001cG/[8o+\tQe\n\u0006\u0002L9R\u0011Aj\u0016\t\u0003\u001b:c\u0001\u0001B\u0003P\u000f\n\u0007\u0001KA\u0001B#\t\tF\u000b\u0005\u0002\u000e%&\u00111K\u0004\u0002\b\u001d>$\b.\u001b8h!\tiQ+\u0003\u0002W\u001d\t\u0019\u0011I\\=\t\ra;E\u00111\u0001Z\u0003\u00051\u0007cA\u0007[\u0019&\u00111L\u0004\u0002\ty\tLh.Y7f}!)1a\u0012a\u0001S!1a\f\u0001C\u0001\t}\u000bAD];o\u0013:tUm\u001e+sC:\u001c\u0018m\u0019;j_:<\u0016\u000e\u001e5SKR\u0014\u00180\u0006\u0002aER\u0011\u0011m\u0019\t\u0003\u001b\n$QaT/C\u0002ACa\u0001W/\u0005\u0002\u0004!\u0007cA\u0007[C\"1a\r\u0001C\u0003\t\u001d\f\u0011D];o\u0013:$&/\u00198tC\u000e$\u0018n\u001c8XSRD'+\u001a;ssV\u0011\u0001N\u001b\u000b\u0005S.dg\u000e\u0005\u0002NU\u0012)q*\u001ab\u0001!\")1!\u001aa\u0001S!1\u0001,\u001aCA\u00025\u00042!\u0004.j\u0011\u001dyW\r%AA\u0002A\f!B]3uef\u001cu.\u001e8u!\ti\u0011/\u0003\u0002s\u001d\t\u0019\u0011J\u001c;)\u0005\u0015$\bCA;y\u001b\u00051(BA<\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0003sZ\u0014q\u0001^1jYJ,7\r\u0003\u0004|\u0001\u0011\u0005A\u0001`\u0001\u001feVt\u0017J\u001c+sC:\u001c\u0018m\u0019;j_:<\u0016\u000e\u001e5SKR\u0014\u00180Q:z]\u000e,2!`A\u0006)\u001dq\u0018QBA\n\u0003;\u0001Ra`A\u0003\u0003\u0013i!!!\u0001\u000b\u0007\u0005\ra\"\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0002\u0002\u0002\t1a)\u001e;ve\u0016\u00042!TA\u0006\t\u0015y%P1\u0001Q\u0011!\tyA\u001fCA\u0002\u0005E\u0011A\u00024viV\u0014X\rE\u0002\u000e5zDq!!\u0006{\u0001\u0004\t9\"A\u0002dib\u00042AFA\r\u0013\r\tYB\u0001\u0002\u001e)J\fgn]1di&|g.\u00197Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9qN\u001fI\u0001\u0002\u0004\u0001\bbBA\u0011\u0001\u0011E\u00111E\u0001\fo\u0006LG\u000fV8SKR\u0014\u0018\u0010F\u0002:\u0003KA\u0001\"a\n\u0002 \u0001\u0007\u0011\u0011F\u0001\u0002KB!\u00111FA\u0017\u001b\u0005!\u0011bAA\u0018\t\tq2i\u001c8dkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>tW\t_2faRLwN\u001c\u0005\n\u0003g\u0001\u0011\u0013!C\u0003\u0003k\t1E];o\u0013:$&/\u00198tC\u000e$\u0018n\u001c8XSRD'+\u001a;ss\u0012\"WMZ1vYR$3'\u0006\u0003\u00028\u0005%SCAA\u001dU\r\u0001\u00181H\u0016\u0003\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u00072\u0018!C;oG\",7m[3e\u0013\u0011\t9%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004P\u0003c\u0011\r\u0001\u0015\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0001\u0003\u001f\n\u0001F];o\u0013:$&/\u00198tC\u000e$\u0018n\u001c8XSRD'+\u001a;ss\u0006\u001b\u0018P\\2%I\u00164\u0017-\u001e7uIM*B!a\u000e\u0002R\u00111q*a\u0013C\u0002A\u0003")
public class TransactionManager {
    private final TransactionContext context;
    private final ExclusiveThreadLocal<Transaction> activeTransactionThreadLocal;

    public TransactionContext context() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(Option<Transaction> transaction) {
        if (!this.getActiveTransaction().isDefined()) return false;
        Option<Transaction> option = this.getActiveTransaction();
        Option<Transaction> option2 = transaction;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public void activate(Option<Transaction> transaction) {
        Option<Transaction> active = this.getActiveTransaction();
        if (this.getActiveTransaction().isDefined() || transaction.isEmpty()) {
            Option<Transaction> option = this.getActiveTransaction();
            Option<Transaction> option2 = transaction;
            if (option == null ? option2 != null : !option.equals(option2)) {
                throw new IllegalStateException("Another transaction is active.");
            }
        }
        this.activeTransactionThreadLocal.set(transaction);
    }

    public void deactivate(Option<Transaction> transaction) {
        Option<Transaction> active;
        Option<Transaction> option = active = this.getActiveTransaction();
        Option<Transaction> option2 = transaction;
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            this.activeTransactionThreadLocal.clean(transaction);
            return;
        }
        throw new IllegalStateException("Transaction is not active.");
    }

    public Transaction getRequiredActiveTransaction() {
        Option<Transaction> active = this.getActiveTransaction();
        if (active.isDefined()) {
            return (Transaction)active.get();
        }
        throw new RequiredTransactionException();
    }

    public Option<Transaction> getActiveTransaction() {
        return this.activeTransactionThreadLocal.get();
    }

    public <A> A runInTransaction(Transaction transaction, Function0<A> f) {
        Object object;
        Some someTransaction = new Some((Object)transaction);
        this.activate((Option<Transaction>)someTransaction);
        try {
            object = f.apply();
            this.deactivate((Option<Transaction>)someTransaction);
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.deactivate((Option<Transaction>)someTransaction);
                throw throwable2;
            }
        }
        return (A)object;
    }

    public <A> A runInNewTransactionWithRetry(Function0<A> f) {
        return this.runInTransactionWithRetry(new Transaction(this.context()), f, this.runInTransactionWithRetry$default$3());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <A> A runInTransactionWithRetry(Transaction transaction, Function0<A> f, int retryCount) {
        while (retryCount < this.context().retryLimit()) {
            try {
                A result = this.runInTransaction(transaction, f);
                transaction.commit();
                return result;
            }
            catch (ConcurrentTransactionException concurrentTransactionException) {
                transaction.rollback();
                this.waitToRetry(concurrentTransactionException);
                ++retryCount;
            }
        }
        throw new RetryLimitTransactionException();
        {
            catch (Throwable throwable) {
                transaction.rollback();
                throw throwable;
            }
        }
    }

    public final <A> int runInTransactionWithRetry$default$3() {
        return 0;
    }

    public <A> Future<A> runInTransactionWithRetryAsync(Function0<Future<A>> future, TransactionalExecutionContext ctx, int retryCount) {
        ExecutionContextExecutor ectx = ctx.ctx().ectx();
        return ((Future)future.apply()).flatMap((Function1)new Serializable(this, ctx, ectx){
            public static final long serialVersionUID = 0L;
            private final TransactionalExecutionContext ctx$1;
            private final ExecutionContextExecutor ectx$1;

            public final Future<A> apply(A result) {
                return this.ctx$1.transaction().asyncCommit((ExecutionContext)this.ectx$1).map((Function1)new Serializable(this, result){
                    public static final long serialVersionUID = 0L;
                    private final Object result$1;

                    public final A apply(BoxedUnit x$1) {
                        return (A)this.result$1;
                    }
                    {
                        this.result$1 = result$1;
                    }
                }, (ExecutionContext)this.ectx$1);
            }
            {
                this.ctx$1 = ctx$1;
                this.ectx$1 = ectx$1;
            }
        }, (ExecutionContext)ectx).recoverWith((PartialFunction)new Serializable(this, future, ctx, retryCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionManager $outer;
            private final Function0 future$1;
            private final TransactionalExecutionContext ctx$1;
            private final int retryCount$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<A> future;
                A1 A1 = x1;
                if (A1 instanceof ConcurrentTransactionException) {
                    ConcurrentTransactionException concurrentTransactionException = (ConcurrentTransactionException)A1;
                    if (this.retryCount$1 >= this.$outer.context().retryLimit()) {
                        throw new RetryLimitTransactionException();
                    }
                    this.$outer.waitToRetry(concurrentTransactionException);
                    future = this.$outer.runInTransactionWithRetryAsync(this.future$1, this.ctx$1, this.retryCount$1 + 1);
                } else {
                    future = function1.apply(x1);
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof ConcurrentTransactionException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.future$1 = future$1;
                this.ctx$1 = ctx$1;
                this.retryCount$1 = retryCount$1;
            }
        }, (ExecutionContext)ectx);
    }

    public <A> int runInTransactionWithRetryAsync$default$3() {
        return 0;
    }

    public void waitToRetry(ConcurrentTransactionException e) {
        if (this.context().milisToWaitBeforeRetry() > 0) {
            Thread.sleep(this.context().milisToWaitBeforeRetry());
        }
    }

    public TransactionManager(TransactionContext context) {
        this.context = context;
        this.activeTransactionThreadLocal = new ExclusiveThreadLocal();
    }
}

