/*
 * Decompiled with CFR 0.152.
 */
package net.fwbrasil.radon.transaction;

import net.fwbrasil.radon.ref.Ref;
import net.fwbrasil.radon.ref.RefContent;
import net.fwbrasil.radon.transaction.RefSnapshooter;
import net.fwbrasil.radon.transaction.RefSnapshot;
import net.fwbrasil.radon.transaction.TransactionContext;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0002\u0002-\u0011A\u0003\u0016:b]N\f7\r^5p]Z\u000bG.\u001b3bi>\u0014(BA\u0002\u0005\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011!\u0002:bI>t'BA\u0004\t\u0003!1wO\u0019:bg&d'\"A\u0005\u0002\u00079,Go\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u00059\u0011VMZ*oCB\u001c\bn\\8uKJDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u00055\u0001\u0001\"B\u000b\u0001\t#1\u0012\u0001F5t\u0003:|U\u000f\u001e3bi\u0016$7K\\1qg\"|G\u000fF\u0002\u0018;\u001d\u0002\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011qAQ8pY\u0016\fg\u000eC\u0003\u001f)\u0001\u0007q$A\u0002sK\u001a\u00042\u0001\t\u0012%\u001b\u0005\t#B\u0001\u0010\u0005\u0013\t\u0019\u0013EA\u0002SK\u001a\u0004\"\u0001G\u0013\n\u0005\u0019J\"aA!os\")\u0001\u0006\u0006a\u0001S\u0005A1O\\1qg\"|G\u000f\u0005\u0002\u000eU%\u00111F\u0001\u0002\f%\u001647K\\1qg\"|G\u000fC\u0003.\u0001\u0011Ea&A\u0007wC2LG-\u0019;f/JLG/\u001a\u000b\u0003_I\u0002\"\u0001\u0007\u0019\n\u0005EJ\"\u0001B+oSRDQA\b\u0017A\u0002}AQ\u0001\u000e\u0001\u0005\u0012U\nAB^1mS\u0012\fG/\u001a*fC\u0012$\"a\f\u001c\t\u000by\u0019\u0004\u0019A\u0010\t\u000ba\u0002A\u0011C\u001d\u0002#Y\fG.\u001b3bi\u0016$Um\u001d;s_f,G\r\u0006\u00020u!)ad\u000ea\u0001?!)A\b\u0001C\t{\u0005ya/\u00197jI\u0006$XmQ8oi\u0016DH\u000f\u0006\u00020}!)ad\u000fa\u0001?!)\u0001\t\u0001C\t\u0003\u0006ib/\u00197jI\u0006$XmQ8oGV\u0014(/\u001a8u%\u001647I]3bi&|g\u000e\u0006\u00020\u0005\")ad\u0010a\u0001?!1A\t\u0001Q\u0005\n\u0015\u000b1%[:SK\u001a\u0014V-\u00193BMR,'\u000f\u00165f'R\f'\u000f^(g)J\fgn]1di&|g\u000e\u0006\u0002\u0018\r\")ad\u0011a\u0001?!1\u0001\n\u0001Q\u0005\n%\u000b\u0011%[:SK\u001a\u001c%/Z1uS:<\u0017J\\!o_RDWM\u001d+sC:\u001c\u0018m\u0019;j_:$\"a\u0006&\t\u000by9\u0005\u0019A\u0010\t\r1\u0003\u0001\u0015\"\u0003N\u0003\u0011J7OU3g/J|G/Z!gi\u0016\u0014H\u000b[3Ti\u0006\u0014Ho\u00144Ue\u0006t7/Y2uS>tGCA\fO\u0011\u0015q2\n1\u0001 \u0011\u0015\u0001\u0006\u0001\"\u0005R\u0003-\u0011X\r\u001e:z\u0013\u001a$&/^3\u0015\u0007=\u0012F\u000bC\u0003T\u001f\u0002\u0007q#A\u0005d_:$\u0017\u000e^5p]\"1Qk\u0014CA\u0002Y\u000bAA]3ggB\u0019\u0001dV-\n\u0005aK\"\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007i\u0013WM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011aLC\u0001\u0007yI|w\u000e\u001e \n\u0003iI!!Y\r\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002b3A\u0012a-\u001b\t\u0004A\t:\u0007C\u00015j\u0019\u0001!\u0011B\u001b+\u0002\u0002\u0003\u0005)\u0011A6\u0003\u0007}#\u0013'\u0005\u0002mIA\u0011\u0001$\\\u0005\u0003]f\u0011qAT8uQ&tw\r")
public abstract class TransactionValidator
extends RefSnapshooter {
    public boolean isAnOutdatedSnapshot(Ref<Object> ref, RefSnapshot snapshot) {
        RefContent<Object> originalContent = snapshot.originalContent();
        return originalContent.writeTimestamp() != ref.refContent().writeTimestamp() && originalContent.readTimestamp() != ref.refContent().readTimestamp();
    }

    public void validateWrite(Ref<Object> ref) {
        this.retryIfTrue(this.isRefReadAfterTheStartOfTransaction(ref) || this.isRefWroteAfterTheStartOfTransaction(ref), (Function0<List<Ref<?>>>)new Serializable(this, ref){
            public static final long serialVersionUID = 0L;
            private final Ref ref$3;

            public final List<Ref<Object>> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Ref[]{this.ref$3}));
            }
            {
                this.ref$3 = ref$3;
            }
        });
    }

    public void validateRead(Ref<Object> ref) {
        this.retryIfTrue(this.isRefWroteAfterTheStartOfTransaction(ref) || this.isAnOutdatedSnapshot(ref, this.getSnapshot(ref)), (Function0<List<Ref<?>>>)new Serializable(this, ref){
            public static final long serialVersionUID = 0L;
            private final Ref ref$2;

            public final List<Ref<Object>> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Ref[]{this.ref$2}));
            }
            {
                this.ref$2 = ref$2;
            }
        });
    }

    public void validateDestroyed(Ref<Object> ref) {
        if (ref.refContent().destroyedFlag()) {
            if (this.getSnapshot(ref).isReadDestroyedFlag()) {
                this.context().retry((Seq<Ref<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Ref[]{ref}));
            } else {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A destroyed ref was used: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ref})));
            }
        }
    }

    public void validateContext(Ref<Object> ref) {
        TransactionContext transactionContext = ref.context();
        TransactionContext transactionContext2 = this.context();
        if (!(transactionContext != null ? !transactionContext.equals(transactionContext2) : transactionContext2 != null)) {
            return;
        }
        throw new IllegalStateException("Ref is from another context!");
    }

    public void validateConcurrentRefCreation(Ref<Object> ref) {
        this.retryIfTrue(this.isRefCreatingInAnotherTransaction(ref), (Function0<List<Ref<?>>>)new Serializable(this, ref){
            public static final long serialVersionUID = 0L;
            private final Ref ref$1;

            public final List<Ref<Object>> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Ref[]{this.ref$1}));
            }
            {
                this.ref$1 = ref$1;
            }
        });
    }

    private boolean isRefReadAfterTheStartOfTransaction(Ref<Object> ref) {
        return ref.refContent().readTimestamp() > this.startTimestamp();
    }

    private boolean isRefCreatingInAnotherTransaction(Ref<Object> ref) {
        return ref.isCreating() && ref.creationTransactionId() != this.transactionId();
    }

    private boolean isRefWroteAfterTheStartOfTransaction(Ref<Object> ref) {
        return ref.refContent().writeTimestamp() > this.startTimestamp();
    }

    public void retryIfTrue(boolean condition, Function0<List<Ref<?>>> refs) {
        if (condition) {
            this.context().retry((List)refs.apply());
        }
    }
}

