/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.dlcrypto.ecdsa;

import java.math.BigInteger;
import net.glorat.dlcrypto.ecdsa.ECDSASignature;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ECDSASignature$
implements Product,
Serializable {
    public static final ECDSASignature$ MODULE$;
    private final X9ECParameters params;
    private final ECDomainParameters CURVE;
    private final BigInteger HALF_CURVE_ORDER;

    static {
        new ECDSASignature$();
    }

    public X9ECParameters params() {
        return this.params;
    }

    public ECDomainParameters CURVE() {
        return this.CURVE;
    }

    public BigInteger HALF_CURVE_ORDER() {
        return this.HALF_CURVE_ORDER;
    }

    public ECDSASignature decodeFromDER(byte[] bytes) {
        ECDSASignature eCDSASignature;
        try {
            ASN1InputStream decoder = new ASN1InputStream(bytes);
            DLSequence seq = (DLSequence)decoder.readObject();
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            decoder.close();
            eCDSASignature = new ECDSASignature(r.getPositiveValue(), s.getPositiveValue());
        }
        catch (Exception exception) {
            eCDSASignature = new ECDSASignature(BigInteger.ZERO, BigInteger.ZERO);
        }
        return eCDSASignature;
    }

    public ECDSASignature apply(BigInteger r, BigInteger s) {
        return new ECDSASignature(r, s);
    }

    public Option<Tuple2<BigInteger, BigInteger>> unapply(ECDSASignature x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.r(), (Object)x$0.s()));
    }

    public String productPrefix() {
        return "ECDSASignature";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ECDSASignature$;
    }

    public int hashCode() {
        return 1551720164;
    }

    public String toString() {
        return "ECDSASignature";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ECDSASignature$() {
        MODULE$ = this;
        Product.class.$init$((Product)this);
        this.params = SECNamedCurves.getByName((String)"secp256k1");
        this.CURVE = new ECDomainParameters(this.params().getCurve(), this.params().getG(), this.params().getN(), this.params().getH());
        this.HALF_CURVE_ORDER = this.params().getN().shiftRight(1);
    }
}

