/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.dlcrypto.ecdsa;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.glorat.dlcrypto.core.Hash;
import net.glorat.dlcrypto.core.PrivateKeyExtProvider;
import net.glorat.dlcrypto.core.PublicKeyExtProvider;
import net.glorat.dlcrypto.core.Signer;
import net.glorat.dlcrypto.ecdsa.ECDSASignerDemo;
import scala.Predef$;
import scala.collection.Seq;

public final class ECDSASignerDemo$
implements Signer {
    public static ECDSASignerDemo$ MODULE$;
    private final String providerName;
    private final String algorithmName;
    private final SecureRandom secureRandom;
    private final KeyFactory keyFactory;

    static {
        new ECDSASignerDemo$();
    }

    public PrivateKey createSigningKeyFromHex(String key) {
        return Signer.createSigningKeyFromHex$((Signer)this, (String)key);
    }

    public PublicKey createVerificationKeyFromHex(String key) {
        return Signer.createVerificationKeyFromHex$((Signer)this, (String)key);
    }

    public net.glorat.dlcrypto.core.Signature sign(Hash data, PrivateKey key) {
        return Signer.sign$((Signer)this, (Hash)data, (PrivateKey)key);
    }

    public net.glorat.dlcrypto.core.Signature sign(Hash data, byte[] keyBytes) {
        return Signer.sign$((Signer)this, (Hash)data, (byte[])keyBytes);
    }

    public byte[] signToBytes(Hash data, byte[] keyBytes) {
        return Signer.signToBytes$((Signer)this, (Hash)data, (byte[])keyBytes);
    }

    public boolean verify(Hash data, Seq<Object> sig, Seq<Object> identity) {
        return Signer.verify$((Signer)this, (Hash)data, sig, identity);
    }

    public boolean verify(Hash data, net.glorat.dlcrypto.core.Signature sig, PublicKey identity) {
        return Signer.verify$((Signer)this, (Hash)data, (net.glorat.dlcrypto.core.Signature)sig, (PublicKey)identity);
    }

    public String providerName() {
        return this.providerName;
    }

    public String algorithmName() {
        return this.algorithmName;
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    private KeyFactory keyFactory() {
        return this.keyFactory;
    }

    /*
     * WARNING - void declaration
     */
    public PrivateKey createSigningKey(byte[] data) {
        void var3_3;
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(data);
        PrivateKey key = this.keyFactory().generatePrivate(ks);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public PublicKey createVerificationKey(byte[] d) {
        void var3_3;
        X509EncodedKeySpec ks = new X509EncodedKeySpec(d);
        PublicKey key = this.keyFactory().generatePublic(ks);
        return var3_3;
    }

    public ECDSASignerDemo.ByteSignature createSignature(byte[] data) {
        return new ECDSASignerDemo.ByteSignature(data);
    }

    public boolean verify(byte[] data, ECDSASignerDemo.ByteSignature sig, PublicKey identity) {
        Signature s = Signature.getInstance(this.algorithmName(), this.providerName());
        s.initVerify(identity);
        s.update(data);
        return s.verify(sig.bytes());
    }

    public ECDSASignerDemo.ByteSignature sign(byte[] data, PrivateKey key) {
        Signature s = Signature.getInstance(this.algorithmName(), this.providerName());
        s.initSign(key);
        s.update(data);
        byte[] sig = s.sign();
        return new ECDSASignerDemo.ByteSignature(sig);
    }

    public KeyPair generate() {
        return this.generate(this.secureRandom());
    }

    public KeyPair generate(SecureRandom rng) {
        ECGenParameterSpec ecGenSpec = new ECGenParameterSpec("secp256k1");
        KeyPairGenerator g = KeyPairGenerator.getInstance(this.algorithmName(), this.providerName());
        g.initialize(ecGenSpec, rng);
        KeyPair pair = g.generateKeyPair();
        return pair;
    }

    public boolean verify(byte[] message, net.glorat.dlcrypto.core.Signature sig, PublicKey identity) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean handlesPublicKey(PublicKey key) {
        return true;
    }

    public boolean handlesPrivateKey(PrivateKey key) {
        return true;
    }

    public PrivateKeyExtProvider privateKeyExtProvider(PrivateKey key) {
        return new ECDSASignerDemo.MyKey(key);
    }

    public PublicKeyExtProvider publicKeyExtProvider(PublicKey key) {
        return new ECDSASignerDemo.MyPublicKey(key);
    }

    public PublicKey inferPublicKey(PrivateKey priv) {
        throw new IllegalArgumentException("This signer cannot infer public keys");
    }

    private ECDSASignerDemo$() {
        MODULE$ = this;
        Signer.$init$((Signer)this);
        this.providerName = "BC";
        this.algorithmName = "ECDSA";
        this.secureRandom = new SecureRandom();
        this.keyFactory = KeyFactory.getInstance(this.algorithmName(), this.providerName());
    }
}

