/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import net.glorat.cqrs.Command;
import net.glorat.cqrs.CommandHandler;
import net.glorat.cqrs.Repository;
import net.glorat.cqrs.example.CheckInItemsToInventory;
import net.glorat.cqrs.example.CreateInventoryItem;
import net.glorat.cqrs.example.DeactivateInventoryItem;
import net.glorat.cqrs.example.InventoryItem;
import net.glorat.cqrs.example.RemoveItemsFromInventory;
import net.glorat.cqrs.example.RenameInventoryItem;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0017\tA\u0012J\u001c<f]R|'/_\"p[6\fg\u000e\u001a%b]\u0012dWM]:\u000b\u0005\r!\u0011aB3yC6\u0004H.\u001a\u0006\u0003\u000b\u0019\tAaY9sg*\u0011q\u0001C\u0001\u0007O2|'/\u0019;\u000b\u0003%\t1A\\3u\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\u000f\u0007>lW.\u00198e\u0011\u0006tG\r\\3s\u0011!9\u0002A!A!\u0002\u0013A\u0012A\u0003:fa>\u001c\u0018\u000e^8ssB\u00111#G\u0005\u00035\u0011\u0011!BU3q_NLGo\u001c:z\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\u0011a\u0004\t\t\u0003?\u0001i\u0011A\u0001\u0005\u0006/m\u0001\r\u0001\u0007\u0005\u0006E\u0001!\taI\u0001\be\u0016\u001cW-\u001b<f+\u0005!\u0003\u0003B\u0007&O)J!A\n\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"a\u0005\u0015\n\u0005%\"!aB\"p[6\fg\u000e\u001a\t\u0004W9\u0002T\"\u0001\u0017\u000b\u00055r\u0011AC2p]\u000e,(O]3oi&\u0011q\u0006\f\u0002\u0007\rV$XO]3\u0011\u00055\t\u0014B\u0001\u001a\u000f\u0005\u0011)f.\u001b;\t\u000bQ\u0002A\u0011A\u001b\u0002\r!\fg\u000e\u001a7f)\tQc\u0007C\u00038g\u0001\u0007\u0001(A\u0001d!\ty\u0012(\u0003\u0002;\u0005\t\u00192I]3bi\u0016LeN^3oi>\u0014\u00180\u0013;f[\")A\u0007\u0001C\u0001yQ\u0011!&\u0010\u0005\u0006om\u0002\rA\u0010\t\u0003?}J!\u0001\u0011\u0002\u0003/\u0011+\u0017m\u0019;jm\u0006$X-\u00138wK:$xN]=Ji\u0016l\u0007\"\u0002\u001b\u0001\t\u0003\u0011EC\u0001\u0016D\u0011\u00159\u0014\t1\u0001E!\tyR)\u0003\u0002G\u0005\tA\"+Z7pm\u0016LE/Z7t\rJ|W.\u00138wK:$xN]=\t\u000bQ\u0002A\u0011\u0001%\u0015\u0005)J\u0005\"B\u001cH\u0001\u0004Q\u0005CA\u0010L\u0013\ta%AA\fDQ\u0016\u001c7.\u00138Ji\u0016l7\u000fV8J]Z,g\u000e^8ss\")A\u0007\u0001C\u0001\u001dR\u0011!f\u0014\u0005\u0006o5\u0003\r\u0001\u0015\t\u0003?EK!A\u0015\u0002\u0003'I+g.Y7f\u0013:4XM\u001c;pefLE/Z7")
public class InventoryCommandHandlers
implements CommandHandler {
    private final Repository repository;

    @Override
    public PartialFunction<Command, Future<BoxedUnit>> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InventoryCommandHandlers $outer;

            public final <A1 extends Command, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CreateInventoryItem) {
                    CreateInventoryItem createInventoryItem = (CreateInventoryItem)A1;
                    object = this.$outer.handle(createInventoryItem);
                } else if (A1 instanceof DeactivateInventoryItem) {
                    DeactivateInventoryItem deactivateInventoryItem = (DeactivateInventoryItem)A1;
                    object = this.$outer.handle(deactivateInventoryItem);
                } else if (A1 instanceof RemoveItemsFromInventory) {
                    RemoveItemsFromInventory removeItemsFromInventory = (RemoveItemsFromInventory)A1;
                    object = this.$outer.handle(removeItemsFromInventory);
                } else if (A1 instanceof CheckInItemsToInventory) {
                    CheckInItemsToInventory checkInItemsToInventory = (CheckInItemsToInventory)A1;
                    object = this.$outer.handle(checkInItemsToInventory);
                } else if (A1 instanceof RenameInventoryItem) {
                    RenameInventoryItem renameInventoryItem = (RenameInventoryItem)A1;
                    object = this.$outer.handle(renameInventoryItem);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Command x1) {
                Command command = x1;
                boolean bl = command instanceof CreateInventoryItem ? true : (command instanceof DeactivateInventoryItem ? true : (command instanceof RemoveItemsFromInventory ? true : (command instanceof CheckInItemsToInventory ? true : command instanceof RenameInventoryItem)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<BoxedUnit> handle(CreateInventoryItem c) {
        InventoryItem item = new InventoryItem(c.inventoryItemId(), c.name());
        return this.repository.save(item, 0);
    }

    public Future<BoxedUnit> handle(DeactivateInventoryItem c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.deactivate();
        return this.repository.save(item, c.originalVersion());
    }

    public Future<BoxedUnit> handle(RemoveItemsFromInventory c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.remove(c.count());
        return this.repository.save(item, c.originalVersion());
    }

    public Future<BoxedUnit> handle(CheckInItemsToInventory c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.checkIn(c.count());
        return this.repository.save(item, c.originalVersion());
    }

    public Future<BoxedUnit> handle(RenameInventoryItem c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.changeName(c.newName());
        return this.repository.save(item, c.originalVersion());
    }

    public InventoryCommandHandlers(Repository repository) {
        this.repository = repository;
    }
}

