/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.AggregateRootState;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.example.InventoryItem$;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemRenamed;
import net.glorat.cqrs.example.InventoryItemState;
import net.glorat.cqrs.example.ItemsCheckedInToInventory;
import net.glorat.cqrs.example.ItemsRemovedFromInventory;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]<Q!\u0001\u0002\t\u0002-\tQ\"\u00138wK:$xN]=Ji\u0016l'BA\u0002\u0005\u0003\u001d)\u00070Y7qY\u0016T!!\u0002\u0004\u0002\t\r\f(o\u001d\u0006\u0003\u000f!\taa\u001a7pe\u0006$(\"A\u0005\u0002\u00079,Go\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u001b%sg/\u001a8u_JL\u0018\n^3n'\ti\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/5!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AqAG\u0007C\u0002\u0013\u00051$\u0001\u0005sK\u001eL7\u000f\u001e:z+\u0005a\u0002\u0003B\t\u001e?\rJ!A\b\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0011\"\u001b\u0005!\u0011B\u0001\u0012\u0005\u0005-!u.\\1j]\u00163XM\u001c;\u0011\u0005\u0001\"\u0013BA\u0013\u0005\u00055\tum\u001a:fO\u0006$XMU8pi\"1q%\u0004Q\u0001\nq\t\u0011B]3hSN$(/\u001f\u0011\u0007\t9\u0011\u0001!K\n\u0003Q\rBQa\u0006\u0015\u0005\u0002-\"\u0012\u0001\f\t\u0003\u0019!BqA\f\u0015A\u0002\u0013Es&A\u0003ti\u0006$X-F\u00011!\t\u0001\u0013'\u0003\u00023\t\t\u0011\u0012iZ4sK\u001e\fG/\u001a*p_R\u001cF/\u0019;f\u0011\u001d!\u0004\u00061A\u0005RU\n\u0011b\u001d;bi\u0016|F%Z9\u0015\u0005YJ\u0004CA\t8\u0013\tA$C\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0004B\u0002\u001f)A\u0003&\u0001'\u0001\u0004ti\u0006$X\r\t\u0005\u0006}!\"\taP\u0001\tO\u0016$8\u000b^1uKV\t\u0001\t\u0005\u0002\r\u0003&\u0011!I\u0001\u0002\u0013\u0013:4XM\u001c;pefLE/Z7Ti\u0006$X\rC\u0003EQ\u0011\u0005Q)\u0001\u0002jIV\ta\t\u0005\u0002H':\u0011\u0001*\u0015\b\u0003\u0013Bs!AS(\u000f\u0005-sU\"\u0001'\u000b\u00055S\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011!\u000bB\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\u0003H+&#%B\u0001*\u0005\u0011\u00159\u0002\u0006\"\u0001X)\ra\u0003L\u0017\u0005\u00063Z\u0003\rAR\u0001\u0004S\u0012|\u0006\"B.W\u0001\u0004a\u0016!\u00028b[\u0016|\u0006CA/a\u001d\t\tb,\u0003\u0002`%\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\ty&\u0003C\u0003eQ\u0011\u0005Q-\u0001\u0006dQ\u0006tw-\u001a(b[\u0016$\"A\u000e4\t\u000b\u001d\u001c\u0007\u0019\u0001/\u0002\u000f9,wOT1nK\")\u0011\u000e\u000bC\u0001U\u00061!/Z7pm\u0016$\"AN6\t\u000b1D\u0007\u0019A7\u0002\u000b\r|WO\u001c;\u0011\u0005Eq\u0017BA8\u0013\u0005\rIe\u000e\u001e\u0005\u0006c\"\"\tA]\u0001\bG\",7m[%o)\t14\u000fC\u0003ma\u0002\u0007Q\u000eC\u0003vQ\u0011\u0005a/\u0001\u0006eK\u0006\u001cG/\u001b<bi\u0016$\u0012A\u000e")
public class InventoryItem
extends AggregateRoot {
    private AggregateRootState state = new InventoryItemState(UUID.randomUUID(), false);

    public static Function1<DomainEvent, AggregateRoot> registry() {
        return InventoryItem$.MODULE$.registry();
    }

    @Override
    public AggregateRootState state() {
        return this.state;
    }

    @Override
    public void state_$eq(AggregateRootState x$1) {
        this.state = x$1;
    }

    @Override
    public InventoryItemState getState() {
        return (InventoryItemState)this.state();
    }

    @Override
    public UUID id() {
        return this.getState().id();
    }

    public void changeName(String newName) {
        if (newName.isEmpty()) {
            throw new Exception("newName");
        }
        this.applyChange(new InventoryItemRenamed(this.id(), newName), this.applyChange$default$2());
    }

    public void remove(int count) {
        if (count <= 0) {
            throw new Exception("cant remove negative count from inventory");
        }
        this.applyChange(new ItemsRemovedFromInventory(this.id(), count), this.applyChange$default$2());
    }

    public void checkIn(int count) {
        if (count <= 0) {
            throw new Exception("must have a count greater than 0 to add to inventory");
        }
        this.applyChange(new ItemsCheckedInToInventory(this.id(), count), this.applyChange$default$2());
    }

    public void deactivate() {
        if (this.getState().activated()) {
            this.applyChange(new InventoryItemDeactivated(this.id()), this.applyChange$default$2());
            return;
        }
        throw new Exception("already deactivated");
    }

    public InventoryItem() {
    }

    public InventoryItem(UUID id_, String name_) {
        this();
        this.applyChange(new InventoryItemCreated(id_, name_), this.applyChange$default$2());
    }
}

