/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.CommitedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.EventStreamReceiver;
import net.glorat.cqrs.example.BullShitDatabase;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemDetailsDto;
import net.glorat.cqrs.example.InventoryItemRenamed;
import net.glorat.cqrs.example.ItemsCheckedInToInventory;
import net.glorat.cqrs.example.ItemsRemovedFromInventory;
import net.glorat.ledger.Logging;
import net.glorat.ledger.Logging$class;
import org.slf4j.Logger;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u0017\t9\u0012J\u001c<f]R|'/_%uK6$U\r^1jYZKWm\u001e\u0006\u0003\u0007\u0011\tq!\u001a=b[BdWM\u0003\u0002\u0006\r\u0005!1-\u001d:t\u0015\t9\u0001\"\u0001\u0004hY>\u0014\u0018\r\u001e\u0006\u0002\u0013\u0005\u0019a.\u001a;\u0004\u0001M!\u0001\u0001\u0004\n\u0019!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011QCB\u0001\u0007Y\u0016$w-\u001a:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u00111#\u0012<f]R\u001cFO]3b[J+7-Z5wKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0003I\n\u0004\"a\b\u0011\u000e\u0003\tI!!\t\u0002\u0003!\t+H\u000e\\*iSR$\u0015\r^1cCN,\u0007\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\b\u0006\u0002&MA\u0011q\u0004\u0001\u0005\u0006;\t\u0002\rA\b\u0005\u0006Q\u0001!\t!K\u0001\u0007Q\u0006tG\r\\3\u0015\u0005)\u001a\u0004cA\u0016/a5\tAF\u0003\u0002.\u001d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005=b#A\u0002$viV\u0014X\r\u0005\u0002\u000ec%\u0011!G\u0004\u0002\u0005+:LG\u000fC\u00035O\u0001\u0007Q'\u0001\u0002dKB\u0011\u0011DN\u0005\u0003o\u0011\u0011QbQ8n[&$X\rZ#wK:$\b\"\u0002\u0015\u0001\t\u0003IDc\u0001\u0019;\u007f!)1\b\u000fa\u0001y\u00059Q.Z:tC\u001e,\u0007CA\u0010>\u0013\tq$A\u0001\u000bJ]Z,g\u000e^8ss&#X-\\\"sK\u0006$X\r\u001a\u0005\u0006\u0001b\u0002\r!Q\u0001\bm\u0016\u00148/[8o!\ti!)\u0003\u0002D\u001d\t\u0019\u0011J\u001c;\t\u000b!\u0002A\u0011A#\u0015\u0007A2%\nC\u0003<\t\u0002\u0007q\t\u0005\u0002 \u0011&\u0011\u0011J\u0001\u0002\u0015\u0013:4XM\u001c;pefLE/Z7SK:\fW.\u001a3\t\u000b\u0001#\u0005\u0019A!\t\u000b1\u0003A\u0011B'\u0002\u001d\u001d+G\u000fR3uC&d7/\u0013;f[R\u0011a*\u0015\t\u0003?=K!\u0001\u0015\u0002\u0003/%sg/\u001a8u_JL\u0018\n^3n\t\u0016$\u0018-\u001b7t\tR|\u0007\"\u0002*L\u0001\u0004\u0019\u0016AA5e!\t!\u0006M\u0004\u0002V=:\u0011a+\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002`\t\u00059\u0001/Y2lC\u001e,\u0017BA1c\u0005\u00119U+\u0013#\u000b\u0005}#\u0001\"\u0002\u0015\u0001\t\u0003!Gc\u0001\u0019fS\")1h\u0019a\u0001MB\u0011qdZ\u0005\u0003Q\n\u0011\u0011$\u0013;f[N\u0014V-\\8wK\u00124%o\\7J]Z,g\u000e^8ss\")\u0001i\u0019a\u0001\u0003\")\u0001\u0006\u0001C\u0001WR\u0019\u0001\u0007\u001c9\t\u000bmR\u0007\u0019A7\u0011\u0005}q\u0017BA8\u0003\u0005eIE/Z7t\u0007\",7m[3e\u0013:$v.\u00138wK:$xN]=\t\u000b\u0001S\u0007\u0019A!\t\u000b!\u0002A\u0011\u0001:\u0015\u0007A\u001ax\u000fC\u0003<c\u0002\u0007A\u000f\u0005\u0002 k&\u0011aO\u0001\u0002\u0019\u0013:4XM\u001c;pefLE/Z7EK\u0006\u001cG/\u001b<bi\u0016$\u0007\"\u0002!r\u0001\u0004\t\u0005")
public class InventoryItemDetailView
implements Logging,
EventStreamReceiver {
    private final BullShitDatabase db;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        InventoryItemDetailView inventoryItemDetailView = this;
        synchronized (inventoryItemDetailView) {
            if (!this.bitmap$0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public Future<BoxedUnit> handle(CommitedEvent ce) {
        DomainEvent domainEvent;
        block7: {
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " , ", " handled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ce.streamId(), BoxesRunTime.boxToInteger((int)ce.streamRevision())})));
                                domainEvent = ce.event();
                                if (!(domainEvent instanceof InventoryItemRenamed)) break block2;
                                InventoryItemRenamed inventoryItemRenamed = (InventoryItemRenamed)domainEvent;
                                this.handle(inventoryItemRenamed, ce.streamRevision());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(domainEvent instanceof InventoryItemCreated)) break block4;
                            InventoryItemCreated inventoryItemCreated = (InventoryItemCreated)domainEvent;
                            this.handle(inventoryItemCreated, ce.streamRevision());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(domainEvent instanceof ItemsRemovedFromInventory)) break block5;
                        ItemsRemovedFromInventory itemsRemovedFromInventory = (ItemsRemovedFromInventory)domainEvent;
                        this.handle(itemsRemovedFromInventory, ce.streamRevision());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(domainEvent instanceof ItemsCheckedInToInventory)) break block6;
                    ItemsCheckedInToInventory itemsCheckedInToInventory = (ItemsCheckedInToInventory)domainEvent;
                    this.handle(itemsCheckedInToInventory, ce.streamRevision());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(domainEvent instanceof InventoryItemDeactivated)) break block7;
                InventoryItemDeactivated inventoryItemDeactivated = (InventoryItemDeactivated)domainEvent;
                this.handle(inventoryItemDeactivated, ce.streamRevision());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        throw new MatchError((Object)domainEvent);
    }

    public void handle(InventoryItemCreated message, int version) {
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)message.id()), (Object)new InventoryItemDetailsDto(message.id(), message.name(), 0, version))));
    }

    public void handle(InventoryItemRenamed message, int version) {
        InventoryItemDetailsDto d = this.GetDetailsItem(message.id());
        String x$13 = message.newName();
        int x$14 = version;
        UUID x$15 = d.copy$default$1();
        int x$16 = d.copy$default$3();
        InventoryItemDetailsDto newd = d.copy(x$15, x$13, x$16, x$14);
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().updated((Object)message.id(), (Object)newd));
    }

    private InventoryItemDetailsDto GetDetailsItem(UUID id) {
        Option d = this.db.details().get((Object)id);
        if (d.isDefined()) {
            return (InventoryItemDetailsDto)d.get();
        }
        throw new Exception("did not find the original inventory this shouldnt happen");
    }

    public void handle(ItemsRemovedFromInventory message, int version) {
        InventoryItemDetailsDto d = this.GetDetailsItem(message.id());
        int x$9 = d.currentCount() - message.count();
        int x$10 = version;
        UUID x$11 = d.copy$default$1();
        String x$12 = d.copy$default$2();
        InventoryItemDetailsDto newd = d.copy(x$11, x$12, x$9, x$10);
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().updated((Object)message.id(), (Object)newd));
    }

    public void handle(ItemsCheckedInToInventory message, int version) {
        InventoryItemDetailsDto d = this.GetDetailsItem(message.id());
        int x$5 = d.currentCount() + message.count();
        int x$6 = version;
        UUID x$7 = d.copy$default$1();
        String x$8 = d.copy$default$2();
        InventoryItemDetailsDto newd = d.copy(x$7, x$8, x$5, x$6);
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().updated((Object)message.id(), (Object)newd));
    }

    public void handle(InventoryItemDeactivated message, int version) {
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)((Map)this.db.details().$minus((Object)message.id())));
    }

    public InventoryItemDetailView(BullShitDatabase db) {
        this.db = db;
        Logging$class.$init$(this);
    }
}

