/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.CommitedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.EventStreamReceiver;
import net.glorat.cqrs.example.BullShitDatabase;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemListDto;
import net.glorat.cqrs.example.InventoryItemRenamed;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u0017\t\t\u0012J\u001c<f]R|'/\u001f'jgR4\u0016.Z<\u000b\u0005\r!\u0011aB3yC6\u0004H.\u001a\u0006\u0003\u000b\u0019\tAaY9sg*\u0011q\u0001C\u0001\u0007O2|'/\u0019;\u000b\u0003%\t1A\\3u\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\u0014\u000bZ,g\u000e^*ue\u0016\fWNU3dK&4XM\u001d\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005\u0011AM\u0019\t\u00033ii\u0011AA\u0005\u00037\t\u0011\u0001CQ;mYNC\u0017\u000e\u001e#bi\u0006\u0014\u0017m]3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u001a\u0001!)q\u0003\ba\u00011!)!\u0005\u0001C\u0001G\u00051\u0001.\u00198eY\u0016$\"\u0001J\u0017\u0011\u0007\u0015B#&D\u0001'\u0015\t9c\"\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u000b\u0014\u0003\r\u0019+H/\u001e:f!\ti1&\u0003\u0002-\u001d\t!QK\\5u\u0011\u0015q\u0013\u00051\u00010\u0003\t\u0019W\r\u0005\u0002\u0014a%\u0011\u0011\u0007\u0002\u0002\u000e\u0007>lW.\u001b;fI\u00163XM\u001c;\t\u000b\t\u0002A\u0011A\u001a\u0015\u0007)\"\u0014\bC\u00036e\u0001\u0007a'A\u0004nKN\u001c\u0018mZ3\u0011\u0005e9\u0014B\u0001\u001d\u0003\u0005QIeN^3oi>\u0014\u00180\u0013;f[\u000e\u0013X-\u0019;fI\")!H\ra\u0001w\u00059a/\u001a:tS>t\u0007CA\u0007=\u0013\tidBA\u0002J]RDQA\t\u0001\u0005\u0002}\"2A\u000b!E\u0011\u0015)d\b1\u0001B!\tI\")\u0003\u0002D\u0005\t!\u0012J\u001c<f]R|'/_%uK6\u0014VM\\1nK\u0012DQA\u000f A\u0002mBQA\t\u0001\u0005\u0002\u0019#2AK$L\u0011\u0015)T\t1\u0001I!\tI\u0012*\u0003\u0002K\u0005\tA\u0012J\u001c<f]R|'/_%uK6$U-Y2uSZ\fG/\u001a3\t\u000bi*\u0005\u0019A\u001e")
public class InventoryListView
implements EventStreamReceiver {
    private final BullShitDatabase db;

    @Override
    public Future<BoxedUnit> handle(CommitedEvent ce) {
        DomainEvent domainEvent = ce.event();
        if (domainEvent instanceof InventoryItemRenamed) {
            InventoryItemRenamed inventoryItemRenamed = (InventoryItemRenamed)domainEvent;
            this.handle(inventoryItemRenamed, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof InventoryItemCreated) {
            InventoryItemCreated inventoryItemCreated = (InventoryItemCreated)domainEvent;
            this.handle(inventoryItemCreated, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof InventoryItemDeactivated) {
            InventoryItemDeactivated inventoryItemDeactivated = (InventoryItemDeactivated)domainEvent;
            this.handle(inventoryItemDeactivated, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void handle(InventoryItemCreated message, int version) {
        this.db.list_$eq((List<InventoryItemListDto>)((List)this.db.list().$plus$colon((Object)new InventoryItemListDto(message.id(), message.name()), List$.MODULE$.canBuildFrom())));
    }

    public void handle(InventoryItemRenamed message, int version) {
        this.db.list_$eq((List<InventoryItemListDto>)((List)this.db.list().map((Function1)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final InventoryItemRenamed message$2;

            public final InventoryItemListDto apply(InventoryItemListDto x) {
                InventoryItemListDto inventoryItemListDto;
                UUID uUID = x.id();
                UUID uUID2 = this.message$2.id();
                if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null)) {
                    String x$3 = this.message$2.newName();
                    UUID x$4 = x.copy$default$1();
                    inventoryItemListDto = x.copy(x$4, x$3);
                } else {
                    inventoryItemListDto = x;
                }
                return inventoryItemListDto;
            }
            {
                this.message$2 = message$2;
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public void handle(InventoryItemDeactivated message, int version) {
        this.db.list_$eq((List<InventoryItemListDto>)((List)this.db.list().filter((Function1)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final InventoryItemDeactivated message$1;

            public final boolean apply(InventoryItemListDto x) {
                UUID uUID = x.id();
                UUID uUID2 = this.message$1.id();
                return uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null;
            }
            {
                this.message$1 = message$1;
            }
        })));
    }

    public InventoryListView(BullShitDatabase db) {
        this.db = db;
    }
}

