/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.ledger;

import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.CommitedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.Repository;
import net.glorat.ledger.ConcurrencyException;
import net.glorat.ledger.EntityView;
import net.glorat.ledger.Logging;
import net.glorat.ledger.Logging$class;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001%\u0011a\"\u00138NK6|'/\u001f'fI\u001e,'O\u0003\u0002\u0004\t\u00051A.\u001a3hKJT!!\u0002\u0004\u0002\r\u001ddwN]1u\u0015\u00059\u0011a\u00018fi\u000e\u00011\u0003\u0002\u0001\u000b!Y\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0011\u0019\u0017O]:\n\u0005U\u0011\"A\u0003*fa>\u001c\u0018\u000e^8ssB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012\u0001E:ue\u0016\fW\u000eV8SKZL7/[8o!\rYQdH\u0005\u0003=1\u0011aa\u00149uS>t\u0007\u0003B\u0006!EIJ!!\t\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u00120\u001d\t!SF\u0004\u0002&Y9\u0011ae\u000b\b\u0003O)j\u0011\u0001\u000b\u0006\u0003S!\ta\u0001\u0010:p_Rt\u0014\"A\u0004\n\u0005\u00151\u0011BA\n\u0005\u0013\tq##A\u0004qC\u000e\\\u0017mZ3\n\u0005A\n$\u0001B$V\u0013\u0012S!A\f\n\u0011\u0005-\u0019\u0014B\u0001\u001b\r\u0005\rIe\u000e\u001e\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005A!/Z4jgR\u0014\u0018\u0010\u0005\u0003\fAaZ\u0004CA\t:\u0013\tQ$CA\u0006E_6\f\u0017N\\#wK:$\bCA\t=\u0013\ti$CA\u0007BO\u001e\u0014XmZ1uKJ{w\u000e\u001e\u0005\t\u007f\u0001\u0011)\u0019!C\u0002\u0001\u0006\u0011QmY\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A\tD\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001$D\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003B\u0003\r)7\r\t\u0005\u0006\u0015\u0002!\taS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071{\u0005\u000b\u0006\u0002N\u001dB\u0011q\u0003\u0001\u0005\u0006\u007f%\u0003\u001d!\u0011\u0005\u00067%\u0003\r\u0001\b\u0005\u0006m%\u0003\ra\u000e\u0005\b%\u0002\u0001\r\u0011\"\u0001T\u00039\u0019w.\\7ji\u0016$WI^3oiN,\u0012\u0001\u0016\t\u0004+fcfB\u0001,Y\u001d\t9s+C\u0001\u000e\u0013\tqC\"\u0003\u0002[7\n!A*[:u\u0015\tqC\u0002\u0005\u0002\u0012;&\u0011aL\u0005\u0002\u000e\u0007>lW.\u001b;fI\u00163XM\u001c;\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\u0006\u00112m\\7nSR,G-\u0012<f]R\u001cx\fJ3r)\t\u0011W\r\u0005\u0002\fG&\u0011A\r\u0004\u0002\u0005+:LG\u000fC\u0004g?\u0006\u0005\t\u0019\u0001+\u0002\u0007a$\u0013\u0007\u0003\u0004i\u0001\u0001\u0006K\u0001V\u0001\u0010G>lW.\u001b;fI\u00163XM\u001c;tA!9!\u000e\u0001b\u0001\n\u0003Y\u0017AC3oi&$\u0018PV5foV\tA\u000e\u0005\u0002\u0018[&\u0011aN\u0001\u0002\u000b\u000b:$\u0018\u000e^=WS\u0016<\bB\u00029\u0001A\u0003%A.A\u0006f]RLG/\u001f,jK^\u0004\u0003\"\u0002:\u0001\t\u0003\u001a\u0018\u0001B:bm\u0016$2\u0001^<z!\r\u0011UOY\u0005\u0003m\u000e\u0013aAR;ukJ,\u0007\"\u0002=r\u0001\u0004Y\u0014!C1hOJ,w-\u0019;f\u0011\u0015Q\u0018\u000f1\u00013\u0003=)\u0007\u0010]3di\u0016$g+\u001a:tS>t\u0007\"\u0002?\u0001\t\u0003j\u0018aB4fi\nK\u0018\nZ\u000b\u0004}\u0006\u0015A#B@\u0002$\u0005\u001dB\u0003BA\u0001\u0003#\u0001B!a\u0001\u0002\u00061\u0001AaBA\u0004w\n\u0007\u0011\u0011\u0002\u0002\u0002)F\u0019\u00111B\u001e\u0011\u0007-\ti!C\u0002\u0002\u00101\u0011qAT8uQ&tw\rC\u0005\u0002\u0014m\f\t\u0011q\u0001\u0002\u0016\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005]\u0011QDA\u0001\u001d\rY\u0011\u0011D\u0005\u0004\u00037a\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"!D\"mCN\u001cX*\u00198jM\u0016\u001cHOC\u0002\u0002\u001c1Aa!!\n|\u0001\u0004\u0011\u0013AA5e\u0011\u001d\tIc\u001fa\u0001\u0003\u0003\tA\u0001^7qY\u0002")
public class InMemoryLedger
implements Repository,
Logging {
    private final Option<Function1<UUID, Object>> streamToRevision;
    private final ExecutionContext ec;
    private List<CommitedEvent> commitedEvents;
    private final EntityView entityView;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        InMemoryLedger inMemoryLedger = this;
        synchronized (inMemoryLedger) {
            if (!this.bitmap$0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public List<CommitedEvent> commitedEvents() {
        return this.commitedEvents;
    }

    public void commitedEvents_$eq(List<CommitedEvent> x$1) {
        this.commitedEvents = x$1;
    }

    public EntityView entityView() {
        return this.entityView;
    }

    @Override
    public Future<BoxedUnit> save(AggregateRoot aggregate, int expectedVersion) {
        int latestVersion;
        if (this.streamToRevision.isDefined() && expectedVersion < (latestVersion = BoxesRunTime.unboxToInt((Object)((Function1)this.streamToRevision.get()).apply((Object)aggregate.id())))) {
            throw new ConcurrencyException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to save aggregate from version ", " when ", " already in DB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedVersion), BoxesRunTime.boxToInteger((int)latestVersion)})));
        }
        Iterable<DomainEvent> evs = aggregate.getUncommittedChanges();
        IntRef i = IntRef.create((int)expectedVersion);
        Iterable cevs = (Iterable)evs.map((Function1)new Serializable(this, aggregate, i){
            public static final long serialVersionUID = 0L;
            private final AggregateRoot aggregate$1;
            private final IntRef i$1;

            public final CommitedEvent apply(DomainEvent ev) {
                ++this.i$1.elem;
                return new CommitedEvent(ev, this.aggregate$1.id(), this.i$1.elem);
            }
            {
                this.aggregate$1 = aggregate$1;
                this.i$1 = i$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        this.commitedEvents_$eq((List<CommitedEvent>)((List)this.commitedEvents().$plus$plus((GenTraversableOnce)cevs, List$.MODULE$.canBuildFrom())));
        Iterable foo = (Iterable)cevs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryLedger $outer;

            public final Future<BoxedUnit> apply(CommitedEvent e) {
                return this.$outer.entityView().handle(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)foo, Iterable$.MODULE$.canBuildFrom(), this.ec()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Iterable<BoxedUnit> x$2) {
            }
        }, this.ec());
    }

    @Override
    public <T extends AggregateRoot> T getById(UUID id, T tmpl, ClassTag<T> evidence$1) {
        return this.entityView().getById(id, tmpl, evidence$1);
    }

    public InMemoryLedger(Option<Function1<UUID, Object>> streamToRevision, Function1<DomainEvent, AggregateRoot> registry, ExecutionContext ec) {
        this.streamToRevision = streamToRevision;
        this.ec = ec;
        Logging$class.$init$(this);
        this.commitedEvents = Nil$.MODULE$;
        this.entityView = new EntityView(registry);
    }
}

