/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.CommitedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.EventStreamReceiver;
import net.glorat.cqrs.example.BullShitDatabase;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemDetailsDto;
import net.glorat.cqrs.example.InventoryItemRenamed;
import net.glorat.cqrs.example.ItemsCheckedInToInventory;
import net.glorat.cqrs.example.ItemsRemovedFromInventory;
import net.glorat.ledger.Logging;
import org.slf4j.Logger;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a4AAC\u0006\u0001)!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u0003/\u0001\u0011\u0005a\bC\u0003/\u0001\u0011\u0005\u0011\nC\u0003P\u0001\u0011%\u0001\u000bC\u0003/\u0001\u0011\u0005a\rC\u0003/\u0001\u0011\u0005A\u000eC\u0003/\u0001\u0011\u0005!OA\fJ]Z,g\u000e^8ss&#X-\u001c#fi\u0006LGNV5fo*\u0011A\"D\u0001\bKb\fW\u000e\u001d7f\u0015\tqq\"\u0001\u0003dcJ\u001c(B\u0001\t\u0012\u0003\u00199Gn\u001c:bi*\t!#A\u0002oKR\u001c\u0001a\u0005\u0003\u0001+m\t\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\u001f\u00051A.\u001a3hKJL!\u0001I\u000f\u0003\u000f1{wmZ5oOB\u0011!eI\u0007\u0002\u001b%\u0011A%\u0004\u0002\u0014\u000bZ,g\u000e^*ue\u0016\fWNU3dK&4XM]\u0001\u0003I\n\u0004\"a\n\u0015\u000e\u0003-I!!K\u0006\u0003!\t+H\u000e\\*iSR$\u0015\r^1cCN,\u0017A\u0002\u001fj]&$h\b\u0006\u0002-[A\u0011q\u0005\u0001\u0005\u0006K\t\u0001\rAJ\u0001\u0007Q\u0006tG\r\\3\u0015\u0005AJ\u0004cA\u00195m5\t!G\u0003\u00024/\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0012$A\u0002$viV\u0014X\r\u0005\u0002\u0017o%\u0011\u0001h\u0006\u0002\u0005+:LG\u000fC\u0003;\u0007\u0001\u00071(\u0001\u0002dKB\u0011!\u0005P\u0005\u0003{5\u0011QbQ8n[&$X\rZ#wK:$Hc\u0001\u001c@\t\")\u0001\t\u0002a\u0001\u0003\u00069Q.Z:tC\u001e,\u0007CA\u0014C\u0013\t\u00195B\u0001\u000bJ]Z,g\u000e^8ss&#X-\\\"sK\u0006$X\r\u001a\u0005\u0006\u000b\u0012\u0001\rAR\u0001\bm\u0016\u00148/[8o!\t1r)\u0003\u0002I/\t\u0019\u0011J\u001c;\u0015\u0007YRe\nC\u0003A\u000b\u0001\u00071\n\u0005\u0002(\u0019&\u0011Qj\u0003\u0002\u0015\u0013:4XM\u001c;pefLE/Z7SK:\fW.\u001a3\t\u000b\u0015+\u0001\u0019\u0001$\u0002\u001d\u001d+G\u000fR3uC&d7/\u0013;f[R\u0011\u0011\u000b\u0016\t\u0003OIK!aU\u0006\u0003/%sg/\u001a8u_JL\u0018\n^3n\t\u0016$\u0018-\u001b7t\tR|\u0007\"B+\u0007\u0001\u00041\u0016AA5e!\t96M\u0004\u0002YC:\u0011\u0011\f\u0019\b\u00035~s!a\u00170\u000e\u0003qS!!X\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002c\u001b\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u0005\u00119U+\u0013#\u000b\u0005\tlAc\u0001\u001chW\")\u0001i\u0002a\u0001QB\u0011q%[\u0005\u0003U.\u0011\u0011$\u0013;f[N\u0014V-\\8wK\u00124%o\\7J]Z,g\u000e^8ss\")Qi\u0002a\u0001\rR\u0019a'\\9\t\u000b\u0001C\u0001\u0019\u00018\u0011\u0005\u001dz\u0017B\u00019\f\u0005eIE/Z7t\u0007\",7m[3e\u0013:$v.\u00138wK:$xN]=\t\u000b\u0015C\u0001\u0019\u0001$\u0015\u0007Y\u001ax\u000fC\u0003A\u0013\u0001\u0007A\u000f\u0005\u0002(k&\u0011ao\u0003\u0002\u0019\u0013:4XM\u001c;pefLE/Z7EK\u0006\u001cG/\u001b<bi\u0016$\u0007\"B#\n\u0001\u00041\u0005")
public class InventoryItemDetailView
implements Logging,
EventStreamReceiver {
    private final BullShitDatabase db;
    private Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        InventoryItemDetailView inventoryItemDetailView = this;
        synchronized (inventoryItemDetailView) {
            if (!this.bitmap$0) {
                this.log = Logging.log$(this);
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public Future<BoxedUnit> handle(CommitedEvent ce) {
        this.log().info(new StringBuilder(11).append(ce.streamId()).append(" , ").append(ce.streamRevision()).append(" handled").toString());
        DomainEvent domainEvent = ce.event();
        if (domainEvent instanceof InventoryItemRenamed) {
            InventoryItemRenamed inventoryItemRenamed = (InventoryItemRenamed)domainEvent;
            this.handle(inventoryItemRenamed, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof InventoryItemCreated) {
            InventoryItemCreated inventoryItemCreated = (InventoryItemCreated)domainEvent;
            this.handle(inventoryItemCreated, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof ItemsRemovedFromInventory) {
            ItemsRemovedFromInventory itemsRemovedFromInventory = (ItemsRemovedFromInventory)domainEvent;
            this.handle(itemsRemovedFromInventory, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof ItemsCheckedInToInventory) {
            ItemsCheckedInToInventory itemsCheckedInToInventory = (ItemsCheckedInToInventory)domainEvent;
            this.handle(itemsCheckedInToInventory, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof InventoryItemDeactivated) {
            InventoryItemDeactivated inventoryItemDeactivated = (InventoryItemDeactivated)domainEvent;
            this.handle(inventoryItemDeactivated, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)domainEvent);
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void handle(InventoryItemCreated message, int version) {
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)message.id()), (Object)new InventoryItemDetailsDto(message.id(), message.name(), 0, version))));
    }

    public void handle(InventoryItemRenamed message, int version) {
        InventoryItemDetailsDto d = this.GetDetailsItem(message.id());
        String x$1 = message.newName();
        int x$2 = version;
        UUID x$3 = d.copy$default$1();
        int x$4 = d.copy$default$3();
        InventoryItemDetailsDto newd = d.copy(x$3, x$1, x$4, x$2);
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().updated((Object)message.id(), (Object)newd));
    }

    private InventoryItemDetailsDto GetDetailsItem(UUID id) {
        Option d = this.db.details().get((Object)id);
        if (!d.isDefined()) {
            throw new Exception("did not find the original inventory this shouldnt happen");
        }
        return (InventoryItemDetailsDto)d.get();
    }

    public void handle(ItemsRemovedFromInventory message, int version) {
        InventoryItemDetailsDto d = this.GetDetailsItem(message.id());
        int x$1 = d.currentCount() - message.count();
        int x$2 = version;
        UUID x$3 = d.copy$default$1();
        String x$4 = d.copy$default$2();
        InventoryItemDetailsDto newd = d.copy(x$3, x$4, x$1, x$2);
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().updated((Object)message.id(), (Object)newd));
    }

    public void handle(ItemsCheckedInToInventory message, int version) {
        InventoryItemDetailsDto d = this.GetDetailsItem(message.id());
        int x$1 = d.currentCount() + message.count();
        int x$2 = version;
        UUID x$3 = d.copy$default$1();
        String x$4 = d.copy$default$2();
        InventoryItemDetailsDto newd = d.copy(x$3, x$4, x$1, x$2);
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)this.db.details().updated((Object)message.id(), (Object)newd));
    }

    public void handle(InventoryItemDeactivated message, int version) {
        this.db.details_$eq((Map<UUID, InventoryItemDetailsDto>)((Map)this.db.details().$minus((Object)message.id())));
    }

    public InventoryItemDetailView(BullShitDatabase db) {
        this.db = db;
        Logging.$init$(this);
    }
}

