/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.CommitedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.EventStreamReceiver;
import net.glorat.cqrs.example.BullShitDatabase;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemListDto;
import net.glorat.cqrs.example.InventoryItemRenamed;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113Aa\u0002\u0005\u0001#!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0003&\u0001\u0011\u0005Q\u0007C\u0003&\u0001\u0011\u0005\u0001\tC\u0003&\u0001\u0011\u0005aIA\tJ]Z,g\u000e^8ss2K7\u000f\u001e,jK^T!!\u0003\u0006\u0002\u000f\u0015D\u0018-\u001c9mK*\u00111\u0002D\u0001\u0005GF\u00148O\u0003\u0002\u000e\u001d\u00051q\r\\8sCRT\u0011aD\u0001\u0004]\u0016$8\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\t!\"\u0003\u0002\u001c\u0015\t\u0019RI^3oiN#(/Z1n%\u0016\u001cW-\u001b<fe\u0006\u0011AM\u0019\t\u0003=}i\u0011\u0001C\u0005\u0003A!\u0011\u0001CQ;mYNC\u0017\u000e\u001e#bi\u0006\u0014\u0017m]3\u0002\rqJg.\u001b;?)\t\u0019C\u0005\u0005\u0002\u001f\u0001!)AD\u0001a\u0001;\u00051\u0001.\u00198eY\u0016$\"a\n\u0019\u0011\u0007!ZS&D\u0001*\u0015\tQC#\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0015\u0003\r\u0019+H/\u001e:f!\t\u0019b&\u0003\u00020)\t!QK\\5u\u0011\u0015\t4\u00011\u00013\u0003\t\u0019W\r\u0005\u0002\u001ag%\u0011AG\u0003\u0002\u000e\u0007>lW.\u001b;fI\u00163XM\u001c;\u0015\u0007524\bC\u00038\t\u0001\u0007\u0001(A\u0004nKN\u001c\u0018mZ3\u0011\u0005yI\u0014B\u0001\u001e\t\u0005QIeN^3oi>\u0014\u00180\u0013;f[\u000e\u0013X-\u0019;fI\")A\b\u0002a\u0001{\u00059a/\u001a:tS>t\u0007CA\n?\u0013\tyDCA\u0002J]R$2!L!F\u0011\u00159T\u00011\u0001C!\tq2)\u0003\u0002E\u0011\t!\u0012J\u001c<f]R|'/_%uK6\u0014VM\\1nK\u0012DQ\u0001P\u0003A\u0002u\"2!L$L\u0011\u00159d\u00011\u0001I!\tq\u0012*\u0003\u0002K\u0011\tA\u0012J\u001c<f]R|'/_%uK6$U-Y2uSZ\fG/\u001a3\t\u000bq2\u0001\u0019A\u001f")
public class InventoryListView
implements EventStreamReceiver {
    private final BullShitDatabase db;

    @Override
    public Future<BoxedUnit> handle(CommitedEvent ce) {
        DomainEvent domainEvent = ce.event();
        if (domainEvent instanceof InventoryItemRenamed) {
            InventoryItemRenamed inventoryItemRenamed = (InventoryItemRenamed)domainEvent;
            this.handle(inventoryItemRenamed, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof InventoryItemCreated) {
            InventoryItemCreated inventoryItemCreated = (InventoryItemCreated)domainEvent;
            this.handle(inventoryItemCreated, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (domainEvent instanceof InventoryItemDeactivated) {
            InventoryItemDeactivated inventoryItemDeactivated = (InventoryItemDeactivated)domainEvent;
            this.handle(inventoryItemDeactivated, ce.streamRevision());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void handle(InventoryItemCreated message, int version) {
        this.db.list_$eq((List<InventoryItemListDto>)((List)this.db.list().$plus$colon((Object)new InventoryItemListDto(message.id(), message.name()), List$.MODULE$.canBuildFrom())));
    }

    public void handle(InventoryItemRenamed message, int version) {
        this.db.list_$eq((List<InventoryItemListDto>)((List)this.db.list().map((Function1 & java.io.Serializable & Serializable)x -> {
            InventoryItemListDto inventoryItemListDto;
            UUID uUID = x.id();
            UUID uUID2 = message.id();
            if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null)) {
                String x$1 = message.newName();
                UUID x$2 = x.copy$default$1();
                inventoryItemListDto = x.copy(x$2, x$1);
            } else {
                inventoryItemListDto = x;
            }
            return inventoryItemListDto;
        }, List$.MODULE$.canBuildFrom())));
    }

    public void handle(InventoryItemDeactivated message, int version) {
        this.db.list_$eq((List<InventoryItemListDto>)((List)this.db.list().filter((Function1 & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)InventoryListView.$anonfun$handle$2(message, x)))));
    }

    public static final /* synthetic */ boolean $anonfun$handle$2(InventoryItemDeactivated message$2, InventoryItemListDto x) {
        UUID uUID = x.id();
        UUID uUID2 = message$2.id();
        return uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2);
    }

    public InventoryListView(BullShitDatabase db) {
        this.db = db;
    }
}

