/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.ledger;

import java.io.Serializable;
import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.CommitedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.Repository;
import net.glorat.ledger.ConcurrencyException;
import net.glorat.ledger.EntityView;
import net.glorat.ledger.Logging;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0007\u000f\u0001UA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0001\n\u0001BC\u0002\u0013\r\u0011\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dA\u0006\u00011A\u0005\u0002eCq!\u001a\u0001A\u0002\u0013\u0005a\r\u0003\u0004m\u0001\u0001\u0006KA\u0017\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u0019\u0011\b\u0001)A\u0005_\")1\u000f\u0001C!i\")A\u0010\u0001C!{\nq\u0011J\\'f[>\u0014\u0018\u0010T3eO\u0016\u0014(BA\b\u0011\u0003\u0019aW\rZ4fe*\u0011\u0011CE\u0001\u0007O2|'/\u0019;\u000b\u0003M\t1A\\3u\u0007\u0001\u0019B\u0001\u0001\f\u001dEA\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0011\u000e\u0003yQ!a\b\t\u0002\t\r\f(o]\u0005\u0003Cy\u0011!BU3q_NLGo\u001c:z!\t\u0019C%D\u0001\u000f\u0013\t)cBA\u0004M_\u001e<\u0017N\\4\u0002!M$(/Z1n)>\u0014VM^5tS>t\u0007cA\f)U%\u0011\u0011\u0006\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t]YS&P\u0005\u0003Ya\u0011\u0011BR;oGRLwN\\\u0019\u0011\u00059RdBA\u00189\u001d\t\u0001tG\u0004\u00022m9\u0011!'N\u0007\u0002g)\u0011A\u0007F\u0001\u0007yI|w\u000e\u001e \n\u0003MI!!\u0005\n\n\u0005}\u0001\u0012BA\u001d\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000f\u001f\u0003\t\u001d+\u0016\n\u0012\u0006\u0003sy\u0001\"a\u0006 \n\u0005}B\"aA%oi\u0006A!/Z4jgR\u0014\u0018\u0010\u0005\u0003\u0018W\t+\u0005CA\u000fD\u0013\t!eDA\u0006E_6\f\u0017N\\#wK:$\bCA\u000fG\u0013\t9eDA\u0007BO\u001e\u0014XmZ1uKJ{w\u000e^\u0001\u0003K\u000e,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bb\t!bY8oGV\u0014(/\u001a8u\u0013\tyEJ\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0002\rqJg.\u001b;?)\r\u0019fk\u0016\u000b\u0003)V\u0003\"a\t\u0001\t\u000b!+\u00019\u0001&\t\u000b\u0019*\u0001\u0019A\u0014\t\u000b\u0001+\u0001\u0019A!\u0002\u001d\r|W.\\5uK\u0012,e/\u001a8ugV\t!\fE\u0002\\?\nt!\u0001\u00180\u000f\u0005Ij\u0016\"A\r\n\u0005eB\u0012B\u00011b\u0005\u0011a\u0015n\u001d;\u000b\u0005eB\u0002CA\u000fd\u0013\t!gDA\u0007D_6l\u0017\u000e^3e\u000bZ,g\u000e^\u0001\u0013G>lW.\u001b;fI\u00163XM\u001c;t?\u0012*\u0017\u000f\u0006\u0002hUB\u0011q\u0003[\u0005\u0003Sb\u0011A!\u00168ji\"91nBA\u0001\u0002\u0004Q\u0016a\u0001=%c\u0005y1m\\7nSR,G-\u0012<f]R\u001c\b%\u0001\u0006f]RLG/\u001f,jK^,\u0012a\u001c\t\u0003GAL!!\u001d\b\u0003\u0015\u0015sG/\u001b;z-&,w/A\u0006f]RLG/\u001f,jK^\u0004\u0013\u0001B:bm\u0016$2!\u001e={!\rYeoZ\u0005\u0003o2\u0013aAR;ukJ,\u0007\"B=\f\u0001\u0004)\u0015!C1hOJ,w-\u0019;f\u0011\u0015Y8\u00021\u0001>\u0003=)\u0007\u0010]3di\u0016$g+\u001a:tS>t\u0017aB4fi\nK\u0018\nZ\u000b\u0004}\u0006\u0015A#B@\u0002&\u0005%B\u0003BA\u0001\u0003#\u0001B!a\u0001\u0002\u00061\u0001AaBA\u0004\u0019\t\u0007\u0011\u0011\u0002\u0002\u0002)F\u0019\u00111B#\u0011\u0007]\ti!C\u0002\u0002\u0010a\u0011qAT8uQ&tw\rC\u0005\u0002\u00141\t\t\u0011q\u0001\u0002\u0016\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005]\u0011qDA\u0001\u001d\u0011\tI\"a\u0007\u0011\u0005IB\u0012bAA\u000f1\u00051\u0001K]3eK\u001aLA!!\t\u0002$\ti1\t\\1tg6\u000bg.\u001b4fgRT1!!\b\u0019\u0011\u0019\t9\u0003\u0004a\u0001[\u0005\u0011\u0011\u000e\u001a\u0005\b\u0003Wa\u0001\u0019AA\u0001\u0003\u0011!X\u000e\u001d7")
public class InMemoryLedger
implements Repository,
Logging {
    private final Option<Function1<UUID, Object>> streamToRevision;
    private final ExecutionContext ec;
    private List<CommitedEvent> commitedEvents;
    private final EntityView entityView;
    private Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        InMemoryLedger inMemoryLedger = this;
        synchronized (inMemoryLedger) {
            if (!this.bitmap$0) {
                this.log = Logging.log$(this);
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public List<CommitedEvent> commitedEvents() {
        return this.commitedEvents;
    }

    public void commitedEvents_$eq(List<CommitedEvent> x$1) {
        this.commitedEvents = x$1;
    }

    public EntityView entityView() {
        return this.entityView;
    }

    @Override
    public Future<BoxedUnit> save(AggregateRoot aggregate, int expectedVersion) {
        int latestVersion;
        if (this.streamToRevision.isDefined() && expectedVersion < (latestVersion = BoxesRunTime.unboxToInt((Object)((Function1)this.streamToRevision.get()).apply((Object)aggregate.id())))) {
            throw new ConcurrencyException(new StringBuilder(58).append("Trying to save aggregate from version ").append(expectedVersion).append(" when ").append(latestVersion).append(" already in DB").toString());
        }
        Iterable<DomainEvent> evs = aggregate.getUncommittedChanges();
        IntRef i = IntRef.create((int)expectedVersion);
        Iterable cevs = (Iterable)evs.map((Function1 & Serializable & scala.Serializable)ev -> {
            ++i$1.elem;
            return new CommitedEvent((DomainEvent)ev, aggregate.id(), i$1.elem);
        }, Iterable$.MODULE$.canBuildFrom());
        this.commitedEvents_$eq((List<CommitedEvent>)((List)this.commitedEvents().$plus$plus((GenTraversableOnce)cevs, List$.MODULE$.canBuildFrom())));
        Iterable foo = (Iterable)cevs.map((Function1 & Serializable & scala.Serializable)e -> this.entityView().handle((CommitedEvent)e), Iterable$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)foo, Iterable$.MODULE$.canBuildFrom(), this.ec()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            InMemoryLedger.$anonfun$save$3(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    @Override
    public <T extends AggregateRoot> T getById(UUID id, T tmpl, ClassTag<T> evidence$1) {
        return this.entityView().getById(id, tmpl, evidence$1);
    }

    public static final /* synthetic */ void $anonfun$save$3(Iterable x$2) {
    }

    public InMemoryLedger(Option<Function1<UUID, Object>> streamToRevision, Function1<DomainEvent, AggregateRoot> registry, ExecutionContext ec) {
        this.streamToRevision = streamToRevision;
        this.ec = ec;
        Logging.$init$(this);
        this.commitedEvents = Nil$.MODULE$;
        this.entityView = new EntityView(registry);
    }
}

