/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import net.glorat.cqrs.Command;
import net.glorat.cqrs.CommandHandler;
import net.glorat.cqrs.Repository;
import net.glorat.cqrs.example.CheckInItemsToInventory;
import net.glorat.cqrs.example.CreateInventoryItem;
import net.glorat.cqrs.example.DeactivateInventoryItem;
import net.glorat.cqrs.example.InventoryItem;
import net.glorat.cqrs.example.RemoveItemsFromInventory;
import net.glorat.cqrs.example.RenameInventoryItem;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0003\u0006\u0001'!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u00039\u0001\u0011\u0005q\bC\u00039\u0001\u0011\u0005A\tC\u00039\u0001\u0011\u0005\u0011\nC\u00039\u0001\u0011\u0005aJ\u0001\rJ]Z,g\u000e^8ss\u000e{W.\\1oI\"\u000bg\u000e\u001a7feNT!a\u0003\u0007\u0002\u000f\u0015D\u0018-\u001c9mK*\u0011QBD\u0001\u0005GF\u00148O\u0003\u0002\u0010!\u00051q\r\\8sCRT\u0011!E\u0001\u0004]\u0016$8\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\tq1i\\7nC:$\u0007*\u00198eY\u0016\u0014\u0018A\u0003:fa>\u001c\u0018\u000e^8ssB\u00111\u0004I\u0005\u0003C1\u0011!BU3q_NLGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011A\u0003\u0005\u0006=\t\u0001\raH\u0001\be\u0016\u001cW-\u001b<f+\u0005I\u0003\u0003B\u000b+Y=J!a\u000b\f\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"aG\u0017\n\u00059b!aB\"p[6\fg\u000e\u001a\t\u0004aM*T\"A\u0019\u000b\u0005I2\u0012AC2p]\u000e,(O]3oi&\u0011A'\r\u0002\u0007\rV$XO]3\u0011\u0005U1\u0014BA\u001c\u0017\u0005\u0011)f.\u001b;\u0002\r!\fg\u000e\u001a7f)\ty#\bC\u0003<\t\u0001\u0007A(A\u0001d!\t)S(\u0003\u0002?\u0015\t\u00192I]3bi\u0016LeN^3oi>\u0014\u00180\u0013;f[R\u0011q\u0006\u0011\u0005\u0006w\u0015\u0001\r!\u0011\t\u0003K\tK!a\u0011\u0006\u0003/\u0011+\u0017m\u0019;jm\u0006$X-\u00138wK:$xN]=Ji\u0016lGCA\u0018F\u0011\u0015Yd\u00011\u0001G!\t)s)\u0003\u0002I\u0015\tA\"+Z7pm\u0016LE/Z7t\rJ|W.\u00138wK:$xN]=\u0015\u0005=R\u0005\"B\u001e\b\u0001\u0004Y\u0005CA\u0013M\u0013\ti%BA\fDQ\u0016\u001c7.\u00138Ji\u0016l7\u000fV8J]Z,g\u000e^8ssR\u0011qf\u0014\u0005\u0006w!\u0001\r\u0001\u0015\t\u0003KEK!A\u0015\u0006\u0003'I+g.Y7f\u0013:4XM\u001c;pefLE/Z7")
public class InventoryCommandHandlers
implements CommandHandler {
    private final Repository repository;

    @Override
    public PartialFunction<Command, Future<BoxedUnit>> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InventoryCommandHandlers $outer;

            public final <A1 extends Command, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CreateInventoryItem) {
                    CreateInventoryItem createInventoryItem = (CreateInventoryItem)A1;
                    object = this.$outer.handle(createInventoryItem);
                } else if (A1 instanceof DeactivateInventoryItem) {
                    DeactivateInventoryItem deactivateInventoryItem = (DeactivateInventoryItem)A1;
                    object = this.$outer.handle(deactivateInventoryItem);
                } else if (A1 instanceof RemoveItemsFromInventory) {
                    RemoveItemsFromInventory removeItemsFromInventory = (RemoveItemsFromInventory)A1;
                    object = this.$outer.handle(removeItemsFromInventory);
                } else if (A1 instanceof CheckInItemsToInventory) {
                    CheckInItemsToInventory checkInItemsToInventory = (CheckInItemsToInventory)A1;
                    object = this.$outer.handle(checkInItemsToInventory);
                } else if (A1 instanceof RenameInventoryItem) {
                    RenameInventoryItem renameInventoryItem = (RenameInventoryItem)A1;
                    object = this.$outer.handle(renameInventoryItem);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Command x1) {
                Command command = x1;
                boolean bl = command instanceof CreateInventoryItem ? true : (command instanceof DeactivateInventoryItem ? true : (command instanceof RemoveItemsFromInventory ? true : (command instanceof CheckInItemsToInventory ? true : command instanceof RenameInventoryItem)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<BoxedUnit> handle(CreateInventoryItem c) {
        InventoryItem item = new InventoryItem(c.inventoryItemId(), c.name());
        return this.repository.save(item, 0);
    }

    public Future<BoxedUnit> handle(DeactivateInventoryItem c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.deactivate();
        return this.repository.save(item, c.originalVersion());
    }

    public Future<BoxedUnit> handle(RemoveItemsFromInventory c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.remove(c.count());
        return this.repository.save(item, c.originalVersion());
    }

    public Future<BoxedUnit> handle(CheckInItemsToInventory c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.checkIn(c.count());
        return this.repository.save(item, c.originalVersion());
    }

    public Future<BoxedUnit> handle(RenameInventoryItem c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.changeName(c.newName());
        return this.repository.save(item, c.originalVersion());
    }

    public InventoryCommandHandlers(Repository repository) {
        this.repository = repository;
    }
}

