/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.AggregateRootState;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.example.InventoryItem$;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemRenamed;
import net.glorat.cqrs.example.InventoryItemState;
import net.glorat.cqrs.example.ItemsCheckedInToInventory;
import net.glorat.cqrs.example.ItemsRemovedFromInventory;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a<Q!\u0005\n\t\u0002m1Q!\b\n\t\u0002yAQ!J\u0001\u0005\u0002\u0019BqaJ\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00044\u0003\u0001\u0006I!\u000b\u0004\u0005;I\u0001A\u0007C\u0003&\u000b\u0011\u0005Q\u0007C\u00048\u000b\u0001\u0007I\u0011\u000b\u001d\t\u000fq*\u0001\u0019!C){!11)\u0002Q!\neBQ\u0001R\u0003\u0005\u0002\u0015CQ!S\u0003\u0005\u0002)CQ!J\u0003\u0005\u0002mCQ\u0001[\u0003\u0005\u0002%DQ\u0001\\\u0003\u0005\u00025DQa]\u0003\u0005\u0002QDQA^\u0003\u0005\u0002]\fQ\"\u00138wK:$xN]=Ji\u0016l'BA\n\u0015\u0003\u001d)\u00070Y7qY\u0016T!!\u0006\f\u0002\t\r\f(o\u001d\u0006\u0003/a\taa\u001a7pe\u0006$(\"A\r\u0002\u00079,Go\u0001\u0001\u0011\u0005q\tQ\"\u0001\n\u0003\u001b%sg/\u001a8u_JL\u0018\n^3n'\t\tq\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\t\u0001B]3hSN$(/_\u000b\u0002SA!\u0001E\u000b\u00171\u0013\tY\u0013EA\u0005Gk:\u001cG/[8ocA\u0011QFL\u0007\u0002)%\u0011q\u0006\u0006\u0002\f\t>l\u0017-\u001b8Fm\u0016tG\u000f\u0005\u0002.c%\u0011!\u0007\u0006\u0002\u000e\u0003\u001e<'/Z4bi\u0016\u0014vn\u001c;\u0002\u0013I,w-[:uef\u00043CA\u00031)\u00051\u0004C\u0001\u000f\u0006\u0003\u0015\u0019H/\u0019;f+\u0005I\u0004CA\u0017;\u0013\tYDC\u0001\nBO\u001e\u0014XmZ1uKJ{w\u000e^*uCR,\u0017!C:uCR,w\fJ3r)\tq\u0014\t\u0005\u0002!\u007f%\u0011\u0001)\t\u0002\u0005+:LG\u000fC\u0004C\u0011\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013'\u0001\u0004ti\u0006$X\rI\u0001\tO\u0016$8\u000b^1uKV\ta\t\u0005\u0002\u001d\u000f&\u0011\u0001J\u0005\u0002\u0013\u0013:4XM\u001c;pefLE/Z7Ti\u0006$X-\u0001\u0002jIV\t1\n\u0005\u0002M1:\u0011QJ\u0016\b\u0003\u001dVs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005IS\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0002$\u0003\u0002\u0016-%\u0011q\u000bF\u0001\ba\u0006\u001c7.Y4f\u0013\tI&L\u0001\u0003H+&#%BA,\u0015)\r1DL\u0018\u0005\u0006;2\u0001\raS\u0001\u0004S\u0012|\u0006\"B0\r\u0001\u0004\u0001\u0017!\u00028b[\u0016|\u0006CA1f\u001d\t\u00117\r\u0005\u0002QC%\u0011A-I\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002eC\u0005Q1\r[1oO\u0016t\u0015-\\3\u0015\u0005yR\u0007\"B6\u000e\u0001\u0004\u0001\u0017a\u00028fo:\u000bW.Z\u0001\u0007e\u0016lwN^3\u0015\u0005yr\u0007\"B8\u000f\u0001\u0004\u0001\u0018!B2pk:$\bC\u0001\u0011r\u0013\t\u0011\u0018EA\u0002J]R\fqa\u00195fG.Le\u000e\u0006\u0002?k\")qn\u0004a\u0001a\u0006QA-Z1di&4\u0018\r^3\u0015\u0003y\u0002")
public class InventoryItem
extends AggregateRoot {
    private AggregateRootState state = new InventoryItemState(UUID.randomUUID(), false);

    public static Function1<DomainEvent, AggregateRoot> registry() {
        return InventoryItem$.MODULE$.registry();
    }

    @Override
    public AggregateRootState state() {
        return this.state;
    }

    @Override
    public void state_$eq(AggregateRootState x$1) {
        this.state = x$1;
    }

    @Override
    public InventoryItemState getState() {
        return (InventoryItemState)this.state();
    }

    @Override
    public UUID id() {
        return this.getState().id();
    }

    public void changeName(String newName) {
        if (newName.isEmpty()) {
            throw new Exception("newName");
        }
        this.applyChange(new InventoryItemRenamed(this.id(), newName), this.applyChange$default$2());
    }

    public void remove(int count) {
        if (count <= 0) {
            throw new Exception("cant remove negative count from inventory");
        }
        this.applyChange(new ItemsRemovedFromInventory(this.id(), count), this.applyChange$default$2());
    }

    public void checkIn(int count) {
        if (count <= 0) {
            throw new Exception("must have a count greater than 0 to add to inventory");
        }
        this.applyChange(new ItemsCheckedInToInventory(this.id(), count), this.applyChange$default$2());
    }

    public void deactivate() {
        if (!this.getState().activated()) {
            throw new Exception("already deactivated");
        }
        this.applyChange(new InventoryItemDeactivated(this.id()), this.applyChange$default$2());
    }

    public InventoryItem() {
    }

    public InventoryItem(UUID id_, String name_) {
        this();
        this.applyChange(new InventoryItemCreated(id_, name_), this.applyChange$default$2());
    }
}

