/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.ledger;

import com.google.api.core.ApiFuture;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.cloud.FirestoreClient;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.CommittedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.Repository;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\t\u0013\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ya\n\u0005\t[\u0001\u0011)\u0019!C\u0002]!Aq\u0007\u0001B\u0001B\u0003%q\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u0004@\u0001\t\u0007I\u0011\u0001!\t\r\u001d\u0003\u0001\u0015!\u0003B\u0011\u001dA\u0005A1A\u0005\u0002%Ca\u0001\u0016\u0001!\u0002\u0013Q\u0005bB+\u0001\u0005\u0004%\tA\u0016\u0005\u0007?\u0002\u0001\u000b\u0011B,\t\u000b\u0001\u0004A\u0011C1\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\tY\t\u0001C\u0001\u0003\u001b\u0013qBR5sKN$xN]3MK\u0012<WM\u001d\u0006\u0003'Q\ta\u0001\\3eO\u0016\u0014(BA\u000b\u0017\u0003\u00199Gn\u001c:bi*\tq#A\u0002oKR\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0015\u0003\u0011\u0019\u0017O]:\n\u0005\u0015\u0012#A\u0003*fa>\u001c\u0018\u000e^8ss\u0006\u0011Qm\u0019\t\u0003Q-j\u0011!\u000b\u0006\u0003Uq\t!bY8oGV\u0014(/\u001a8u\u0013\ta\u0013F\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00069am\u001c:nCR\u001cX#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014A\u00026t_:$4OC\u00015\u0003\ry'oZ\u0005\u0003mE\u0012qAR8s[\u0006$8/\u0001\u0005g_Jl\u0017\r^:!\u0003\u0019a\u0014N\\5u}Q\t!\bF\u0002<{y\u0002\"\u0001\u0010\u0001\u000e\u0003IAQA\n\u0003A\u0004\u001dBQ!\f\u0003A\u0004=\na\u0001\\8hO\u0016\u0014X#A!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u001b\u0014!B:mMRR\u0017B\u0001$D\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aB8qi&|gn]\u000b\u0002\u0015B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\tM&\u0014XMY1tK*\u0011q\nU\u0001\u0007O>|w\r\\3\u000b\u0003E\u000b1aY8n\u0013\t\u0019FJA\bGSJ,'-Y:f\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013A\u00013c+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003%1\u0017N]3ti>\u0014XM\u0003\u0002]\u001d\u0006)1\r\\8vI&\u0011a,\u0017\u0002\n\r&\u0014Xm\u001d;pe\u0016\f1\u0001\u001a2!\u00039\u0011X-\u00193MS:,7OR8s\u0013\u0012,\"AY?\u0015\u0007\r\fi\u0001\u0006\u0002egB\u0019Q-\u001c9\u000f\u0005\u0019\\gBA4k\u001b\u0005A'BA5\u0019\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002m9\u00059\u0001/Y2lC\u001e,\u0017B\u00018p\u0005\r\u0019V-\u001d\u0006\u0003Yr\u0001\"!I9\n\u0005I\u0014#AD\"p[6LG\u000f^3e\u000bZ,g\u000e\u001e\u0005\u0006i.\u0001\u001d!^\u0001\u0003[\u001a\u00042A^=|\u001b\u00059(B\u0001=\u001d\u0003\u001d\u0011XM\u001a7fGRL!A_<\u0003\u00115\u000bg.\u001b4fgR\u0004\"\u0001`?\r\u0001\u0011)ap\u0003b\u0001\u007f\n\tA+\u0005\u0003\u0002\u0002\u0005\u001d\u0001cA\u000e\u0002\u0004%\u0019\u0011Q\u0001\u000f\u0003\u000f9{G\u000f[5oOB\u0019\u0011%!\u0003\n\u0007\u0005-!EA\u0006E_6\f\u0017N\\#wK:$\bbBA\b\u0017\u0001\u0007\u0011\u0011C\u0001\u0003S\u0012\u0004B!a\u0005\u0002$9!\u0011QCA\u0011\u001d\u0011\t9\"a\b\u000f\t\u0005e\u0011Q\u0004\b\u0004O\u0006m\u0011\"A\f\n\u0005U1\u0012BA\u0012\u0015\u0013\ta'%\u0003\u0003\u0002&\u0005\u001d\"\u0001B$V\u0013\u0012S!\u0001\u001c\u0012\u0002\tM\fg/\u001a\u000b\u0007\u0003[\tI$a\u0011\u0011\u000b!\ny#a\r\n\u0007\u0005E\u0012F\u0001\u0004GkR,(/\u001a\t\u00047\u0005U\u0012bAA\u001c9\t!QK\\5u\u0011\u001d\tY\u0004\u0004a\u0001\u0003{\t\u0011\"Y4he\u0016<\u0017\r^3\u0011\u0007\u0005\ny$C\u0002\u0002B\t\u0012Q\"Q4he\u0016<\u0017\r^3S_>$\bbBA#\u0019\u0001\u0007\u0011qI\u0001\u0010Kb\u0004Xm\u0019;fIZ+'o]5p]B\u00191$!\u0013\n\u0007\u0005-CDA\u0002J]R\fqaZ3u\u0005fLE-\u0006\u0003\u0002R\u0005]CCBA*\u0003K\n9\u0007\u0006\u0003\u0002V\u0005m\u0003c\u0001?\u0002X\u00111a0\u0004b\u0001\u00033\nB!!\u0001\u0002>!9\u0011QL\u0007A\u0004\u0005}\u0013AC3wS\u0012,gnY3%cA)a/!\u0019\u0002V%\u0019\u00111M<\u0003\u0011\rc\u0017m]:UC\u001eDq!a\u0004\u000e\u0001\u0004\t\t\u0002C\u0004\u0002j5\u0001\r!!\u0016\u0002\tQl\u0007\u000f\\\u0001\u000bO\u0016$()_%e\u001fB$X\u0003BA8\u0003w\"b!!\u001d\u0002\u0002\u0006\rE\u0003BA:\u0003{\u0002RaGA;\u0003sJ1!a\u001e\u001d\u0005\u0019y\u0005\u000f^5p]B\u0019A0a\u001f\u0005\ryt!\u0019AA-\u0011\u001d\tiF\u0004a\u0002\u0003\u007f\u0002RA^A1\u0003sBq!a\u0004\u000f\u0001\u0004\t\t\u0002C\u0004\u0002j9\u0001\r!!\u001f\u0002\u001b\u001d,G/\u00117m\u0007>lW.\u001b;t)\r!\u0017\u0011\u0012\u0005\b\u0003\u001fy\u0001\u0019AA\t\u0003\u0015\u0001XO]4f)\u0011\ti#a$\t\u000f\u0005=\u0001\u00031\u0001\u0002\u0012\u0001")
public class FirestoreLedger
implements Repository {
    private final ExecutionContext ec;
    private final Formats formats;
    private final Logger logger;
    private final FirebaseOptions options;
    private final Firestore db;

    public Formats formats() {
        return this.formats;
    }

    public Logger logger() {
        return this.logger;
    }

    public FirebaseOptions options() {
        return this.options;
    }

    public Firestore db() {
        return this.db;
    }

    public <T extends DomainEvent> Seq<CommittedEvent> readLinesForId(UUID id, Manifest<T> mf) {
        ApiFuture query = this.db().collection("users").document(id.toString()).collection("records").get();
        QuerySnapshot querySnapshot = (QuerySnapshot)query.get();
        List documents = querySnapshot.getDocuments();
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(documents).asScala()).map((Function1 & Serializable & scala.Serializable)document -> new CommittedEvent((DomainEvent)Serialization$.MODULE$.read(document.getString("event"), this.formats(), mf), UUID.fromString(document.getString("streamId")), (int)Predef$.MODULE$.Long2long(document.getLong("streamRevision"))), Buffer$.MODULE$.canBuildFrom());
    }

    @Override
    public Future<BoxedUnit> save(AggregateRoot aggregate, int expectedVersion) {
        Iterable<DomainEvent> evs = aggregate.getUncommittedChanges();
        IntRef i = IntRef.create((int)expectedVersion);
        Iterable cevs = (Iterable)evs.map((Function1 & Serializable & scala.Serializable)ev -> {
            ++i$1.elem;
            return new CommittedEvent((DomainEvent)ev, aggregate.id(), i$1.elem);
        }, Iterable$.MODULE$.canBuildFrom());
        CollectionReference records = this.db().collection("users").document(aggregate.id().toString()).collection("records");
        Seq futures = ((TraversableOnce)cevs.map((Function1 & Serializable & scala.Serializable)cev -> {
            scala.collection.immutable.Map data = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"streamId"), (Object)cev.streamId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"streamRevision"), (Object)BoxesRunTime.boxToLong((long)cev.streamRevision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event"), (Object)Serialization$.MODULE$.write((Object)cev.event(), this.formats()))}));
            java.util.Map javaData = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)data).asJava();
            ApiFuture fut = records.add(javaData);
            return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fut.get(), $this.ec);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Future ret = Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), this.ec).mapTo(ClassTag$.MODULE$.Unit());
        return ret;
    }

    @Override
    public <T extends AggregateRoot> T getById(UUID id, T tmpl, ClassTag<T> evidence$1) {
        return (T)((AggregateRoot)this.getByIdOpt(id, tmpl, evidence$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> tmpl));
    }

    public <T extends AggregateRoot> Option<T> getByIdOpt(UUID id, T tmpl, ClassTag<T> evidence$1) {
        Some some;
        try {
            Seq<CommittedEvent> cevs = this.readLinesForId(id, ManifestFactory$.MODULE$.Nothing());
            IntRef revision = IntRef.create((int)1);
            cevs.foreach((Function1 & Serializable & scala.Serializable)cev -> {
                FirestoreLedger.$anonfun$getByIdOpt$1(this, id, revision, tmpl, cev);
                return BoxedUnit.UNIT;
            });
            some = new Some(tmpl);
        }
        catch (IOException e) {
            this.logger().warn(new StringBuilder(25).append("getById(").append(id).append(") failed because ").append(e.getMessage()).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public Seq<CommittedEvent> getAllCommits(UUID id) {
        Seq<CommittedEvent> cevsOrig = this.readLinesForId(id, ManifestFactory$.MODULE$.Nothing());
        IntRef revision = IntRef.create((int)1);
        Seq cevs = (Seq)cevsOrig.filter((Function1 & Serializable & scala.Serializable)cev -> BoxesRunTime.boxToBoolean((boolean)FirestoreLedger.$anonfun$getAllCommits$1(this, id, revision, cev)));
        return cevs;
    }

    public Future<BoxedUnit> purge(UUID id) {
        java.lang.Iterable allDocRefs = this.db().collection("users").document(id.toString()).collection("records").listDocuments();
        Iterator it = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(allDocRefs.iterator()).asScala();
        Seq futures = it.map((Function1 & Serializable & scala.Serializable)docRef -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> docRef.delete().get(), $this.ec)).toSeq();
        return Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), this.ec).mapTo(ClassTag$.MODULE$.Unit());
    }

    public static final /* synthetic */ void $anonfun$getByIdOpt$1(FirestoreLedger $this, UUID id$1, IntRef revision$1, AggregateRoot tmpl$2, CommittedEvent cev) {
        block2: {
            UUID uUID = id$1;
            UUID uUID2 = cev.streamId();
            if (uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null) break block2;
            if (revision$1.elem == cev.streamRevision()) {
                tmpl$2.loadFromHistory((Traversable<DomainEvent>)((Traversable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DomainEvent[]{cev.event()}))), cev.streamRevision());
                ++revision$1.elem;
            } else {
                $this.logger().error(new StringBuilder(39).append(id$1).append(" has invalid CE at revision ").append(cev.streamRevision()).append(" is ignored").toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllCommits$1(FirestoreLedger $this, UUID id$2, IntRef revision$2, CommittedEvent cev) {
        boolean bl;
        UUID uUID = id$2;
        UUID uUID2 = cev.streamId();
        if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null)) {
            if (revision$2.elem == cev.streamRevision()) {
                ++revision$2.elem;
                bl = true;
            } else {
                $this.logger().error(new StringBuilder(39).append(id$2).append(" has invalid CE at revision ").append(cev.streamRevision()).append(" is ignored").toString());
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public FirestoreLedger(ExecutionContext ec, Formats formats) {
        this.ec = ec;
        this.formats = formats;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.options = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.getApplicationDefault()).setDatabaseUrl("https://gainstrack-poc.firebaseio.com").build();
        FirebaseApp.initializeApp((FirebaseOptions)this.options());
        this.db = FirestoreClient.getFirestore();
    }
}

