/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.AggregateRootState;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.example.InventoryItem$;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemRenamed;
import net.glorat.cqrs.example.InventoryItemState;
import net.glorat.cqrs.example.ItemsCheckedInToInventory;
import net.glorat.cqrs.example.ItemsRemovedFromInventory;
import scala.Function1;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Us!B\n\u0015\u0011\u0003ib!B\u0010\u0015\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%\tA\u000b\u0005\u00079\u0006\u0001\u000b\u0011B\u0016\t\u000fu\u000b!\u0019!C\u0001=\"1Q-\u0001Q\u0001\n}3Aa\b\u000b\u0001M\")qe\u0002C\u0001O\"9\u0011n\u0002a\u0001\n#R\u0007b\u00028\b\u0001\u0004%\tf\u001c\u0005\u0007k\u001e\u0001\u000b\u0015B6\t\u000bY<A\u0011A<\t\u000bm<A\u0011\u0001?\t\r\u001d:A\u0011AA\u000e\u0011\u001d\t)d\u0002C\u0001\u0003oAq!!\u0010\b\t\u0003\ty\u0004C\u0004\u0002L\u001d!\t!!\u0014\t\u000f\u0005Es\u0001\"\u0001\u0002T\u0005i\u0011J\u001c<f]R|'/_%uK6T!!\u0006\f\u0002\u000f\u0015D\u0018-\u001c9mK*\u0011q\u0003G\u0001\u0005GF\u00148O\u0003\u0002\u001a5\u00051q\r\\8sCRT\u0011aG\u0001\u0004]\u0016$8\u0001\u0001\t\u0003=\u0005i\u0011\u0001\u0006\u0002\u000e\u0013:4XM\u001c;pefLE/Z7\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005i\u0011\r\u001c7Fm\u0016tG\u000fV=qKN,\u0012a\u000b\t\u0004YE\u001aT\"A\u0017\u000b\u00059z\u0013!C5n[V$\u0018M\u00197f\u0015\t\u00014%\u0001\u0006d_2dWm\u0019;j_:L!AM\u0017\u0003\t1K7\u000f\u001e\u0019\u0003iy\u00022!\u000e\u001e=\u001b\u00051$BA\u001c9\u0003\u0011a\u0017M\\4\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0006\u00072\f7o\u001d\t\u0003{yb\u0001\u0001B\u0005@\u0001\u0005\u0005\t\u0011!B\u0001\u0001\n\u0011q,M\t\u0003\u0003N\u0013bA\u0011#H\u00156\u0003f\u0001B\"\u0001\u0001\u0005\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"AH#\n\u0005\u0019#\"!G%uK6\u001c(+Z7pm\u0016$gI]8n\u0013:4XM\u001c;pef\u0004\"A\b%\n\u0005%#\"!G%uK6\u001c8\t[3dW\u0016$\u0017J\u001c+p\u0013:4XM\u001c;pef\u0004\"AH&\n\u00051#\"\u0001G%om\u0016tGo\u001c:z\u0013R,W\u000eR3bGRLg/\u0019;fIB\u0011aDT\u0005\u0003\u001fR\u0011A#\u00138wK:$xN]=Ji\u0016l'+\u001a8b[\u0016$\u0007C\u0001\u0010R\u0013\t\u0011FC\u0001\u000bJ]Z,g\u000e^8ss&#X-\\\"sK\u0006$X\r\u001a\n\u0004)VKf\u0001B\"\u0001\u0001M\u0003\"AV,\u000e\u0003YI!\u0001\u0017\f\u0003\u0017\u0011{W.Y5o\u000bZ,g\u000e\u001e\t\u0003EiK!aW\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u001d\u0005dG.\u0012<f]R$\u0016\u0010]3tA\u0005A!/Z4jgR\u0014\u00180F\u0001`!\u0011\u0011\u0003-\u00162\n\u0005\u0005\u001c#!\u0003$v]\u000e$\u0018n\u001c82!\t16-\u0003\u0002e-\ti\u0011iZ4sK\u001e\fG/\u001a*p_R\f\u0011B]3hSN$(/\u001f\u0011\u0014\u0005\u001d\u0011G#\u00015\u0011\u0005y9\u0011!B:uCR,W#A6\u0011\u0005Yc\u0017BA7\u0017\u0005I\tum\u001a:fO\u0006$XMU8piN#\u0018\r^3\u0002\u0013M$\u0018\r^3`I\u0015\fHC\u00019t!\t\u0011\u0013/\u0003\u0002sG\t!QK\\5u\u0011\u001d!(\"!AA\u0002-\f1\u0001\u001f\u00132\u0003\u0019\u0019H/\u0019;fA\u0005Aq-\u001a;Ti\u0006$X-F\u0001y!\tq\u00120\u0003\u0002{)\t\u0011\u0012J\u001c<f]R|'/_%uK6\u001cF/\u0019;f\u0003\tIG-F\u0001~!\rq\u0018Q\u0003\b\u0004\u007f\u0006Ea\u0002BA\u0001\u0003\u001fqA!a\u0001\u0002\u000e9!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nq\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\r\t\u0019BF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9\"!\u0007\u0003\t\u001d+\u0016\n\u0012\u0006\u0004\u0003'1B#\u00025\u0002\u001e\u0005\u0005\u0002BBA\u0010\u001d\u0001\u0007Q0A\u0002jI~Cq!a\t\u000f\u0001\u0004\t)#A\u0003oC6,w\f\u0005\u0003\u0002(\u0005=b\u0002BA\u0015\u0003W\u00012!!\u0002$\u0013\r\ticI\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000552%\u0001\u0006dQ\u0006tw-\u001a(b[\u0016$2\u0001]A\u001d\u0011\u001d\tYd\u0004a\u0001\u0003K\tqA\\3x\u001d\u0006lW-\u0001\u0004sK6|g/\u001a\u000b\u0004a\u0006\u0005\u0003bBA\"!\u0001\u0007\u0011QI\u0001\u0006G>,h\u000e\u001e\t\u0004E\u0005\u001d\u0013bAA%G\t\u0019\u0011J\u001c;\u0002\u000f\rDWmY6J]R\u0019\u0001/a\u0014\t\u000f\u0005\r\u0013\u00031\u0001\u0002F\u0005QA-Z1di&4\u0018\r^3\u0015\u0003A\u0004")
public class InventoryItem
extends AggregateRoot {
    private AggregateRootState state = new InventoryItemState(UUID.randomUUID(), false);

    public static Function1<DomainEvent, AggregateRoot> registry() {
        return InventoryItem$.MODULE$.registry();
    }

    public static List<Class<? extends DomainEvent>> allEventTypes() {
        return InventoryItem$.MODULE$.allEventTypes();
    }

    @Override
    public AggregateRootState state() {
        return this.state;
    }

    @Override
    public void state_$eq(AggregateRootState x$1) {
        this.state = x$1;
    }

    @Override
    public InventoryItemState getState() {
        return (InventoryItemState)this.state();
    }

    @Override
    public UUID id() {
        return this.getState().id();
    }

    public void changeName(String newName) {
        if (newName.isEmpty()) {
            throw new Exception("newName");
        }
        this.applyChange(new InventoryItemRenamed(this.id(), newName), this.applyChange$default$2());
    }

    public void remove(int count) {
        if (count <= 0) {
            throw new Exception("cant remove negative count from inventory");
        }
        this.applyChange(new ItemsRemovedFromInventory(this.id(), count), this.applyChange$default$2());
    }

    public void checkIn(int count) {
        if (count <= 0) {
            throw new Exception("must have a count greater than 0 to add to inventory");
        }
        this.applyChange(new ItemsCheckedInToInventory(this.id(), count), this.applyChange$default$2());
    }

    public void deactivate() {
        if (!this.getState().activated()) {
            throw new Exception("already deactivated");
        }
        this.applyChange(new InventoryItemDeactivated(this.id()), this.applyChange$default$2());
    }

    public InventoryItem() {
    }

    public InventoryItem(UUID id_, String name_) {
        this();
        this.applyChange(new InventoryItemCreated(id_, name_), this.applyChange$default$2());
    }
}

