/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.ledger;

import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.firebase.cloud.FirestoreClient;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.CommittedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.EventStreamReceiver;
import net.glorat.cqrs.Repository;
import net.glorat.cqrs.RepositoryWithEntityStream;
import net.glorat.ledger.FirestoreLedger$;
import net.glorat.ledger.FirestoreLedgerConfig;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\t\u0013\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!A!\u0007\u0001BC\u0002\u0013\r1\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00035\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u001d!\u0005A1A\u0005\u0002\u0015Ca\u0001\u0014\u0001!\u0002\u00131\u0005bB'\u0001\u0005\u0004%\tA\u0014\u0005\u00077\u0002\u0001\u000b\u0011B(\t\u000bq\u0003A\u0011C/\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!,\u0001\t\u0003\nyKA\bGSJ,7\u000f^8sK2+GmZ3s\u0015\t\u0019B#\u0001\u0004mK\u0012<WM\u001d\u0006\u0003+Y\taa\u001a7pe\u0006$(\"A\f\u0002\u00079,Go\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003GQ\tAaY9sg&\u0011QE\t\u0002\u001b%\u0016\u0004xn]5u_JLx+\u001b;i\u000b:$\u0018\u000e^=TiJ,\u0017-\\\u0001\u0004G\u001a<\u0007C\u0001\u0015*\u001b\u0005\u0011\u0012B\u0001\u0016\u0013\u0005U1\u0015N]3ti>\u0014X\rT3eO\u0016\u00148i\u001c8gS\u001e\f!!Z2\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=b\u0012AC2p]\u000e,(O]3oi&\u0011\u0011G\f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fqAZ8s[\u0006$8/F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0004kg>tGg\u001d\u0006\u0002s\u0005\u0019qN]4\n\u0005m2$a\u0002$pe6\fGo]\u0001\tM>\u0014X.\u0019;tA\u00051A(\u001b8jiz\"\"aP\"\u0015\u0007\u0001\u000b%\t\u0005\u0002)\u0001!)1&\u0002a\u0002Y!)!'\u0002a\u0002i!)a%\u0002a\u0001O\u00051An\\4hKJ,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013b\nQa\u001d7gi)L!a\u0013%\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n!\u0001\u001a2\u0016\u0003=\u0003\"\u0001U-\u000e\u0003ES!AU*\u0002\u0013\u0019L'/Z:u_J,'B\u0001+V\u0003\u0015\u0019Gn\\;e\u0015\t1v+\u0001\u0004h_><G.\u001a\u0006\u00021\u0006\u00191m\\7\n\u0005i\u000b&!\u0003$je\u0016\u001cHo\u001c:f\u0003\r!'\rI\u0001\u000fe\u0016\fG\rT5oKN4uN]%e+\tq\u0016\u0010F\u0002`\u0003\u000b!\"\u0001Y8\u0011\u0007\u0005LGN\u0004\u0002cO:\u00111MZ\u0007\u0002I*\u0011Q\rG\u0001\u0007yI|w\u000e\u001e \n\u0003uI!\u0001\u001b\u000f\u0002\u000fA\f7m[1hK&\u0011!n\u001b\u0002\u0004'\u0016\f(B\u00015\u001d!\t\tS.\u0003\u0002oE\tq1i\\7nSR$X\rZ#wK:$\b\"\u00029\u000b\u0001\b\t\u0018AA7g!\r\u0011Xo^\u0007\u0002g*\u0011A\u000fH\u0001\be\u00164G.Z2u\u0013\t18O\u0001\u0005NC:Lg-Z:u!\tA\u0018\u0010\u0004\u0001\u0005\u000biT!\u0019A>\u0003\u0003Q\u000b\"\u0001`@\u0011\u0005mi\u0018B\u0001@\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!IA\u0001\u0013\r\t\u0019A\t\u0002\f\t>l\u0017-\u001b8Fm\u0016tG\u000fC\u0004\u0002\b)\u0001\r!!\u0003\u0002\u0005%$\u0007\u0003BA\u0006\u00037qA!!\u0004\u0002\u001a9!\u0011qBA\f\u001d\u0011\t\t\"!\u0006\u000f\u0007\r\f\u0019\"C\u0001\u0018\u0013\t)b#\u0003\u0002$)%\u0011\u0001NI\u0005\u0005\u0003;\tyB\u0001\u0003H+&#%B\u00015#\u0003a!wnY;nK:$Hk\\\"p[6LG\u000f^3e\u000bZ,g\u000e^\u000b\u0005\u0003K\ty\u0003\u0006\u0003\u0002(\u0005EBc\u00017\u0002*!1\u0001o\u0003a\u0002\u0003W\u0001BA];\u0002.A\u0019\u00010a\f\u0005\u000bi\\!\u0019A>\t\u000f\u0005M2\u00021\u0001\u00026\u0005AAm\\2v[\u0016tG\u000fE\u0002Q\u0003oI1!!\u000fR\u0005U\tV/\u001a:z\t>\u001cW/\\3oiNs\u0017\r]:i_R\fa\u0001\\5ti\u0016tW\u0003BA \u0003\u001f\"b!!\u0011\u0002R\u0005MC\u0003BA\"\u0003\u0013\u00022aGA#\u0013\r\t9\u0005\b\u0002\u0004\u0003:L\bB\u00029\r\u0001\b\tY\u0005\u0005\u0003sk\u00065\u0003c\u0001=\u0002P\u0011)!\u0010\u0004b\u0001w\"9\u0011q\u0001\u0007A\u0002\u0005%\u0001bBA+\u0019\u0001\u0007\u0011qK\u0001\u000ee\u0016<\u0017n\u001d;sCRLwN\\:\u0011\t\u0005L\u0017\u0011\f\t\u0004C\u0005m\u0013bAA/E\t\u0019RI^3oiN#(/Z1n%\u0016\u001cW-\u001b<fe\u0006!1/\u0019<f)\u0019\t\u0019'a\u001c\u0002zA)Q&!\u001a\u0002j%\u0019\u0011q\r\u0018\u0003\r\u0019+H/\u001e:f!\rY\u00121N\u0005\u0004\u0003[b\"\u0001B+oSRDq!!\u001d\u000e\u0001\u0004\t\u0019(A\u0005bO\u001e\u0014XmZ1uKB\u0019\u0011%!\u001e\n\u0007\u0005]$EA\u0007BO\u001e\u0014XmZ1uKJ{w\u000e\u001e\u0005\b\u0003wj\u0001\u0019AA?\u0003=)\u0007\u0010]3di\u0016$g+\u001a:tS>t\u0007cA\u000e\u0002\u0000%\u0019\u0011\u0011\u0011\u000f\u0003\u0007%sG/\u0001\u0006hKR\u0014\u00150\u00133PaR,B!a\"\u0002\u0014R1\u0011\u0011RAQ\u0003G#B!a#\u0002\u0018B)1$!$\u0002\u0012&\u0019\u0011q\u0012\u000f\u0003\r=\u0003H/[8o!\rA\u00181\u0013\u0003\u0007u:\u0011\r!!&\u0012\u0007q\f\u0019\bC\u0004\u0002\u001a:\u0001\u001d!a'\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0003s\u0003;\u000b\t*C\u0002\u0002 N\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\b\u0003\u000fq\u0001\u0019AA\u0005\u0011\u001d\t)K\u0004a\u0001\u0003#\u000bA\u0001^7qY\u0006iq-\u001a;BY2\u001cu.\\7jiN$2\u0001YAV\u0011\u001d\t9a\u0004a\u0001\u0003\u0013\tQ\u0001];sO\u0016$B!!\u001b\u00022\"9\u0011q\u0001\tA\u0002\u0005%\u0001")
public class FirestoreLedger
implements RepositoryWithEntityStream {
    private final FirestoreLedgerConfig cfg;
    private final ExecutionContext ec;
    private final Formats formats;
    private final Logger logger;
    private final Firestore db;

    @Override
    public <T extends AggregateRoot> T getById(UUID id, T tmpl, ClassTag<T> evidence$2) {
        return (T)Repository.getById$(this, id, tmpl, evidence$2);
    }

    public Formats formats() {
        return this.formats;
    }

    public Logger logger() {
        return this.logger;
    }

    public Firestore db() {
        return this.db;
    }

    public <T extends DomainEvent> Seq<CommittedEvent> readLinesForId(UUID id, Manifest<T> mf) {
        ApiFuture query = this.db().collection(this.cfg.mainCollectionName()).document(id.toString()).collection(this.cfg.subCollectionName()).orderBy("streamRevision").get();
        QuerySnapshot querySnapshot = (QuerySnapshot)query.get();
        java.util.List documents = querySnapshot.getDocuments();
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(documents).asScala()).map((Function1 & Serializable & scala.Serializable)document -> this.net$glorat$ledger$FirestoreLedger$$documentToCommittedEvent((QueryDocumentSnapshot)document, mf), Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public <T extends DomainEvent> CommittedEvent net$glorat$ledger$FirestoreLedger$$documentToCommittedEvent(QueryDocumentSnapshot document, Manifest<T> mf) {
        DomainEvent domainEvent = (DomainEvent)Serialization$.MODULE$.read(document.getString("event"), this.formats(), mf);
        return new CommittedEvent(domainEvent, UUID.fromString(document.getString("streamId")), (int)Predef$.MODULE$.Long2long(document.getLong("streamRevision")));
    }

    public <T extends DomainEvent> Object listen(UUID id, Seq<EventStreamReceiver> registrations, Manifest<T> mf) {
        CollectionReference records = this.db().collection(this.cfg.mainCollectionName()).document(id.toString()).collection(this.cfg.subCollectionName());
        return records.addSnapshotListener((EventListener)new EventListener<QuerySnapshot>(this, mf, registrations){
            private final /* synthetic */ FirestoreLedger $outer;
            private final Manifest mf$2;
            private final Seq registrations$1;

            public void onEvent(QuerySnapshot snapshots, FirestoreException e) {
                if (e != null) {
                    System.err.println(new StringBuilder(15).append("Listen failed: ").append(e).toString());
                    return;
                }
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(snapshots.getDocumentChanges()).asScala()).foreach((Function1 & Serializable & scala.Serializable)dc -> {
                    $anon$1.$anonfun$onEvent$1(this, dc);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onEvent$1($anon$1 $this, DocumentChange dc) {
                DocumentChange.Type type = dc.getType();
                if (DocumentChange.Type.ADDED.equals(type)) {
                    BoxedUnit boxedUnit;
                    try {
                        CommittedEvent ce = $this.$outer.net$glorat$ledger$FirestoreLedger$$documentToCommittedEvent(dc.getDocument(), $this.mf$2);
                        $this.registrations$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.handle(ce));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Exception e) {
                        $this.$outer.logger().error(e.toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (DocumentChange.Type.MODIFIED.equals(type)) {
                    $this.$outer.logger().error("Event stream modified!");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (DocumentChange.Type.REMOVED.equals(type)) {
                    $this.$outer.logger().error("Event stream element deleted!");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mf$2 = mf$2;
                this.registrations$1 = registrations$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onEvent$1$adapted(net.glorat.ledger.FirestoreLedger$$anon$1 com.google.cloud.firestore.DocumentChange ), $anonfun$onEvent$2(net.glorat.cqrs.CommittedEvent net.glorat.cqrs.EventStreamReceiver )}, serializedLambda);
            }
        });
    }

    @Override
    public Future<BoxedUnit> save(AggregateRoot aggregate, int expectedVersion) {
        Iterable<DomainEvent> evs = aggregate.getUncommittedChanges();
        IntRef i = IntRef.create((int)expectedVersion);
        Iterable cevs = (Iterable)evs.map((Function1 & Serializable & scala.Serializable)ev -> {
            ++i$1.elem;
            return new CommittedEvent((DomainEvent)ev, aggregate.id(), i$1.elem);
        }, Iterable$.MODULE$.canBuildFrom());
        CollectionReference records = this.db().collection(this.cfg.mainCollectionName()).document(aggregate.id().toString()).collection(this.cfg.subCollectionName());
        Seq futures = ((TraversableOnce)cevs.map((Function1 & Serializable & scala.Serializable)cev -> {
            scala.collection.immutable.Map data = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"streamId"), (Object)cev.streamId().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"streamRevision"), (Object)BoxesRunTime.boxToLong((long)cev.streamRevision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event"), (Object)Serialization$.MODULE$.write((Object)cev.event(), this.formats()))}));
            java.util.Map javaData = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)data).asJava();
            ApiFuture fut = records.add(javaData);
            return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fut.get(), $this.ec);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Future ret = Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), this.ec);
        return ret.map((Function1 & Serializable & scala.Serializable)x$2 -> {
            FirestoreLedger.$anonfun$save$4(x$2);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    @Override
    public <T extends AggregateRoot> Option<T> getByIdOpt(UUID id, T tmpl, ClassTag<T> evidence$1) {
        None$ none$;
        block3: {
            try {
                Seq<CommittedEvent> cevs = this.readLinesForId(id, ManifestFactory$.MODULE$.classType(DomainEvent.class));
                IntRef revision = IntRef.create((int)1);
                cevs.foreach((Function1 & Serializable & scala.Serializable)cev -> {
                    FirestoreLedger.$anonfun$getByIdOpt$1(this, id, revision, tmpl, cev);
                    return BoxedUnit.UNIT;
                });
                UUID uUID = tmpl.id();
                UUID uUID2 = id;
                if (uUID == null ? uUID2 != null : !((Object)uUID).equals(uUID2)) {
                    none$ = None$.MODULE$;
                    break block3;
                }
                none$ = new Some(tmpl);
            }
            catch (IOException e) {
                this.logger().warn(new StringBuilder(25).append("getById(").append(id).append(") failed because ").append(e.getMessage()).toString());
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    @Override
    public Seq<CommittedEvent> getAllCommits(UUID id) {
        Seq<CommittedEvent> cevsOrig = this.readLinesForId(id, ManifestFactory$.MODULE$.classType(DomainEvent.class));
        IntRef revision = IntRef.create((int)1);
        Seq cevs = (Seq)cevsOrig.filter((Function1 & Serializable & scala.Serializable)cev -> BoxesRunTime.boxToBoolean((boolean)FirestoreLedger.$anonfun$getAllCommits$1(this, id, revision, cev)));
        return cevs;
    }

    @Override
    public void purge(UUID id) {
        java.lang.Iterable allDocRefs = this.db().collection(this.cfg.mainCollectionName()).document(id.toString()).collection(this.cfg.subCollectionName()).listDocuments();
        Iterator it = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(allDocRefs.iterator()).asScala();
        Seq futures = it.map((Function1 & Serializable & scala.Serializable)docRef -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> docRef.delete().get(), $this.ec)).toSeq();
        Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), this.ec).mapTo(ClassTag$.MODULE$.Unit());
    }

    public static final /* synthetic */ void $anonfun$save$4(Seq x$2) {
    }

    public static final /* synthetic */ void $anonfun$getByIdOpt$1(FirestoreLedger $this, UUID id$1, IntRef revision$1, AggregateRoot tmpl$1, CommittedEvent cev) {
        block2: {
            UUID uUID = id$1;
            UUID uUID2 = cev.streamId();
            if (uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null) break block2;
            if (revision$1.elem == cev.streamRevision()) {
                tmpl$1.loadFromHistory((Traversable<DomainEvent>)((Traversable)new .colon.colon((Object)cev.event(), (List)Nil$.MODULE$)), cev.streamRevision());
                ++revision$1.elem;
            } else {
                $this.logger().error(new StringBuilder(39).append(id$1).append(" has invalid CE at revision ").append(cev.streamRevision()).append(" is ignored").toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllCommits$1(FirestoreLedger $this, UUID id$2, IntRef revision$2, CommittedEvent cev) {
        boolean bl;
        UUID uUID = id$2;
        UUID uUID2 = cev.streamId();
        if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null)) {
            if (revision$2.elem == cev.streamRevision()) {
                ++revision$2.elem;
                bl = true;
            } else {
                $this.logger().error(new StringBuilder(39).append(id$2).append(" has invalid CE at revision ").append(cev.streamRevision()).append(" is ignored").toString());
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public FirestoreLedger(FirestoreLedgerConfig cfg, ExecutionContext ec, Formats formats) {
        this.cfg = cfg;
        this.ec = ec;
        this.formats = formats;
        Repository.$init$(this);
        RepositoryWithEntityStream.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.db = FirestoreClient.getFirestore();
    }
}

