/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.ledger;

import java.io.Serializable;
import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.CommittedEvent;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.Repository;
import net.glorat.cqrs.RepositoryWithSingleStream;
import net.glorat.ledger.ConcurrencyException;
import net.glorat.ledger.EntityView;
import net.glorat.ledger.Logging;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\b\u0010\u0001YA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0011\n\u0001BC\u0002\u0013\r!\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dI\u0006\u00011A\u0005\u0002iCqA\u001a\u0001A\u0002\u0013\u0005q\r\u0003\u0004n\u0001\u0001\u0006Ka\u0017\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019\u0019\b\u0001)A\u0005a\")A\u000f\u0001C\u00015\")Q\u000f\u0001C!m\")a\u0010\u0001C!\u007f\nq\u0011J\\'f[>\u0014\u0018\u0010T3eO\u0016\u0014(B\u0001\t\u0012\u0003\u0019aW\rZ4fe*\u0011!cE\u0001\u0007O2|'/\u0019;\u000b\u0003Q\t1A\\3u\u0007\u0001\u0019B\u0001A\f\u001eGA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\t\u0002\t\r\f(o]\u0005\u0003E}\u0011!DU3q_NLGo\u001c:z/&$\bnU5oO2,7\u000b\u001e:fC6\u0004\"\u0001J\u0013\u000e\u0003=I!AJ\b\u0003\u000f1{wmZ5oO\u0006\u00012\u000f\u001e:fC6$vNU3wSNLwN\u001c\t\u00041%Z\u0013B\u0001\u0016\u001a\u0005\u0019y\u0005\u000f^5p]B!\u0001\u0004\f\u0018?\u0013\ti\u0013DA\u0005Gk:\u001cG/[8ocA\u0011qf\u000f\b\u0003aer!!\r\u001d\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b\u0016\u0003\u0019a$o\\8u}%\tA#\u0003\u0002\u0013'%\u0011\u0001%E\u0005\u0003u}\tq\u0001]1dW\u0006<W-\u0003\u0002={\t!q)V%E\u0015\tQt\u0004\u0005\u0002\u0019\u007f%\u0011\u0001)\u0007\u0002\u0004\u0013:$\u0018\u0001\u0003:fO&\u001cHO]=\u0011\taa3I\u0012\t\u0003=\u0011K!!R\u0010\u0003\u0017\u0011{W.Y5o\u000bZ,g\u000e\u001e\t\u0003=\u001dK!\u0001S\u0010\u0003\u001b\u0005;wM]3hCR,'k\\8u\u0003\t)7-F\u0001L!\tau*D\u0001N\u0015\tq\u0015$\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001U'\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u00051A(\u001b8jiz\"2\u0001V,Y)\t)f\u000b\u0005\u0002%\u0001!)\u0011*\u0002a\u0002\u0017\")q%\u0002a\u0001Q!)\u0011)\u0002a\u0001\u0005\u0006y1m\\7nSR$X\rZ#wK:$8/F\u0001\\!\ra\u0006m\u0019\b\u0003;~s!a\r0\n\u0003iI!AO\r\n\u0005\u0005\u0014'\u0001\u0002'jgRT!AO\r\u0011\u0005y!\u0017BA3 \u00059\u0019u.\\7jiR,G-\u0012<f]R\f1cY8n[&$H/\u001a3Fm\u0016tGo]0%KF$\"\u0001[6\u0011\u0005aI\u0017B\u00016\u001a\u0005\u0011)f.\u001b;\t\u000f1<\u0011\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\u0002!\r|W.\\5ui\u0016$WI^3oiN\u0004\u0013AC3oi&$\u0018PV5foV\t\u0001\u000f\u0005\u0002%c&\u0011!o\u0004\u0002\u000b\u000b:$\u0018\u000e^=WS\u0016<\u0018aC3oi&$\u0018PV5fo\u0002\n!#\u00197m\u0007>lW.\u001b;uK\u0012,e/\u001a8ug\u0006!1/\u0019<f)\r9(\u0010 \t\u0004\u0019bD\u0017BA=N\u0005\u00191U\u000f^;sK\")1\u0010\u0004a\u0001\r\u0006I\u0011mZ4sK\u001e\fG/\u001a\u0005\u0006{2\u0001\rAP\u0001\u0010Kb\u0004Xm\u0019;fIZ+'o]5p]\u0006Qq-\u001a;Cs&#w\n\u001d;\u0016\t\u0005\u0005\u00111\u0002\u000b\u0007\u0003\u0007\t9#a\u000b\u0015\t\u0005\u0015\u0011q\u0003\t\u00051%\n9\u0001\u0005\u0003\u0002\n\u0005-A\u0002\u0001\u0003\b\u0003\u001bi!\u0019AA\b\u0005\u0005!\u0016cAA\t\rB\u0019\u0001$a\u0005\n\u0007\u0005U\u0011DA\u0004O_RD\u0017N\\4\t\u0013\u0005eQ\"!AA\u0004\u0005m\u0011AC3wS\u0012,gnY3%cA1\u0011QDA\u0012\u0003\u000fi!!a\b\u000b\u0007\u0005\u0005\u0012$A\u0004sK\u001adWm\u0019;\n\t\u0005\u0015\u0012q\u0004\u0002\t\u00072\f7o\u001d+bO\"1\u0011\u0011F\u0007A\u00029\n!!\u001b3\t\u000f\u00055R\u00021\u0001\u0002\b\u0005!A/\u001c9m\u0001")
public class InMemoryLedger
implements RepositoryWithSingleStream,
Logging {
    private final Option<Function1<UUID, Object>> streamToRevision;
    private final ExecutionContext ec;
    private List<CommittedEvent> committedEvents;
    private final EntityView entityView;
    private Logger log;
    private volatile boolean bitmap$0;

    @Override
    public <T extends AggregateRoot> T getById(UUID id, T tmpl, ClassTag<T> evidence$2) {
        return (T)Repository.getById$(this, id, tmpl, evidence$2);
    }

    private Logger log$lzycompute() {
        InMemoryLedger inMemoryLedger = this;
        synchronized (inMemoryLedger) {
            if (!this.bitmap$0) {
                this.log = Logging.log$(this);
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public List<CommittedEvent> committedEvents() {
        return this.committedEvents;
    }

    public void committedEvents_$eq(List<CommittedEvent> x$1) {
        this.committedEvents = x$1;
    }

    public EntityView entityView() {
        return this.entityView;
    }

    public List<CommittedEvent> allCommittedEvents() {
        return this.committedEvents();
    }

    @Override
    public Future<BoxedUnit> save(AggregateRoot aggregate, int expectedVersion) {
        int latestVersion;
        if (this.streamToRevision.isDefined() && expectedVersion < (latestVersion = BoxesRunTime.unboxToInt((Object)((Function1)this.streamToRevision.get()).apply((Object)aggregate.id())))) {
            throw new ConcurrencyException(new StringBuilder(58).append("Trying to save aggregate from version ").append(expectedVersion).append(" when ").append(latestVersion).append(" already in DB").toString());
        }
        Iterable<DomainEvent> evs = aggregate.getUncommittedChanges();
        IntRef i = IntRef.create((int)expectedVersion);
        Iterable cevs = (Iterable)evs.map((Function1 & Serializable & scala.Serializable)ev -> {
            ++i$1.elem;
            return new CommittedEvent((DomainEvent)ev, aggregate.id(), i$1.elem);
        }, Iterable$.MODULE$.canBuildFrom());
        this.committedEvents_$eq((List<CommittedEvent>)((List)this.committedEvents().$plus$plus((GenTraversableOnce)cevs, List$.MODULE$.canBuildFrom())));
        Iterable foo = (Iterable)cevs.map((Function1 & Serializable & scala.Serializable)e -> this.entityView().handle((CommittedEvent)e), Iterable$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)foo, Iterable$.MODULE$.canBuildFrom(), this.ec()).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            InMemoryLedger.$anonfun$save$3(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    @Override
    public <T extends AggregateRoot> Option<T> getByIdOpt(UUID id, T tmpl, ClassTag<T> evidence$1) {
        return this.entityView().getByIdOpt(id, tmpl, evidence$1);
    }

    public static final /* synthetic */ void $anonfun$save$3(Iterable x$2) {
    }

    public InMemoryLedger(Option<Function1<UUID, Object>> streamToRevision, Function1<DomainEvent, AggregateRoot> registry, ExecutionContext ec) {
        this.streamToRevision = streamToRevision;
        this.ec = ec;
        Repository.$init$(this);
        Logging.$init$(this);
        this.committedEvents = Nil$.MODULE$;
        this.entityView = new EntityView(registry);
    }
}

