/*
 * Decompiled with CFR 0.152.
 */
package CQRS;

import CQRS.CheckInItemsToInventory;
import CQRS.Command;
import CQRS.CommandHandler;
import CQRS.CreateInventoryItem;
import CQRS.DeactivateInventoryItem;
import CQRS.IRepository;
import CQRS.InventoryItem;
import CQRS.RemoveItemsFromInventory;
import CQRS.RenameInventoryItem;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u000b\tA\u0012J\u001c<f]R|'/_\"p[6\fg\u000e\u001a%b]\u0012dWM]:\u000b\u0003\r\tAaQ)S'\u000e\u00011c\u0001\u0001\u0007\u0019A\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001a\u0004\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003\u001d\r{W.\\1oI\"\u000bg\u000e\u001a7fe\"A\u0011\u0003\u0001B\u0001B\u0003%!#\u0001\u0006sKB|7/\u001b;pef\u0004\"!D\n\n\u0005Q\u0011!aC%SKB|7/\u001b;pefDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtDC\u0001\r\u001a!\ti\u0001\u0001C\u0003\u0012+\u0001\u0007!\u0003C\u0003\u001c\u0001\u0011\u0005A$A\u0004sK\u000e,\u0017N^3\u0016\u0003u\u0001Ba\u0002\u0010!G%\u0011q\u0004\u0003\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0011Q\"I\u0005\u0003E\t\u0011qaQ8n[\u0006tG\r\u0005\u0002\bI%\u0011Q\u0005\u0003\u0002\u0005+:LG\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004iC:$G.\u001a\u000b\u0003G%BQA\u000b\u0014A\u0002-\n\u0011a\u0019\t\u0003\u001b1J!!\f\u0002\u0003'\r\u0013X-\u0019;f\u0013:4XM\u001c;pefLE/Z7\t\u000b\u001d\u0002A\u0011A\u0018\u0015\u0005\r\u0002\u0004\"\u0002\u0016/\u0001\u0004\t\u0004CA\u00073\u0013\t\u0019$AA\fEK\u0006\u001cG/\u001b<bi\u0016LeN^3oi>\u0014\u00180\u0013;f[\")q\u0005\u0001C\u0001kQ\u00111E\u000e\u0005\u0006UQ\u0002\ra\u000e\t\u0003\u001baJ!!\u000f\u0002\u00031I+Wn\u001c<f\u0013R,Wn\u001d$s_6LeN^3oi>\u0014\u0018\u0010C\u0003(\u0001\u0011\u00051\b\u0006\u0002$y!)!F\u000fa\u0001{A\u0011QBP\u0005\u0003\u007f\t\u0011qc\u00115fG.Le.\u0013;f[N$v.\u00138wK:$xN]=\t\u000b\u001d\u0002A\u0011A!\u0015\u0005\r\u0012\u0005\"\u0002\u0016A\u0001\u0004\u0019\u0005CA\u0007E\u0013\t)%AA\nSK:\fW.Z%om\u0016tGo\u001c:z\u0013R,W\u000e")
public class InventoryCommandHandlers
implements CommandHandler {
    private final IRepository repository;

    @Override
    public PartialFunction<Command, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InventoryCommandHandlers $outer;

            public final <A1 extends Command, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof CreateInventoryItem) {
                    CreateInventoryItem createInventoryItem = (CreateInventoryItem)A1;
                    this.$outer.handle(createInventoryItem);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof DeactivateInventoryItem) {
                    DeactivateInventoryItem deactivateInventoryItem = (DeactivateInventoryItem)A1;
                    this.$outer.handle(deactivateInventoryItem);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof RemoveItemsFromInventory) {
                    RemoveItemsFromInventory removeItemsFromInventory = (RemoveItemsFromInventory)A1;
                    this.$outer.handle(removeItemsFromInventory);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof CheckInItemsToInventory) {
                    CheckInItemsToInventory checkInItemsToInventory = (CheckInItemsToInventory)A1;
                    this.$outer.handle(checkInItemsToInventory);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof RenameInventoryItem) {
                    RenameInventoryItem renameInventoryItem = (RenameInventoryItem)A1;
                    this.$outer.handle(renameInventoryItem);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Command x2) {
                Command command = x2;
                boolean bl = command instanceof CreateInventoryItem ? true : (command instanceof DeactivateInventoryItem ? true : (command instanceof RemoveItemsFromInventory ? true : (command instanceof CheckInItemsToInventory ? true : command instanceof RenameInventoryItem)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void handle(CreateInventoryItem c) {
        InventoryItem item = new InventoryItem(c.inventoryItemId(), c.name());
        this.repository.save(item, -1);
    }

    public void handle(DeactivateInventoryItem c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.deactivate();
        this.repository.save(item, c.originalVersion());
    }

    public void handle(RemoveItemsFromInventory c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.remove(c.count());
        this.repository.save(item, c.originalVersion());
    }

    public void handle(CheckInItemsToInventory c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.checkIn(c.count());
        this.repository.save(item, c.originalVersion());
    }

    public void handle(RenameInventoryItem c) {
        InventoryItem item = this.repository.getById(c.inventoryItemId(), new InventoryItem(), ClassTag$.MODULE$.apply(InventoryItem.class));
        item.changeName(c.newName());
        this.repository.save(item, c.originalVersion());
    }

    public InventoryCommandHandlers(IRepository repository) {
        this.repository = repository;
    }
}

